/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink.GuideLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenChmTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenChmTask.class);
    private static boolean loading;
    private GuideLink guideLink;
    private String urlPathStr;

    public OpenChmTask(GuideLink guideLink, String urlPathStr) {
        this.guideLink = guideLink;
        this.urlPathStr = urlPathStr;
    }

    public static boolean isLoading() {
        return loading;
    }

    public static void setLoading(boolean loading) {
        OpenChmTask.loading = loading;
    }

    public GuideLink getGuideLink() {
        return this.guideLink;
    }

    public void setGuideLink(GuideLink guideLink) {
        this.guideLink = guideLink;
    }

    @Override
    public void run() {
        if (loading) {
            return;
        }
        this.openChmTask(this.urlPathStr);
    }

    private void openChmTask(String urlStr) {
        OpenChmTask.setLoadingStatus(true);
        try {
            this.doOpenChm(urlStr);
        }
        catch (RuntimeException e) {
            LOGGER.error("exec error", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("exec error", (Throwable)e);
        }
        OpenChmTask.setLoadingStatus(false);
    }

    private static void setLoadingStatus(boolean status) {
        loading = status;
    }

    private void doOpenChm(String urlStr) {
        if (!this.guideLink.isSelfDefine()) {
            OSCmdUtils.explorerFile(urlStr);
        } else {
            this.guideLink.selfDefineResponse();
        }
    }
}

