/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PicDialog
extends JDialog {
    private static final long serialVersionUID = 599942463259860258L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PicDialog.class);
    private static final String SAVEPATH_DEFAULT_ID = "picdialog_saveresult_path_id002";
    private static final long REQUIRED_FREE_DISK = 0x8000000L;
    private static final int BLANK_SPACE = 20;
    private static final int DESC_WIDTH = 450;
    private static final int DESC_HEIGHT = 50;
    private static final String DEFAULT_NAME = "picture.gif";
    private static final String DEFAULT_SUFFIX = "gif";
    private static final String LEFT_SEP = "/";
    private static final String RIGHT_SEP = "\\";
    private static final String PONIT = ".";
    private JButton saveBtn;
    private JButton closeBtn;
    private JEditorPane descLabel;
    private JLabel picLabel;
    private String picPath = "";
    private ImageIcon startImage;
    private ImageIcon mainImage;
    private String defaultName = "";
    private String defaultSuffix = "";
    private String imageDesc = "";
    private boolean isStartImg = true;

    public PicDialog(String title, String desc, Dimension size, String picPath, String startPicPath, Window parent) {
        super(parent);
        this.setTitle(title);
        this.setSize(size);
        this.setModal(true);
        this.setResizable(false);
        this.picPath = picPath;
        this.mainImage = new ImageIcon(picPath);
        this.startImage = new ImageIcon(startPicPath);
        this.defaultName = this.getDefaultName();
        this.defaultSuffix = this.getSuffix();
        this.imageDesc = desc;
        this.initUi();
        this.initListener();
        UiMethod.putScreenCenter((Window)this);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.saveBtn, "saveBtn");
        AutomateUtils.setNameAttribute(this.closeBtn, "closeBtn");
    }

    private void initUi() {
        JPanel panel = new JPanel();
        this.setContentPane(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        this.saveBtn = UiMethod.createButton((String)ResourceUtil.getString("bizpack.picdialog.btn.save"), (char)'S');
        this.closeBtn = UiMethod.createButton((String)ResourceUtil.getString("bizpack.supportdialog.close"), (char)'Q');
        this.picLabel = new JLabel(this.startImage);
        this.picLabel.setPreferredSize(new Dimension(this.startImage.getIconWidth(), this.startImage.getIconHeight()));
        if (!this.imageDesc.isEmpty()) {
            this.descLabel = UiMethod.createEditorPane();
            this.descLabel.setSize(450, 50);
            this.descLabel.setText(this.imageDesc);
            panel.add(this.descLabel);
            panel.add(Box.createVerticalStrut(20));
        }
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(this.picLabel);
        labelPanel.add(Box.createHorizontalGlue());
        panel.add(labelPanel);
        panel.add(Box.createVerticalStrut(20));
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 0));
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(this.saveBtn);
        btnPanel.add(Box.createHorizontalStrut(20));
        btnPanel.add(this.closeBtn);
        btnPanel.add(Box.createHorizontalStrut(20));
        panel.add(btnPanel);
        panel.add(Box.createVerticalStrut(20));
    }

    private void initListener() {
        if (this.descLabel != null) {
            this.descLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String url = e.getDescription();
                        FileUtils.openHtmlFile((String)url);
                    }
                }
            });
        }
        this.picLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseevent) {
                if (PicDialog.this.isStartImg) {
                    PicDialog.this.picLabel.setIcon(PicDialog.this.mainImage);
                    PicDialog.this.isStartImg = false;
                } else {
                    PicDialog.this.picLabel.setIcon(PicDialog.this.startImage);
                    PicDialog.this.isStartImg = true;
                }
            }
        });
        this.checkActoinListen();
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                PicDialog.this.dispose();
            }
        });
    }

    private void checkActoinListen() {
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String title = ResourceUtil.getString("bizpack.picdialog.desc.savefile");
                String selectedFile = ToolFileChooser.getSaveFilePath((String)title, (String)PicDialog.this.defaultSuffix, (Window)PicDialog.this, (String)PicDialog.this.defaultName, (String)PicDialog.SAVEPATH_DEFAULT_ID, (boolean)true, (Locale)Locale.getDefault());
                if (null == selectedFile) {
                    return;
                }
                File file = new File(selectedFile);
                if (!PicDialog.this.checkDiskFreeSpace(file)) {
                    DialogUtils.showInfoDialog((JDialog)PicDialog.this, (String)ResourceUtil.getString("bizpack.picdialog.remind.diskspacenotenough"));
                    return;
                }
                ProgressDialog progressDialog = new ProgressDialog((Window)PicDialog.this);
                ServiceTaskExecutor serviceTaskExecutor = new ServiceTaskExecutor(progressDialog);
                TaskResult taskresult = serviceTaskExecutor.execute((ServiceTask)new ExportTask(file));
                if (taskresult != null && taskresult.getResult() == TaskResult.Result.SUCCESS) {
                    DialogUtils.showInfoDialog((JDialog)PicDialog.this, (String)ResourceUtil.getString("bizpack.picdialog.info.exportsucceed"));
                } else {
                    DialogUtils.showErrorDialog((JDialog)PicDialog.this, (String)ResourceUtil.getString("bizpack.picdialog.info.exportsucceed"));
                }
            }
        });
    }

    private String getDefaultName() {
        if (this.picPath.lastIndexOf(LEFT_SEP) > 0) {
            return this.picPath.substring(this.picPath.lastIndexOf(LEFT_SEP) + 1);
        }
        if (this.picPath.lastIndexOf(RIGHT_SEP) > 0) {
            return this.picPath.substring(this.picPath.lastIndexOf(RIGHT_SEP) + 1);
        }
        return DEFAULT_NAME;
    }

    private boolean checkDiskFreeSpace(File file) {
        long freeSpace = file.getParentFile().getFreeSpace();
        return freeSpace >= 0x8000000L;
    }

    private String getSuffix() {
        if (this.defaultName.lastIndexOf(PONIT) > 0) {
            return this.defaultName.substring(this.defaultName.lastIndexOf(PONIT) + 1);
        }
        return DEFAULT_SUFFIX;
    }

    private class ExportTask
    extends ServiceTask {
        private File file;

        public ExportTask(File file) {
            this.file = file;
        }

        protected TaskResult doTask() {
            try {
                StreamUtils.copyFile(new File(PicDialog.this.picPath), this.file);
            }
            catch (Exception e) {
                LOGGER.error("copyfile err.", (Throwable)e);
                return new TaskResult(TaskResult.Result.FAILED);
            }
            return new TaskResult(TaskResult.Result.SUCCESS);
        }
    }
}

