/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableData;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectDiskDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JDialog;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDiskDialog
extends JDialog
implements INodeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectDiskDialog.class);
    private static final long serialVersionUID = 1L;
    private static final Dimension DIALOG_SIZE_550X651 = new Dimension(550, 651);
    private static final String METHOD = "retDialogData";
    private SelectDiskDialogLayout sddLayout = null;
    private String script = "";
    private String scriptPath;
    private String param = "";
    private String diskSN = "diskSN";
    private String key;
    private transient TableItem table;
    private ConcurrentHashMap<String, ArrayList<String>> selectDiskMap = (ConcurrentHashMap)BizPackageContext.getInstance().getJythonContext().getDict().get("selectDiskMap");

    public SelectDiskDialog(TableColumn data, String scriptPath, String key, Window parent) {
        super(parent);
        this.initLayout(data);
        this.initData(data, scriptPath, key);
        this.setTable();
        this.initListener();
    }

    private void initData(TableColumn data, String preScriptPath, String devIp) {
        this.key = devIp;
        this.table = data.getDetailDialogTable();
        this.script = data.getScript();
        this.param = data.getParam();
        this.scriptPath = preScriptPath;
        this.selectDiskMap.remove(devIp);
    }

    private void initLayout(TableColumn data) {
        this.setLayout(new BorderLayout());
        this.sddLayout = new SelectDiskDialogLayout(data);
        this.add((Component)this.sddLayout, "Center");
        this.setTitle(ResourceUtil.getString("bizpack.selectdisk.title"));
        this.sddLayout.getConfirmButton().setEnabled(false);
        UiMethod.setComponentSize((Dimension)this.getDialogSize(data), (Component[])new Component[]{this});
    }

    private Dimension getDialogSize(TableColumn data) {
        return data.getDialogSize() == null ? DIALOG_SIZE_550X651 : data.getDialogSize();
    }

    @Override
    public void requestFocus() {
        this.sddLayout.getConfirmButton().requestFocus();
    }

    private void initListener() {
        this.sddLayout.getConfirmButton().addActionListener(new ConfirmListener());
        this.sddLayout.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDiskDialog.this.exitWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectDiskDialog.this.exitWindow();
            }
        });
        ListSelectionModel tableSelectModel = this.sddLayout.getDeviceTable().getSelectionModel();
        tableSelectModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (SelectDiskDialog.this.sddLayout.getDeviceTable().getMarkedRows().isEmpty()) {
                    SelectDiskDialog.this.sddLayout.getConfirmButton().setEnabled(false);
                } else {
                    SelectDiskDialog.this.sddLayout.getConfirmButton().setEnabled(true);
                }
            }
        });
    }

    private void exitWindow() {
        WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString("bizpackage.desc.quite"));
        if (0 == wdialog.getValue()) {
            this.setDefaultCloseOperation(2);
            this.dispose();
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    public SelectDiskDialogLayout getSddLayout() {
        return this.sddLayout;
    }

    @Override
    public void fireNodeDelete(DevNode dev) {
    }

    @Override
    public void fireNodeModify(DevNode dev) {
    }

    private void setTable() {
        this.execFunc();
    }

    private void execFunc() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                try {
                    List fs = AsyncExcutor.execute((Window)SelectDiskDialog.this, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(SelectDiskDialog.this.scriptPath, SelectDiskDialog.this.script, SelectDiskDialog.METHOD, SelectDiskDialog.this.param)});
                    WaitDialogResult result = (WaitDialogResult)fs.get(0);
                    if (!WaitDialogResult.handleResult(SelectDiskDialog.this, result)) {
                        return;
                    }
                    ExecPyScriptTask task = result.getTask();
                    if (null == task) {
                        DialogUtils.showErrorDialog((JDialog)SelectDiskDialog.this, (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                        return;
                    }
                    SelectDiskDialog.this.initTableData();
                }
                catch (Exception e) {
                    LOGGER.error("execFunc", (Throwable)e);
                }
            }
        });
    }

    private void initTableData() {
        Map<String, Object> dict = BizPackageContext.getInstance().getJythonContext().getDict();
        this.table.getTableModel().removeAll();
        String json = (String)dict.get("retData");
        this.table.setJsonRetData(json);
        this.table.initFresh();
    }

    @Override
    public void fireNodeAdd(DevNode dev) {
    }

    private void closeWindow() {
        this.setDefaultCloseOperation(2);
        this.dispose();
    }

    private class ConfirmListener
    implements ActionListener {
        private ConfirmListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<String> keylist = this.getSelectDisks();
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("select disks:" + keylist + " for upgrade disk success.");
                }
            }
            catch (Exception e2) {
                LOGGER.error("Log records failed", (Throwable)e2);
            }
            if (keylist instanceof ArrayList) {
                SelectDiskDialog.this.selectDiskMap.put(SelectDiskDialog.this.key, (ArrayList)keylist);
            }
            SelectDiskDialog.this.closeWindow();
        }

        private List<String> getSelectDisks() {
            ArrayList<String> keylist = new ArrayList<String>();
            List selectRows = SelectDiskDialog.this.sddLayout.getDeviceTable().getMarkedRows();
            for (TableRow row : selectRows) {
                TableData oneRow = (TableData)row.getIdentifier();
                Map<String, String> id2Map = oneRow.getId2DataMap();
                String diskSn = id2Map.get(SelectDiskDialog.this.diskSN);
                keylist.add(diskSn);
            }
            return keylist;
        }
    }
}

