/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish;

import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoBoard;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish.FinishReplaceStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish.FinishReplaceStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish.comp.Prompt;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;

public class FinishReplaceStep
extends AbstractBizStep {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FinishReplaceStep.class);
    private static final String RETDATA = "retData_";
    private FinishReplaceStepLayout layout;
    private FinishReplaceStepCfg cfg;
    private ExecPyScriptTask finishTask;
    private String preScriptPath;
    private String pyName;
    private JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        if (stepConfig instanceof FinishReplaceStepCfg) {
            this.cfg = (FinishReplaceStepCfg)stepConfig;
            this.preScriptPath = this.getScriptPath();
            this.pyName = this.cfg.getScriptFile();
            super.setParamAbs(this.cfg.getParam());
            super.setBackwardAbs(this.cfg.isBackward());
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            this.layout = new FinishReplaceStepLayout(this.cfg);
            this.setDocLinkParentWindow(this.cfg);
        }
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.setCurStepID();
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        this.layout.init(this.cfg);
        super.setIndex(this.getStageIndex());
        this.chgWizState(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                List fs = AsyncExcutor.execute((Window)FinishReplaceStep.this.getParentWindow(), (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(FinishReplaceStep.this.preScriptPath, FinishReplaceStep.this.pyName, "initData", FinishReplaceStep.this.getParamAbs())});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                if (!WaitDialogResult.handleResult(FinishReplaceStep.this.getParentWindow(), result)) {
                    return;
                }
                FinishReplaceStep.this.finishTask = result.getTask();
                if (null == FinishReplaceStep.this.finishTask) {
                    DialogUtils.showErrorDialog((Window)FinishReplaceStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                if (!((Boolean)FinishReplaceStep.this.ssEnv.getDict().get("succ")).booleanValue()) {
                    String errText = (String)FinishReplaceStep.this.ssEnv.getDict().get("errMsg");
                    DialogUtils.showErrorDialog((Window)FinishReplaceStep.this.getParentWindow(), (String)errText);
                    return;
                }
                FinishReplaceStep.this.initData();
                IStep currentStep = BizPackageContext.getInstance().getCurrentStep();
                if (currentStep != null && currentStep instanceof FinishReplaceStep) {
                    ((FinishReplaceStep)currentStep).notifyObserver(AutoProcessStatus.DISPLAY);
                }
            }
        });
        return true;
    }

    private void initData() {
        List<Object> infos = this.cfg.getInfoList();
        for (Object object : infos) {
            if (object instanceof Prompt) {
                Prompt prompt = (Prompt)object;
                this.initPromptData(prompt);
                continue;
            }
            if (object instanceof InfoBoard) {
                InfoBoard infoBoard = (InfoBoard)object;
                this.initInfoBordData(infoBoard);
                continue;
            }
            if (!(object instanceof TableItem)) continue;
            TableItem tableItem = (TableItem)object;
            this.initTableBordData(tableItem);
        }
    }

    private void initPromptData(Prompt prompt) {
        if (prompt.getType().equals((Object)Prompt.PromptType.LABEL)) {
            return;
        }
        String id = this.getRetDataId(prompt.getId());
        Object data = this.ssEnv.getDict().get(id);
        if (null == data) {
            return;
        }
        String name = (String)data;
        prompt.setPromptTxt(name, this.cfg);
    }

    private void initInfoBordData(InfoBoard infoBoard) {
        String id = this.getRetDataId(infoBoard.getId());
        Object data = this.ssEnv.getDict().get(id);
        if (null == data) {
            return;
        }
        String json = (String)data;
        List<InfoItem> infoItems = infoBoard.getRefreshItems();
        Iterator<InfoItem> iterator = infoItems.iterator();
        while (iterator.hasNext()) {
            JSONObject object = new JSONObject(json);
            InfoItem infoItem = iterator.next();
            Object itemData = object.get(infoItem.getId());
            if (null == itemData) continue;
            String itemStr = (String)itemData;
            infoItem.setText(itemStr);
        }
    }

    private void initTableBordData(TableItem tableItem) {
        String id = this.getRetDataId(tableItem.getId());
        Object data = this.ssEnv.getDict().get(id);
        if (null == data) {
            return;
        }
        tableItem.setJsonRetData((String)data);
        tableItem.initFresh();
    }

    private String getRetDataId(String id) {
        return RETDATA + id;
    }

    public boolean ending() {
        if (BizPackageSceneUtils.isScene()) {
            BizPackageContext.getInstance().getBizpackageUserOpData().setTaskEndTime(DateUtil.toBeiJingTimeMillis(new Date()));
            BizPackageContext.getInstance().getBizpackageUserOpData().setTaskResult(UserOpTaskResult.SUCCESS);
            BizPackageContext.getInstance().saveJythonUserOpData();
            BizPackageContext.getInstance().saveOneUserOpData();
            BizPackageContext.getInstance().saveUserOpData();
            BizPackageSceneUtils.putResult("SUCCESS");
            String toolId = BizPackageContext.getInstance().getCurToolName();
            BizPackageSceneUtils.finishedScene(toolId);
            ApplicationContext.getInstance().fireToolStopped(toolId);
        }
        this.resetInfoBoardText();
        return true;
    }

    private void resetInfoBoardText() {
        try {
            List<Object> infos = this.cfg.getInfoList();
            for (Object object : infos) {
                if (!(object instanceof InfoBoard)) continue;
                InfoBoard infoBoard = (InfoBoard)object;
                List<InfoItem> infoItems = infoBoard.getRefreshItems();
                for (InfoItem infoItem : infoItems) {
                    infoItem.setText("");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("reset error.", (Throwable)e);
        }
    }

    public boolean flowExiting() {
        return this.cancel();
    }

    @Override
    public void onStepDialogDisplayed() {
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.outputResult(status);
        if (BizPackageContext.getInstance().getWizard() instanceof FlowWizardDialog) {
            FlowWizardDialog wizardDialog = (FlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(Navigation.COMPLETE);
        }
    }

    private void outputResult(AutoProcessStatus status) {
        String stepId = BizPackageContext.getInstance().getCurStepId();
        AutoProcessResult.getInstance().append(String.format(Locale.ROOT, "%s--------step: %s, result: %s", System.lineSeparator(), stepId, status.toString()));
    }
}

