/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoBoard;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish.comp.Prompt;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;

public class FinishReplaceStepCfg
extends BizStepConfig {
    private static final String SUMMARY_INFO = "summary-info";
    private static final String INFO_ITEM = "info-item";
    private static final String SUMMARY_TABLE = "summary-table";
    private static final String COLUMN = "column";
    private static final String PROMPT = "prompt";
    private String sucDesc = "";
    private List<Object> infoList = new ArrayList<Object>();

    @Override
    public void loadConfig(Element node) {
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        this.setSucDesc(this.getAttribute(node, "sucDesc", ""));
        String auto = this.getAttribute(node, "auto", "");
        if (auto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        String backwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(backwardStr);
        Collection<Element> elements = XmlUtils.getChildren(node);
        for (Element element : elements) {
            if (element.getTagName().equals(SUMMARY_INFO)) {
                InfoBoard infoBord = new InfoBoard();
                this.infoList.add(infoBord);
                infoBord.setName(this.getAttribute(element, "name", ""));
                infoBord.setId(this.getAttribute(element, "id", ""));
                this.loadInfoBord(element, infoBord);
                continue;
            }
            if (element.getTagName().equals(SUMMARY_TABLE)) {
                TableItem table = new TableItem(this.getId());
                table.setId(this.getAttribute(element, "id", ""));
                table.setName(this.getAttribute(element, "name", ""));
                this.infoList.add(table);
                this.loadTableItem(element, table);
                continue;
            }
            if (!element.getTagName().equals(PROMPT)) continue;
            Prompt prompt = new Prompt();
            this.infoList.add(prompt);
            this.loadPrompt(element, prompt);
        }
        this.parseCommon(node);
    }

    private void loadInfoBord(Element element, InfoBoard infoBord) {
        Collection<Element> infos = XmlUtils.getChildren(element, INFO_ITEM);
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        List<InfoItem> refreshItems = infoBord.getRefreshItems();
        for (Element info : infos) {
            String itemId = this.getAttribute(info, "id", "");
            String label = this.getAttribute(info, "label", "");
            InfoItem refreshItem = new InfoItem(this);
            refreshItem.setId(itemId);
            refreshItem.setLabelText(util.getString(label));
            refreshItems.add(refreshItem);
        }
    }

    private void loadTableItem(Element element, TableItem table) {
        Collection<Element> cols = XmlUtils.getChildren(element, COLUMN);
        List<TableColumn> columnIdList = table.getColumnIdList();
        for (Element col : cols) {
            String itemId = this.getAttribute(col, "id", "");
            String name = this.getAttribute(col, "name", "");
            String visible = this.getAttribute(col, "visible", "");
            TableColumn selectTableColumn = new TableColumn();
            selectTableColumn.setId(itemId);
            selectTableColumn.setName(name);
            if (visible.trim().equalsIgnoreCase("false")) {
                selectTableColumn.setVisible(false);
            }
            columnIdList.add(selectTableColumn);
        }
    }

    private void loadPrompt(Element element, Prompt prompt) {
        String id = this.getAttribute(element, "id", "");
        String name = this.getAttribute(element, "name", "");
        String type = this.getAttribute(element, "type", "");
        prompt.setId(id);
        if (type.trim().equalsIgnoreCase(Prompt.PromptType.LABEL.toString())) {
            prompt.setType(Prompt.PromptType.LABEL);
            PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
            prompt.setName(util.getString(name));
        } else if (type.trim().equalsIgnoreCase(Prompt.PromptType.RETDATA.toString())) {
            prompt.setType(Prompt.PromptType.RETDATA);
        }
    }

    public List<Object> getInfoList() {
        return this.infoList;
    }

    public void setInfoList(List<Object> infoList) {
        this.infoList = infoList;
    }

    public String getSucDesc() {
        return this.sucDesc;
    }

    public void setSucDesc(String sucDesc) {
        this.sucDesc = sucDesc;
    }
}

