/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableData;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.ErrorDetailInfoDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.status.ExecStatus;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.MultiDevExecStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.MultiDevExecStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.item.ErrorInfoDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.item.ErrorMsgItem;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDevExecStep
extends AbstractBizStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiDevExecStep.class);
    private static final String MUL_PASSED_IMG = "success.gif";
    private static final String MUL_FAILED_IMG = "failed.gif";
    private static final String MUL_LOADING_IMG = "loading.gif";
    private static final int LAST_SECOND_INDEX = 2;
    private static final int DOUBLE_CLICK = 2;
    private static final String SUCC = "succ";
    private static final String FAIL = "fail";
    private static final String WAIT = "wait";
    private static final String BUSY = "busy";
    private static int failTaskCount = 0;
    private MultiDevExecStepLayout mulLayout;
    private MultiDevExecStepCfg mulCfg;
    private ExecPyScriptTask mulTask;
    private String mulScriptPath;
    private TableItem mulTable;
    private String mulPyName;
    private String mulSignKeyColId;
    private int mulDevMaxNum = 1;
    private ExecutorService mulThreadPool;
    private boolean mulFinish = true;
    private String curSelectTableRow = null;
    private int curSelectDetailRow = 0;
    private Map<String, List<Item>> totalTaskMap = new HashMap<String, List<Item>>();
    private Map<String, Map<String, Integer>> progressMap = new HashMap<String, Map<String, Integer>>();
    private String mode;
    private Map<String, ExecStatus> devStatusMap = new HashMap<String, ExecStatus>();

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        if (stepConfig instanceof MultiDevExecStepCfg) {
            this.mulCfg = (MultiDevExecStepCfg)stepConfig;
            this.mode = this.mulCfg.getMode().getKey();
            this.mulLayout = new MultiDevExecStepLayout(this.mulCfg);
            this.mulPyName = this.mulCfg.getScriptFile();
            this.mulScriptPath = this.getScriptPath();
            this.mulTable = this.mulCfg.getIoTable();
            super.setCancelScriptAbs(this.mulCfg.getCancelScript());
            super.setBackwardAbs(this.mulCfg.isBackward());
            super.setParamAbs(this.mulCfg.getParam());
            this.mulSignKeyColId = this.mulCfg.getSignColId();
            this.mulDevMaxNum = this.mulCfg.getMultiMaxNum();
            this.mulThreadPool = Executors.newFixedThreadPool(this.mulDevMaxNum);
            this.mulLayout.init(this.mulCfg);
            this.initListener();
            this.setDocLinkParentWindow(this.mulCfg);
        }
    }

    protected boolean init() {
        this.setCurStepID();
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        this.mulLayout.init(this.mulCfg);
        String checkBtnName = ResourceUtil.getString("bizpack.wizard.multiexec.btn." + this.mulCfg.getMode().getKey());
        this.mulLayout.getCheckButton().setText(checkBtnName);
        this.mulLayout.getCheckButton().setEnabled(true);
        UCD.formatMnemonicDisplay((AbstractButton)this.mulLayout.getCheckButton());
        super.setIndex(this.getStageIndex());
        this.initData();
        this.chgWizState(false);
        return true;
    }

    private void initSelect() {
        String signKey = (String)this.getSsEnv().getDict().get("select_signKey");
        if (signKey == null || "".equalsIgnoreCase(signKey)) {
            LOGGER.error("read selSignKey from script error");
            return;
        }
        JSONArray sel = (JSONArray)this.getSsEnv().getDict().get("select_data");
        if (sel == null) {
            LOGGER.error("read selections data from script error");
            return;
        }
        int size = sel.length();
        List rows = this.mulTable.getIsmTable().getAllRows();
        int index = 0;
        for (TableRow row : rows) {
            TableData oneRow = (TableData)row.getIdentifier();
            Map<String, String> id2Map = oneRow.getId2DataMap();
            String key = id2Map.get(signKey);
            for (int i = 0; i < size; ++i) {
                String selKey = sel.getString(i);
                if (!key.equalsIgnoreCase(selKey)) continue;
                this.mulTable.getIsmTable().getSelectionModel().addSelectionInterval(index, index);
            }
            ++index;
        }
    }

    private void initData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                Window parent = MultiDevExecStep.this.getParentWindow();
                List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(MultiDevExecStep.this.mulScriptPath, MultiDevExecStep.this.mulPyName, "initData", MultiDevExecStep.this.getParamAbs())});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                if (!WaitDialogResult.handleResult(MultiDevExecStep.this.getParentWindow(), result)) {
                    return;
                }
                MultiDevExecStep.this.mulTask = result.getTask();
                if (null == MultiDevExecStep.this.mulTask) {
                    DialogUtils.showErrorDialog((Window)MultiDevExecStep.this.getParentWindow(), (String)ResourceUtil.getString(""));
                    return;
                }
                if (!((Boolean)MultiDevExecStep.this.getSsEnv().getDict().get(MultiDevExecStep.SUCC)).booleanValue()) {
                    String errText = (String)MultiDevExecStep.this.getSsEnv().getDict().get("errMsg");
                    DialogUtils.showErrorDialog((Window)MultiDevExecStep.this.getParentWindow(), (String)errText);
                    return;
                }
                MultiDevExecStep.this.initTableData();
            }
        });
    }

    public FlowWizardCardLayout getLayout() {
        return this.mulLayout;
    }

    private void initTableData() {
        this.initFresh();
        this.initSelect();
    }

    private void initFresh() {
        Map<String, Object> contextDict = BizPackageContext.getInstance().getJythonContext().getDict();
        this.mulTable.getTableModel().removeAll();
        String json = (String)contextDict.get("retData_" + this.mulTable.getId());
        List<Map<String, String>> datas = this.mulTable.json2TableData(json);
        for (Map<String, String> oneRowMap : datas) {
            TableData oneRowData = new TableData();
            oneRowData.setDataIdList(this.mulTable.getColIdListOnly());
            oneRowData.setId2DataMap(oneRowMap);
            HashMap<String, Integer> proMap = new HashMap<String, Integer>();
            proMap.put("finish", 0);
            proMap.put("total", 0);
            this.progressMap.put(this.mulTable.getId(), proMap);
            this.devStatusMap = null;
            this.devStatusMap = new HashMap<String, ExecStatus>();
            this.devStatusMap.put(this.mulTable.getId(), ExecStatus.WAITING);
            this.mulTable.getTableModel().addRow(new TableRow[]{this.createTableRow(oneRowData)});
        }
        this.backToWaitingTable();
        this.totalTaskMap = null;
        this.totalTaskMap = new HashMap<String, List<Item>>();
        this.progressMap = null;
        this.progressMap = new HashMap<String, Map<String, Integer>>();
        failTaskCount = 0;
        this.mulLayout.getDetailListModel().removeAllElements();
        this.curSelectTableRow = null;
        this.curSelectDetailRow = 0;
    }

    private void backToWaitingTable() {
        List allRows = this.mulTable.getTableModel().getAllRows();
        for (TableRow row : allRows) {
            this.chgRowPreStatus(ExecStatus.WAITING.getKey(), row);
        }
    }

    private TableRow<?, ?> createTableRow(TableData oneRowData) {
        DefaultTableRow newRow = new DefaultTableRow(this.mulTable.getColumnNames().length, (Object)oneRowData, (Object)oneRowData);
        List<String> dataIdList = oneRowData.getDataIdList();
        Map<String, String> id2DataMap = oneRowData.getId2DataMap();
        int index = 0;
        for (String id : dataIdList) {
            String value = id2DataMap.get(id);
            if (null == value) {
                ++index;
                continue;
            }
            if (index == dataIdList.size() - 1) {
                this.setLastPreRowValue((TableRow<?, ?>)newRow, index, value);
                ++index;
                continue;
            }
            if (index == dataIdList.size() - 2) {
                newRow.setValueAt(index, (Object)"--");
                ++index;
                continue;
            }
            newRow.setValueAt(index, (Object)value);
            ++index;
        }
        return newRow;
    }

    private void initListener() {
        this.mulLayout.getCheckButton().addActionListener(new ExecActionListener());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiDevExecStep.this.mulTable.getIsmTable().getSelectionModel().addListSelectionListener(new TableSelectionListener());
                MultiDevExecStep.this.mulLayout.getDetailList().getSelectionModel().addListSelectionListener(new ListErrorDetailListener());
                MultiDevExecStep.this.mulLayout.getDetailList().addMouseListener(new DetailListDoubleClick());
            }
        });
    }

    private void buildFailedDialog(String devKey, String taskKey, ErrorMsgItem item) {
        Map devTaskMap = (Map)this.getSsEnv().getDict().get("devTaskMap");
        Map errText = (Map)((Map)devTaskMap.get(devKey)).get(taskKey);
        if (errText == null) {
            LOGGER.error("No error msg/info return from script.");
            return;
        }
        String errMsg = (String)errText.get("errMsg");
        String errType = (String)errText.get("errType");
        item.setErrorInfo(errMsg);
        List errInfoList = (List)errText.get("errInfoList");
        if (errInfoList != null) {
            item.setErrInfo(errInfoList);
        }
        if (errType.equalsIgnoreCase("type1")) {
            ErrorDetailInfoDialog dialog = new ErrorDetailInfoDialog(errMsg, this.getParentWindow());
            dialog.setVisible(true);
        } else if (errType.equalsIgnoreCase("type2")) {
            String errSource = (String)errText.get("errSource");
            item.setSourceInfo(errSource);
            ErrorInfoDialog dialog = new ErrorInfoDialog(this.getParentWindow(), item);
            dialog.setVisible(true);
        }
    }

    private boolean checkSelectionExec(List<TableRow> selectRows) {
        String str = "";
        if (this.mode.equalsIgnoreCase("exec")) {
            str = ResourceUtil.getString("bizpack.wizard.multiexec.hasdev.exec.info");
        } else if (this.mode.equalsIgnoreCase("check")) {
            str = ResourceUtil.getString("bizpack.wizard.multiexec.hasdev.check.info");
        }
        boolean hasDevExec = false;
        for (TableRow tableRow : selectRows) {
            String tabKey = (String)tableRow.getValueAt(0);
            if (this.devStatusMap.get(tabKey) != ExecStatus.EXECUTING) continue;
            hasDevExec = true;
        }
        if (hasDevExec) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)str);
            this.execExceptExit();
            return false;
        }
        return true;
    }

    private boolean checkAllDevExecFinish() {
        List allRows = this.mulTable.getIsmTable().getAllRows();
        for (TableRow tableRow : allRows) {
            String tabKey = (String)tableRow.getValueAt(0);
            if (this.devStatusMap.get(tabKey) != ExecStatus.EXECUTING) continue;
            return false;
        }
        return true;
    }

    private void refreshInit(List<TableRow> selectRows) {
        for (final TableRow row : selectRows) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDevExecStep.this.chgRowPreStatus(ExecStatus.WAITING.getKey(), row);
                    String progress = "--";
                    int col = row.getColumnCount() - 2;
                    row.setValueAt(col, (Object)progress);
                }
            });
        }
    }

    private void execOneDevTasks(final TableRow<?, ?> row) {
        String listPyName;
        List<Item> tasklist;
        BizPackageContext.getInstance().getJythonContext().clearMsgData();
        TableData oneRow = (TableData)row.getIdentifier();
        Map<String, String> id2Map = oneRow.getId2DataMap();
        String key = id2Map.get(this.mulSignKeyColId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("DevTaskThread starts: " + key);
        }
        JSONObject jsonTableData = new JSONObject(id2Map);
        this.setPrivateContext(key, jsonTableData);
        Map<String, Object> contextDict = BizPackageContext.getInstance().getJythonContext().getDict();
        this.devStatusMap.put(key, ExecStatus.EXECUTING);
        this.refreshStatus(row, 0, 0);
        this.mulLayout.getDetailListModel().removeAllElements();
        String initScriptInfo = (String)contextDict.get("initListScript");
        JSONObject jsonData = new JSONObject(initScriptInfo);
        String listScriptPath = (String)jsonData.get("scriptPath");
        if ("".equals(listScriptPath)) {
            listScriptPath = this.mulScriptPath;
        }
        if ((tasklist = this.initDevTaskList(listScriptPath, listPyName = (String)jsonData.get("pyName"), key)) == null) {
            this.chgRowPreStatus(ExecStatus.WAITING.getKey(), row);
            return;
        }
        this.refreshStatus(row, 0, tasklist.size());
        this.displayTaskList(tasklist, key);
        ExecStatus execStatus = this.autoExecTask(tasklist, key, row);
        this.devStatusMap.put(key, execStatus);
        final String status = execStatus.getKey();
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("exec task result " + key + ":" + status);
            }
        }
        catch (Exception e) {
            LOGGER.error("Log records failed", (Throwable)e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiDevExecStep.this.chgRowResultStatus(status, row);
            }
        });
    }

    private List<Item> initDevTaskList(String scriptPath, String pyName, String devKey) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("init device tasklist, device= " + devKey);
        }
        ExecPyScriptTask initDevTaskList = this.initOneTaskExecPy(scriptPath, pyName);
        initDevTaskList.execFunc("initExecList", devKey);
        Map devTaskMap = (Map)this.getSsEnv().getDict().get("devTaskMap");
        Map curDevTaskMap = (Map)devTaskMap.get(devKey);
        Object curDevTaskListData = curDevTaskMap.get("tasklist");
        if (curDevTaskListData == null) {
            LOGGER.error("get tasklist from python return failed. device= " + devKey);
            return null;
        }
        String tasklistData = (String)curDevTaskListData;
        JSONArray jsonArr = new JSONArray(tasklistData);
        List<Item> tasklist = this.getOneDevTaskList(jsonArr);
        this.totalTaskMap.put(devKey, tasklist);
        return tasklist;
    }

    private void displayTaskList(final List<Item> tasklist, final String rowKey) {
        if (tasklist == null) {
            LOGGER.info("tasklist not init ready yet");
            this.mulLayout.getDetailListModel().removeAllElements();
            return;
        }
        if (this.mulTable.getIsmTable().getMarkedRows().size() != 1) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (rowKey.equalsIgnoreCase(MultiDevExecStep.this.curSelectTableRow)) {
                    MultiDevExecStep.this.mulLayout.getDetailListModel().removeAllElements();
                    for (Item item : tasklist) {
                        this.displayByMode(item);
                    }
                }
            }

            private void displayByMode(Item item) {
                if (MultiDevExecStep.this.mulCfg.isDispAllTask()) {
                    MultiDevExecStep.this.mulLayout.getDetailListModel().addElement(item);
                } else if (item.getResult() != ItemResult.WAITCHECK && item.getResult() != ItemResult.WAITEXEC && item.getResult() != ItemResult.WAITING) {
                    MultiDevExecStep.this.mulLayout.getDetailListModel().addElement(item);
                }
            }
        });
    }

    private void chgRowResultStatus(String value, TableRow<?, ?> row) {
        int colSize = this.mulTable.getTableModel().getAllColumnCount();
        if (null == row) {
            return;
        }
        this.setLastRowResultValue(row, colSize - 1, value);
        this.mulTable.getIsmTable().updateUI();
    }

    private ExecStatus autoExecTask(List<Item> tasklist, String key, TableRow<?, ?> row) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("AutoExecTask task num = " + tasklist.size());
        }
        int curTaskIndex = 0;
        int succCnt = 0;
        int totalTask = tasklist.size();
        Map devTaskMap = (Map)this.getSsEnv().getDict().get("devTaskMap");
        Map curDevTaskMap = (Map)devTaskMap.get(key);
        for (Item task : tasklist) {
            this.displayTaskList(tasklist, key);
            curDevTaskMap.put("curTaskDataId_" + key, curTaskIndex);
            boolean isExecSucc = this.execOneTask(task, key);
            if (isExecSucc) {
                ++succCnt;
            } else {
                this.saveErrMsg(curDevTaskMap, key, curTaskIndex);
                if (task.isMustSucc()) {
                    ExecPyScriptTask pytask = this.initOneTaskExecPy(this.mulScriptPath, task.getScriptName());
                    pytask.execFunc("failureProc", key);
                    Boolean conProc = (Boolean)curDevTaskMap.get("continueProc");
                    if (!conProc.booleanValue()) {
                        int curIndex = curTaskIndex + 1;
                        this.setProgressRowValue(row, curIndex, totalTask);
                        break;
                    }
                }
                ++failTaskCount;
            }
            this.refreshStatus(row, ++curTaskIndex, totalTask);
        }
        if (succCnt == tasklist.size()) {
            return ExecStatus.SUCCEED;
        }
        if (succCnt < tasklist.size() && succCnt > 0) {
            return ExecStatus.PART_SUC;
        }
        return ExecStatus.FAILED;
    }

    private void saveErrMsg(Map<String, Object> curDevTaskMap, String devKey, int taskKey) {
        Object errMsgObj = curDevTaskMap.get("errMsg_" + devKey);
        if (errMsgObj == null || errMsgObj.equals("")) {
            LOGGER.error("get errMsg_" + devKey + " failed.");
            return;
        }
        Object errInfoObj = curDevTaskMap.get("errInfo_" + devKey);
        String errMsgData = (String)errMsgObj;
        JSONObject errMsgJson = new JSONObject(errMsgData);
        String errMsg = this.getInfoFromJson(errMsgJson, "errMsg", devKey);
        String errType = this.getInfoFromJson(errMsgJson, "errType", devKey);
        String errSource = this.getInfoFromJson(errMsgJson, "errSource", devKey);
        HashMap<String, Object> errMap = new HashMap<String, Object>();
        errMap.put("errMsg", errMsg);
        errMap.put("errType", errType);
        errMap.put("errSource", errSource);
        String errInfoData = (String)errInfoObj;
        if (errInfoData != null) {
            JSONArray errInfoJsonArr = new JSONArray(errInfoData);
            ArrayList errInfoList = new ArrayList();
            int size = errInfoJsonArr.length();
            for (int i = 0; i < size; ++i) {
                JSONObject errObj = errInfoJsonArr.getJSONObject(i);
                HashMap<String, String> errInfo = new HashMap<String, String>();
                errInfo.put("title", errObj.get("title").toString());
                errInfo.put("content", errObj.get("content").toString());
                errInfoList.add(errInfo);
            }
            errMap.put("errInfoList", errInfoList);
        }
        curDevTaskMap.put(Integer.toString(taskKey), errMap);
    }

    private String getInfoFromJson(JSONObject errMsgJson, String type, String devKey) {
        String info = null;
        if (errMsgJson.has(type)) {
            info = (String)errMsgJson.get(type);
        } else {
            info = "get " + type + " from script failed";
            LOGGER.error(type + " in errMsg_" + devKey + " does not exist.");
        }
        return info;
    }

    private boolean execOneTask(Item task, String key) {
        task.setDate(new Date());
        this.setTaskResult(task, BUSY);
        ExecPyScriptTask pytask = this.initOneTaskExecPy(this.mulScriptPath, task.getScriptName());
        pytask.execFunc("execute", key);
        Map devTaskMap = (Map)this.getSsEnv().getDict().get("devTaskMap");
        Map curDevTaskMap = (Map)devTaskMap.get(key);
        Object retDevData = curDevTaskMap.get("retTaskData_" + key);
        if (retDevData == null) {
            LOGGER.error("get retData_" + key + "failed.");
            this.setTaskResult(task, FAIL);
            return false;
        }
        String statusData = (String)retDevData;
        JSONObject statusJson = new JSONObject(statusData);
        String status = (String)statusJson.get("result");
        if (status == null) {
            LOGGER.error("get task retData" + key + " status failed.");
            this.setTaskResult(task, FAIL);
            return false;
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(key + ":" + task.getId() + " execute result " + status);
            }
        }
        catch (Exception e) {
            LOGGER.error("Log records failed", (Throwable)e);
        }
        if (status.trim().equals(ExecStatus.FAILED.getKey())) {
            this.setTaskResult(task, FAIL);
            return false;
        }
        this.setTaskResult(task, SUCC);
        return true;
    }

    private ExecPyScriptTask initOneTaskExecPy(String scriptPath, String pyName) {
        try {
            ExecPyScriptTask task = new ExecPyScriptTask(scriptPath, pyName);
            return task;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("py file {} not found", (Object)pyName);
        }
        catch (SignException e) {
            LOGGER.error("py file not signed", (Throwable)e);
        }
        return null;
    }

    private List<Item> getOneDevTaskList(JSONArray jsonArr) {
        if (jsonArr == null) {
            return null;
        }
        ArrayList<Item> tasklist = new ArrayList<Item>();
        int size = jsonArr.length();
        for (int i = 0; i < size; ++i) {
            JSONObject taskObj = jsonArr.getJSONObject(i);
            Item item = new Item();
            item.setDate("--");
            item.setId(taskObj.get("id").toString());
            item.setTitle(taskObj.get("name").toString());
            item.setScriptName(taskObj.get("script").toString());
            item.setDesc(taskObj.get("desc").toString());
            item.setParam(taskObj.get("param").toString());
            String mustSucc = taskObj.getString("mustSucc");
            if ("true".equalsIgnoreCase(mustSucc)) {
                item.setMustSucc(true);
            }
            this.setTaskResult(item, WAIT);
            tasklist.add(item);
        }
        return tasklist;
    }

    private synchronized void setPrivateContext(String key, JSONObject jsonData) {
        this.setOriContext(key, jsonData);
        this.setNewContext(key);
    }

    private void setOriContext(String key, JSONObject jsonData) {
        HashMap<String, String> curOriTaskMap;
        HashMap<String, HashMap<String, String>> oriTaskMap = (HashMap<String, HashMap<String, String>>)this.getSsEnv().getDict().get("taskMap");
        if (null == oriTaskMap) {
            oriTaskMap = new HashMap<String, HashMap<String, String>>();
            this.getSsEnv().getDict().put("taskMap", oriTaskMap);
        }
        if (null == (curOriTaskMap = (HashMap<String, String>)oriTaskMap.get(key))) {
            curOriTaskMap = new HashMap<String, String>();
            oriTaskMap.put(key, curOriTaskMap);
        }
        curOriTaskMap.put("curData", jsonData.toString());
        curOriTaskMap.put("errMsg", "");
        curOriTaskMap.put("retData", "");
    }

    private void setNewContext(String key) {
        HashMap<String, String> curDevTaskMap;
        HashMap<String, HashMap<String, String>> devTaskMap = (HashMap<String, HashMap<String, String>>)this.getSsEnv().getDict().get("devTaskMap");
        if (null == devTaskMap) {
            devTaskMap = new HashMap<String, HashMap<String, String>>();
            this.getSsEnv().getDict().put("devTaskMap", devTaskMap);
        }
        if (null == (curDevTaskMap = (HashMap<String, String>)devTaskMap.get(key))) {
            curDevTaskMap = new HashMap<String, String>();
            devTaskMap.put(key, curDevTaskMap);
        }
        curDevTaskMap.put("errMsg_" + key, "");
        curDevTaskMap.put("retTaskData_" + key, "");
    }

    private void chgRowPreStatus(String value, TableRow<?, ?> row) {
        int colSize = this.mulTable.getTableModel().getAllColumnCount();
        if (null == row) {
            return;
        }
        this.setLastPreRowValue(row, colSize - 1, value);
        this.mulTable.getIsmTable().updateUI();
    }

    private void setTaskResult(Item item, String result) {
        if (this.mode.equalsIgnoreCase("exec")) {
            if (result.equalsIgnoreCase(WAIT)) {
                item.setResult(ItemResult.WAITEXEC);
            } else if (result.equalsIgnoreCase(SUCC)) {
                item.setResult(ItemResult.SUCCEED);
            } else if (result.equalsIgnoreCase(FAIL)) {
                item.setResult(ItemResult.FAILED);
            } else if (result.equalsIgnoreCase(BUSY)) {
                item.setResult(ItemResult.EXECUTING);
            }
        } else if (result.equalsIgnoreCase(WAIT)) {
            item.setResult(ItemResult.WAITCHECK);
        } else if (result.equalsIgnoreCase(SUCC)) {
            item.setResult(ItemResult.PASS);
        } else if (result.equalsIgnoreCase(FAIL)) {
            item.setResult(ItemResult.NOT_PASS);
        } else if (result.equalsIgnoreCase(BUSY)) {
            item.setResult(ItemResult.CHECKING);
        }
    }

    private void setLastPreRowValue(TableRow<?, ?> row, int colIndex, String value) {
        if (null == value || "".equals(value)) {
            return;
        }
        if (value.trim().equals(ExecStatus.WAITING.getKey())) {
            String statusStr = ResourceUtil.getString("bizpack.wizard.multiexec.status." + this.mode + ".waiting");
            row.setValueAt(colIndex, (Object)new IsmTableCell.IconCell(null, statusStr));
            return;
        }
        if (value.trim().equals(ExecStatus.EXECUTING.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_LOADING_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.multiexec.status." + this.mode + ".executing");
            row.setValueAt(colIndex, (Object)new IsmTableCell.IconCell((Icon)icon, statusStr));
        }
    }

    public boolean ending() {
        this.saveSelections();
        if (this.mulCfg.isNextStepWarn()) {
            if (failTaskCount == 0) {
                return true;
            }
            ExecPyScriptTask pytask = this.initOneTaskExecPy(this.mulScriptPath, this.mulPyName);
            pytask.execFunc("nextStepWarn");
            Boolean nextProc = (Boolean)this.getSsEnv().getDict().get("nextProc");
            return nextProc;
        }
        return true;
    }

    private void saveSelections() {
        List selectRows = this.mulTable.getIsmTable().getMarkedRows();
        int size = selectRows.size();
        String[] selKeys = new String[size];
        for (int i = 0; i < size; ++i) {
            String key;
            TableRow row = (TableRow)selectRows.get(i);
            TableData oneRow = (TableData)row.getIdentifier();
            Map<String, String> id2Map = oneRow.getId2DataMap();
            selKeys[i] = key = id2Map.get(this.mulSignKeyColId);
        }
        JSONArray selKeyObj = new JSONArray(Arrays.asList(selKeys));
        this.getSsEnv().getDict().put("selKeys", selKeyObj);
    }

    public void chgMultiDevStepStatus(boolean isSucc) {
        final FlowWizardState state = this.getMultiDevStepUIState(isSucc, this.isBackwardAbs());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiDevExecStep.this.changeUIState(state);
            }
        });
    }

    private FlowWizardState getMultiDevStepUIState(boolean success, boolean enableBack) {
        FlowWizardState state = enableBack ? this.getMUIStateBackwizardEnable(success) : this.getMUIStateBackwizardDisable(success);
        return state;
    }

    private FlowWizardState getMUIStateBackwizardEnable(boolean isSucc) {
        FlowWizardState state = isSucc ? this.succEnableBackwizard() : this.failEnableBackwizard();
        return state;
    }

    private FlowWizardState failEnableBackwizard() {
        int curStep = this.getIndex();
        FlowWizardState state = curStep == 0 ? FlowWizardState.FIRST_STEP_RUNNING : (curStep > this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_FAILED : FlowWizardState.MIDDLE_STEP_FAILED);
        return state;
    }

    private FlowWizardState succEnableBackwizard() {
        int curStep = this.getIndex();
        FlowWizardState state = curStep == 0 ? FlowWizardState.FIRST_STEP : (curStep >= this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_PRE_SUC : FlowWizardState.MIDDLE_STEP);
        return state;
    }

    private FlowWizardState getMUIStateBackwizardDisable(boolean isSucc) {
        FlowWizardState state = isSucc ? this.succDisableBackwizard() : this.failDisableBackwizard();
        return state;
    }

    private FlowWizardState failDisableBackwizard() {
        FlowWizardState state = this.getIndex() == 0 ? FlowWizardState.FIRST_STEP_RUNNING : (this.getIndex() >= this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_RUNNING : FlowWizardState.MIDDLE_STEP_RUNNING);
        return state;
    }

    private FlowWizardState succDisableBackwizard() {
        FlowWizardState state = this.getIndex() == 0 ? FlowWizardState.FIRST_STEP : (this.getIndex() >= this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_SUCCESS : FlowWizardState.MIDDLE_STEP_SUCCESS);
        return state;
    }

    public void execExceptExit() {
        this.mulLayout.getCheckButton().setEnabled(true);
    }

    public boolean flowExiting() {
        if (!this.mulFinish) {
            String errInfo = ResourceUtil.getString("bizpack.wizard.multiexec.scriptrunning");
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)errInfo);
            return false;
        }
        return this.cancel();
    }

    private void setProgressRowValue(TableRow<?, ?> row, int finish, int total) {
        String progress = finish + "/" + total;
        int col = row.getColumnCount() - 2;
        row.setValueAt(col, (Object)progress);
    }

    private void setLastRowResultValue(TableRow<?, ?> row, int colIndex, String value) {
        if (null == value || "".equals(value)) {
            return;
        }
        if (value.trim().equals(ExecStatus.SUCCEED.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_PASSED_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.multiexec.status." + this.mode + ".success");
            IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, statusStr);
            row.setValueAt(colIndex, (Object)cell);
        } else if (value.trim().equals(ExecStatus.FAILED.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_FAILED_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.multiexec.status." + this.mode + ".failed");
            IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, statusStr);
            row.setValueAt(colIndex, (Object)cell);
        } else if (value.trim().equals(ExecStatus.PART_SUC.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_PASSED_IMG);
            ImageIcon icon1 = ResourceUtil.getImage(MUL_FAILED_IMG);
            if (this.mode.equalsIgnoreCase("check")) {
                String statusStr = ResourceUtil.getString("bizpack.wizard.multiexec.status." + this.mode + ".partsuc");
                IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon1, statusStr);
                row.setValueAt(colIndex, (Object)cell);
            } else {
                String statusStr = ResourceUtil.getString("bizpack.wizard.multiexec.status." + this.mode + ".partsuc");
                IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, statusStr);
                row.setValueAt(colIndex, (Object)cell);
            }
        } else {
            ImageIcon icon = ResourceUtil.getImage(MUL_LOADING_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.multiexec.status." + this.mode + ".executing");
            IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, statusStr);
            row.setValueAt(colIndex, (Object)cell);
            icon.setImageObserver((ImageObserver)this.mulTable.getIsmTable());
        }
    }

    private void refreshStatus(final TableRow<?, ?> row, final int curIdx, final int totalIdx) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiDevExecStep.this.chgRowResultStatus(ExecStatus.EXECUTING.getKey(), row);
                MultiDevExecStep.this.setProgressRowValue(row, curIdx, totalIdx);
            }
        });
    }

    public static void setFailTaskCount(int failTaskCount) {
        MultiDevExecStep.failTaskCount = failTaskCount;
    }

    public static int getFailTaskCount() {
        return failTaskCount;
    }

    private class ExecOneDevTask
    extends Thread {
        private TableRow<?, ?> row;

        public ExecOneDevTask(TableRow<?, ?> row) {
            this.row = row;
            this.setName();
        }

        private void setName() {
            TableData oneRow = (TableData)this.row.getIdentifier();
            Map<String, String> id2Map = oneRow.getId2DataMap();
            String key = id2Map.get(MultiDevExecStep.this.mulSignKeyColId);
            this.setName("OneDevTask Thread " + key);
        }

        @Override
        public void run() {
            MultiDevExecStep.this.execOneDevTasks(this.row);
        }
    }

    private class SelectExecThread
    extends Thread {
        private List<TableRow> selectRows;

        public SelectExecThread(List<TableRow> selectRows) {
            this.selectRows = selectRows;
        }

        @Override
        public void run() {
            MultiDevExecStep.this.mulFinish = false;
            MultiDevExecStep.this.setRunningUiStatus();
            LOGGER.info("Start select devices with tasks ######");
            if (null == MultiDevExecStep.this.mulTask) {
                DialogUtils.showErrorDialog((Window)MultiDevExecStep.this.getParentWindow(), (String)ResourceUtil.getString(""));
                MultiDevExecStep.this.execExceptExit();
                return;
            }
            if (!MultiDevExecStep.this.checkSelectionExec(this.selectRows)) {
                LOGGER.info("task failed. Part of device is doing.");
                return;
            }
            MultiDevExecStep.this.refreshInit(this.selectRows);
            MultiDevExecStep.this.mulThreadPool = Executors.newFixedThreadPool(MultiDevExecStep.this.mulDevMaxNum);
            for (TableRow tableRow : this.selectRows) {
                Future<?> future = MultiDevExecStep.this.mulThreadPool.submit(new ExecOneDevTask(tableRow));
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("return value is " + future);
            }
            MultiDevExecStep.this.mulThreadPool.shutdown();
            try {
                while (!MultiDevExecStep.this.mulThreadPool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("mulThreadPool query shutdown err", (Throwable)e);
            }
            MultiDevExecStep.this.mulLayout.getCheckButton().setEnabled(true);
            while (!MultiDevExecStep.this.checkAllDevExecFinish()) {
                MultiDevExecStep.this.checkAllDevExecFinish();
            }
            MultiDevExecStep.this.chgMultiDevStepStatus(true);
            MultiDevExecStep.this.mulFinish = true;
            LOGGER.info("End select devices with tasks ######");
        }
    }

    private class ExecActionListener
    implements ActionListener {
        private ExecActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectRows = MultiDevExecStep.this.mulTable.getIsmTable().getMarkedRows();
            failTaskCount = 0;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("select size = " + selectRows.size());
            }
            if (selectRows.isEmpty()) {
                String str = null;
                if (MultiDevExecStep.this.mode.equalsIgnoreCase("exec")) {
                    str = ResourceUtil.getString("bizpack.wizard.multiexec.nodev.exec.info");
                } else if (MultiDevExecStep.this.mode.equalsIgnoreCase("check")) {
                    str = ResourceUtil.getString("bizpack.wizard.multiexec.nodev.check.info");
                }
                DialogUtils.showInfoDialog((Window)MultiDevExecStep.this.getParentWindow(), (String)str);
                MultiDevExecStep.this.execExceptExit();
                return;
            }
            FlowWizardState state = MultiDevExecStep.this.getUIState(false, false);
            MultiDevExecStep.this.changeUIState(state);
            new SelectExecThread(selectRows).start();
            LOGGER.info("actionPerformed end");
        }
    }

    private class DetailListDoubleClick
    extends MouseAdapter {
        private DetailListDoubleClick() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() == 2) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("show detailError info :device= " + MultiDevExecStep.this.curSelectTableRow + " item=: " + MultiDevExecStep.this.curSelectDetailRow);
                }
                if (MultiDevExecStep.this.curSelectTableRow == null) {
                    return;
                }
                List items = (List)MultiDevExecStep.this.totalTaskMap.get(MultiDevExecStep.this.curSelectTableRow);
                Item item = null;
                if (items.size() <= MultiDevExecStep.this.curSelectDetailRow) {
                    return;
                }
                item = (Item)items.get(MultiDevExecStep.this.curSelectDetailRow);
                if (item == null) {
                    return;
                }
                ItemResult rlt = item.getResult();
                if (rlt.equals((Object)ItemResult.FAILED) || rlt.equals((Object)ItemResult.NOT_PASS)) {
                    ErrorMsgItem eItem = new ErrorMsgItem();
                    eItem.setResult(rlt);
                    MultiDevExecStep.this.buildFailedDialog(MultiDevExecStep.this.curSelectTableRow, Integer.toString(MultiDevExecStep.this.curSelectDetailRow), eItem);
                }
            }
        }
    }

    private class ListErrorDetailListener
    implements ListSelectionListener {
        private ListErrorDetailListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                MultiDevExecStep.this.curSelectDetailRow = MultiDevExecStep.this.mulLayout.getDetailList().getSelectedIndex();
            }
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            List rows = null;
            rows = MultiDevExecStep.this.mulTable.getIsmTable().getMarkedRows();
            if (rows.isEmpty()) {
                MultiDevExecStep.this.mulLayout.getDetailListModel().removeAllElements();
                return;
            }
            if (rows.size() == 1) {
                MultiDevExecStep.this.curSelectTableRow = (String)((TableRow)rows.get(0)).getValueAt(0);
            } else {
                MultiDevExecStep.this.mulLayout.getDetailListModel().removeAllElements();
            }
            MultiDevExecStep.this.displayTaskList((List)MultiDevExecStep.this.totalTaskMap.get(MultiDevExecStep.this.curSelectTableRow), MultiDevExecStep.this.curSelectTableRow);
        }
    }
}

