/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.PreSettingStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.ComponetFactory;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.IInputComponent;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.ItemGroup;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreSettingStepLayout
extends AbstractBizStepLayout {
    private static final long serialVersionUID = -4220350703780249179L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PreSettingStepLayout.class);
    private static final int BORDER_SIZE = 20;
    private static final int WIZARD_BLANK_SIZE = 45;
    private static final int LEFT_GAP = 11;
    private static final int RIGHT_GAP = 2;
    private static final String AUTOID = "autoId_";
    private static final String STATIC_TEXT = "#StaticText#";
    private JLabel tipsTxt = new JLabel();
    private JPanel inputPanel = new JPanel();
    private JPanel docLinkPanel = new JPanel();
    private JCheckBox check = new JCheckBox();
    private Map<String, IInputComponent> id2Component = new HashMap<String, IInputComponent>();

    public PreSettingStepLayout(PreSettingStepCfg preCfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(preCfg.getId(), this);
        this.initUi(preCfg);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.tipsTxt, "tipsTxt");
        AutomateUtils.setNameAttribute(this.inputPanel, "inputPanel");
        AutomateUtils.setNameAttribute(this.docLinkPanel, "docLinkPanel_preSettingStep");
        AutomateUtils.setNameAttribute(this.check, "check_preSettingStep");
    }

    private void initUi(PreSettingStepCfg cfg) {
        this.setBizCfg(cfg);
        JComponent view = null;
        ArrayList<Component> comps = new ArrayList<Component>();
        if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            comps.add(this.docLinkPanel);
        }
        comps.add(UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.tipsTxt}));
        comps.add(UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.inputPanel}));
        comps.add(Box.createVerticalGlue());
        if (!StringUtils.isNULLStr(cfg.getPromise())) {
            comps.add(UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.check}));
        }
        Component[] compArrs = comps.toArray(new Component[0]);
        view = UCD.buildVerticalBox(null, (Component[])compArrs);
        this.setViewInLayout(cfg, view, true);
    }

    public void init(PreSettingStepCfg preCfg) {
        List<String> groups = preCfg.getInputGroups();
        Map<String, ItemGroup> groupMap = preCfg.getItemsGroup();
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 1));
        for (String groupName : groups) {
            JPanel subInputPanel = this.createOneInputGroup(groupName, groupMap.get(groupName).getInputItems(), groupMap.get(groupName).getLayout());
            this.inputPanel.add(subInputPanel);
        }
        this.inputPanel.add(Box.createVerticalGlue());
    }

    private JPanel createOneInputGroup(String groupName, List<InputItem> inputItems, ItemGroup.GroupLayout layout) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        JPanel inPanel = new JPanel();
        inPanel.setLayout(new GridBagLayout());
        int gridy = 0;
        if (layout.equals((Object)ItemGroup.GroupLayout.SOUTH)) {
            this.addGlue(inPanel, gridy);
            ++gridy;
        }
        for (InputItem inputItem : inputItems) {
            if (this.createOneItemSuc(inputItem, inPanel, gridy)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("create one item[" + inputItem.getType() + "] succ");
                }
            } else {
                if (!inputItem.getType().contains("seperator")) continue;
                int count = Integer.valueOf(inputItem.getType().replace("seperator", ""));
                for (int i = 0; i < count; ++i) {
                    this.addBSep(inPanel, gridy);
                    ++gridy;
                }
            }
            ++gridy;
            if (!inputItem.getType().equals("labelArea")) continue;
            ++gridy;
        }
        if (!groupName.startsWith(AUTOID)) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(resource.getString(groupName));
            inPanel.setBorder(titledBorder);
        }
        if (layout.equals((Object)ItemGroup.GroupLayout.NORTH)) {
            this.addGlue(inPanel, gridy);
        }
        return inPanel;
    }

    private boolean createOneItemSuc(InputItem inputItem, JPanel inPanel, int gridy) {
        if (inputItem.getType().equals("text")) {
            this.addTextField(inputItem, inPanel, gridy);
        } else if (inputItem.getType().equals("pwdText")) {
            this.addTextField(inputItem, inPanel, gridy);
        } else if (inputItem.getType().equals("label")) {
            this.addLabel(inputItem, inPanel, gridy, false);
        } else if (inputItem.getType().equals("labelArea")) {
            this.addLabel(inputItem, inPanel, gridy, true);
        } else if (inputItem.getType().equals("dropDown")) {
            this.addDropDownBox(inputItem, inPanel, gridy);
        } else if (inputItem.getType().equals("filechooser")) {
            this.addFileChooser(inputItem, inPanel, gridy);
        } else if (inputItem.getType().equals("seperator")) {
            this.addSep(inPanel, gridy);
        } else {
            return false;
        }
        return true;
    }

    private void addGlue(JPanel inPanel, int gridy) {
        JLabel line = new JLabel(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        inPanel.add((Component)line, gridBagConstraints);
    }

    private void addDropDownBox(InputItem inputItem, JPanel groupPanel, int gridy) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String rule = inputItem.getRule();
        if (!StringUtils.isNULLStr(rule)) {
            rule = this.chgKey(rule);
        }
        String defaultValue = inputItem.getDefaultValue();
        String script = inputItem.getInitSript();
        String param = inputItem.getInitParam();
        if (!StringUtils.isNULLStr(script)) {
            ExecPyUtils.execInitScript(script, param, "initDropData");
            JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
            if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                String errMsg = (String)ssEnv.getDict().get("errMsg");
                LOGGER.error("init presetting step dropDown Text err." + errMsg);
            } else {
                String jsonStr = (String)ssEnv.getDict().get("retData");
                try {
                    JSONObject jsonObj = new JSONObject(jsonStr);
                    rule = jsonObj.getString("rule");
                    defaultValue = jsonObj.getString("default");
                }
                catch (Exception e) {
                    LOGGER.error("read dropDown Text err." + jsonStr);
                }
            }
        }
        IInputComponent text = ComponetFactory.getInstance().createComponent(inputItem.getType(), rule, defaultValue);
        int lenth = inputItem.getCompSpectLen();
        if (lenth > 0) {
            text.getComponent().setPreferredSize(new Dimension(lenth, 20));
        }
        this.id2Component.put(inputItem.getId(), text);
        JLabel label = new JLabel(resource.getString(inputItem.getLabel()));
        this.addGridBagCopLeft(groupPanel, label, 0, gridy, 0);
        this.addGridBagCopRight(groupPanel, text.getComponent(), 1, gridy, 1);
    }

    private void addFileChooser(InputItem inputItem, JPanel groupPanel, int gridy) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String script = inputItem.getInitSript();
        String param = inputItem.getInitParam();
        String rule = inputItem.getRule();
        if (!StringUtils.isNULLStr(script)) {
            ExecPyUtils.execInitScript(script, param, "initFileChooser");
            JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
            if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                String errMsg = (String)ssEnv.getDict().get("errMsg");
                LOGGER.error("init presetting step dropDown Text err." + errMsg);
            } else {
                String jsonStr;
                rule = jsonStr = (String)ssEnv.getDict().get("retData");
            }
        }
        IInputComponent text = ComponetFactory.getInstance().createComponent(inputItem.getType(), rule, "");
        int lenth = inputItem.getCompSpectLen();
        if (lenth > 0) {
            text.getComponent().setPreferredSize(new Dimension(lenth, 20));
        }
        this.id2Component.put(inputItem.getId(), text);
        JLabel label = new JLabel(resource.getString(inputItem.getLabel()));
        this.addGridBagCopLeft(groupPanel, label, 0, gridy, 0);
        this.addGridBagCopRight(groupPanel, text.getComponent(), 1, gridy, 1);
    }

    private String chgKey(String rule) {
        StringBuilder finalRulebBuilder = new StringBuilder();
        List<String> lanLists = this.chg2language(rule.split(","));
        if (!lanLists.isEmpty()) {
            finalRulebBuilder.append(lanLists.get(0));
        }
        for (int i = 1; i < lanLists.size(); ++i) {
            finalRulebBuilder.append(",");
            finalRulebBuilder.append(lanLists.get(i));
        }
        return finalRulebBuilder.toString();
    }

    private List<String> chg2language(String[] dropLists) {
        ArrayList<String> dropLanLists = new ArrayList<String>();
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        for (String dropOneKey : dropLists) {
            String dropOneLan = resutil.getString(dropOneKey);
            dropLanLists.add(dropOneLan);
        }
        return dropLanLists;
    }

    private void addTextField(InputItem inputItem, JPanel groupPanel, int gridy) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String defaultString = inputItem.getDefaultValue();
        String script = inputItem.getInitSript();
        String param = inputItem.getInitParam();
        if (!StringUtils.isNULLStr(script)) {
            ExecPyUtils.execInitScript(script, param, "getValue");
            JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
            if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                String errMsg = (String)ssEnv.getDict().get("errMsg");
                LOGGER.error("init presetting step TextField Text err." + errMsg);
            } else {
                defaultString = (String)ssEnv.getDict().get("retData");
            }
        }
        boolean isStatic = false;
        if (defaultString.startsWith(STATIC_TEXT)) {
            isStatic = true;
            defaultString = defaultString.replace(STATIC_TEXT, "");
        }
        IInputComponent text = ComponetFactory.getInstance().createComponent(inputItem.getType(), inputItem.getRule(), defaultString);
        this.id2Component.put(inputItem.getId(), text);
        if (text.getComponent() instanceof IsmTextField) {
            IsmTextField ismTextField = (IsmTextField)text.getComponent();
            if (isStatic) {
                ismTextField.setEditable(false);
            }
        } else if (text.getComponent() instanceof IsmPasswordField) {
            IsmPasswordField ismPasswordField = (IsmPasswordField)text.getComponent();
            ismPasswordField.setMinValidRestrict(inputItem.getMinContentLenght());
            ismPasswordField.setMaxValidRestrict(inputItem.getMaxContentLenght());
        }
        JLabel label = new JLabel(resource.getString(inputItem.getLabel()));
        this.addGridBagCopLeft(groupPanel, label, 0, gridy, 0);
        this.addGridBagCopRight(groupPanel, text.getComponent(), 1, gridy, 1);
    }

    private void addLabel(InputItem inputItem, JPanel groupPanel, int gridy, boolean isArea) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String defaultString = inputItem.getDefaultValue();
        String param = inputItem.getInitParam();
        String script = inputItem.getInitSript();
        if (!StringUtils.isNULLStr(script)) {
            ExecPyUtils.execInitScript(script, param, "getValue");
            JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
            if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                String errMsg = (String)ssEnv.getDict().get("errMsg");
                LOGGER.error("init presetting step lable Text err." + errMsg);
            } else {
                defaultString = (String)ssEnv.getDict().get("retData");
            }
        }
        IInputComponent text = ComponetFactory.getInstance().createComponent(inputItem.getType(), inputItem.getRule(), defaultString);
        text.setValue(defaultString);
        this.id2Component.put(inputItem.getId(), text);
        JLabel label = new JLabel(resource.getString(inputItem.getLabel()));
        this.addGridBagCopLeft(groupPanel, label, 0, gridy, 0);
        if (isArea) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = gridy;
            constraints.weightx = 1.0;
            constraints.gridheight = 2;
            constraints.insets = new Insets(0, 2, 12, 0);
            groupPanel.add((Component)text.getComponent(), constraints);
        } else {
            this.addGridBagCopRight(groupPanel, text.getComponent(), 1, gridy, 1);
        }
    }

    private void addSep(JPanel groupPanel, int gridy) {
        JLabel line = new JLabel();
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.fill = 0;
        bagConstraints.anchor = 17;
        bagConstraints.gridx = 0;
        bagConstraints.gridy = gridy;
        bagConstraints.weightx = 0.0;
        bagConstraints.insets = new Insets(8, 0, 0, 0);
        groupPanel.add((Component)line, bagConstraints);
    }

    private void addBSep(JPanel groupPanel, int gridy) {
        JLabel line = new JLabel(" ");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = gridy;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(8, 0, 0, 0);
        groupPanel.add((Component)line, constraints);
    }

    private void addGridBagCopLeft(JPanel parent, Component comp, int gridx, int gridy, int weightx) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.weightx = weightx;
        constraints.insets = new Insets(0, 11, 12, 0);
        parent.add(comp, constraints);
    }

    private void addGridBagCopRight(JPanel parent, Component comp, int gridx, int gridy, int weightx) {
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.fill = 0;
        bagConstraints.anchor = 17;
        bagConstraints.gridx = gridx;
        bagConstraints.gridy = gridy;
        bagConstraints.weightx = weightx;
        bagConstraints.insets = new Insets(0, 2, 12, 0);
        parent.add(comp, bagConstraints);
    }

    public void setTipsTxt(String ctipsTxt) {
        this.setJLabelText(this.tipsTxt, ctipsTxt, 45);
    }

    public Map<String, IInputComponent> getId2Component() {
        return this.id2Component;
    }

    public void setId2Component(Map<String, IInputComponent> id2Component) {
        this.id2Component = id2Component;
    }

    public JCheckBox getCheck() {
        return this.check;
    }

    public void setCheck(JCheckBox check) {
        this.check = check;
    }
}

