/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.select;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.InputConfirmPanel;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import utils.Products;

public class ReplaceInputConfirmDialog
extends PublicDialog {
    private static final long serialVersionUID = -6288716217430293719L;
    private ImageIcon tipImg = ResourceUtil.getImage("danger.png");
    private static final int DIALOG_WIDTH = 530;
    private static final int DIALOG_HEIGHT = 360;
    private static final List<String> BIG_FRAME_MODEL = Arrays.asList("xpu", "ipScaleOutIntf", "pcieIntf", "boxIntf");
    private JTextField usernameFiled;
    private JPasswordField passwordFiled;
    private String fruType;
    private boolean isOKClick = false;
    private DevNode devNode;
    private String[] tipParms;

    public boolean isOKClick() {
        return this.isOKClick;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public ReplaceInputConfirmDialog(DevNode devNodeInfo, String fruType, String[] params) {
        this.devNode = devNodeInfo;
        this.tipParms = (String[])params.clone();
        this.fruType = fruType;
        this.initTipUI();
    }

    public void initTipUI() {
        this.setModal(true);
        this.setTitle(ResourceUtil.getString("bizpack.select.comfirm.dlg.title"));
        this.getOkBtn().setEnabled(false);
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add(this.createUI(), "North");
        InputConfirmPanel inputConfirmPanel = new InputConfirmPanel(ResourceUtil.getString("bizpack.select.comfirm.dlg.checkbox"), "Yes", Collections.singletonList(this.getOkBtn()));
        this.getContentPanel().add((Component)UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), inputConfirmPanel}), "South");
        UiMethod.setComponentSize((Dimension)this.getDimensionByFruType(this.fruType), (Component[])new Component[]{this});
        this.pack();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        SwingUtil.putScreenCenter((Window)((Object)this));
        this.initListener();
    }

    @NotNull
    private Dimension getDimensionByFruType(String fruType) {
        if (BIG_FRAME_MODEL.contains(fruType)) {
            if (LanguageManager.isEnglish()) {
                return new Dimension(580, 500);
            }
            return new Dimension(530, 420);
        }
        return new Dimension(530, 360);
    }

    private Component createUI() {
        JTextArea tipsText = UiMethod.createJTextArea((String)ResourceUtil.getStringWithParams("bizpack.select.comfirm.dlg.tips", this.tipParms));
        JLabel usernameLabel = new JLabel(ResourceUtil.getString("bizpack.select.comfirm.dlg.uname"));
        JLabel passwordLabel = new JLabel(ResourceUtil.getString("bizpack.select.comfirm.dlg.pwd"));
        String username = this.getDevNode().getLoginUser().getUserName();
        if (Products.isOceanStoComputingDev((String)this.getDevNode().getDeviceType().toString())) {
            username = this.getDevNode().getComputeStorageDevNode().getOpenapiUser().getUserName();
        }
        this.usernameFiled = IsmTextField.getNameTextField((String)".*", (String)username, (int)60, (int)0);
        this.usernameFiled.setEditable(false);
        this.passwordFiled = UiMethod.getPasswordFiled();
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{usernameLabel, passwordLabel});
        UiMethod.setComponentSize((Dimension)new Dimension(150, 21), (Component[])new Component[]{this.usernameFiled, this.passwordFiled});
        Box userCom = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), usernameLabel, this.usernameFiled, Box.createHorizontalStrut(0)});
        Box pwdCom = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), passwordLabel, this.passwordFiled, Box.createHorizontalStrut(0)});
        JComponent reconinfocomp = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), tipsText, userCom, pwdCom});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{Box.createHorizontalStrut(0), new JLabel(this.tipImg), reconinfocomp, Box.createHorizontalStrut(0)}), Box.createVerticalStrut(0)});
    }

    private void initListener() {
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String username = ReplaceInputConfirmDialog.this.usernameFiled.getText();
                String password = String.valueOf(ReplaceInputConfirmDialog.this.passwordFiled.getPassword());
                if (StringUtils.hasNULLStr((String[])new String[]{username, password})) {
                    DialogUtils.showInfoDialog((JDialog)((Object)ReplaceInputConfirmDialog.this), (String)ResourceUtil.getString("bizpack.select.comfirm.dlg.uname.cannot.null"));
                    return;
                }
                String actualPassword = ReplaceInputConfirmDialog.this.getDevNode().getLoginUser().getPassword();
                if (Products.isOceanStoComputingDev((String)ReplaceInputConfirmDialog.this.getDevNode().getDeviceType().toString())) {
                    actualPassword = ReplaceInputConfirmDialog.this.getDevNode().getComputeStorageDevNode().getOpenapiUser().getPassword();
                }
                if (!password.equals(actualPassword)) {
                    DialogUtils.showInfoDialog((JDialog)((Object)ReplaceInputConfirmDialog.this), (String)ResourceUtil.getString("bizpack.select.comfirm.dlg.pwd.not.correct"));
                    return;
                }
                com.huawei.ism.tool.base.utils.StringUtils.cleanPwd(actualPassword);
                ReplaceInputConfirmDialog.this.isOKClick = true;
                ReplaceInputConfirmDialog.this.dispose();
            }
        });
    }
}

