/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.select;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.select.ReplaceInputConfirmDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.select.ReplaceTipConfirmDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.select.SelectForReplaceStep;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class ReplaceTip {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectForReplaceStep.class);
    private static final String[] TOOLTYPES = new String[]{"fru", "cru"};
    private static final String FRU_MODULE_CTRL = "controller";
    private static final String FRU_MODULE_SYSTEM_DISK = "systemDisk";
    private static final String FRU_MODULE_MEMORY = "memory";
    private static final String FRU_MODULE_RISK_POWER = "riskPower";
    private static final String FRU_MODULE_DISKDRAWER = "diskDrawer";
    private static final String FRU_MODULE_XPU = "xpu";
    private static final String FRU_MODULE_FAN = "fan";
    private static final String FRU_MODULE_IPSCALEOUT_INTF = "ipScaleOutIntf";
    private static final String FRU_MODULE_PCIE_INTF = "pcieIntf";
    private static final String FRU_MODULE_DISK = "disk";
    private static final String FRU_MODULE_DISKENC = "diskEnclosure";
    private static final String FRU_MODULE_CTRLENC = "controllerEnclosure";
    private static final String FRU_MODULE_IPSWITCH = "ipScaleOutSwitch";
    private static final String FRU_MODULE_PCIESWITCH = "pcieSwitch";
    private static final String FRU_MODULE_CABLEPCIE = "cablePCIe";
    private static final String FRU_MODULE_CABLESAS = "cableSas";
    private static final String FRU_MODULE_CABLEMGMT = "cableMgmt";
    private static final String FRU_MODULE_CABLEIPSCALEOUT = "ipScaleOutCable";
    private static final String FRU_MODULE_CABLEFRONTEND = "cableFrontEnd";
    private static final String FRU_MODULE_FRONTENDINTF = "frontEndIntf";
    private static final String FRU_MODULE_BACKENDINTF = "backEndIntf";
    private static final String FRU_MODULE_BBU = "bbu";
    private static final String FRU_MODULE_POWER = "power";
    private static final String FRU_MODULE_MANAGEBOARD = "manageBoard";
    private static final String FRU_MODULE_BOX_DISK = "boxDisk";
    private static final String FRU_MODULE_BOX_INTF = "boxIntf";
    private static final String BBU_SELECT_COMFIRM_DLG_SECOND = "30";
    private static final String CABLEIPSCALEOUT_TABNAME = "ipScaleOutCable.selectfru.frutab_port0.name";
    private static final String CABLEIPSCALEOUT_LOCNAME = "ipScaleOutCable.selectfru.tabcol.location";
    private static final Map<String, String[]> FRU_IDENTINFO_MAP = new ConcurrentHashMap<String, String[]>();
    private static final Map<String, String[]> FRU_IDENTINFO_MUTITABLE_MAP = new ConcurrentHashMap<String, String[]>();
    private static final String[] NEED_PWD_FRU_MODULE = new String[]{"diskEnclosure", "controllerEnclosure", "controller", "ipScaleOutIntf", "pcieIntf", "fan", "memory", "bbu", "diskDrawer", "xpu", "systemDisk", "boxDisk", "boxIntf"};
    private static final String[] NEED_APPENDTIP_FRU_MODULE = new String[]{"diskEnclosure", "controllerEnclosure", "controller", "ipScaleOutIntf", "pcieIntf", "disk", "fan", "boxDisk", "boxIntf", "systemDisk"};
    private static final String[] NEED_APPENDTIP_FOR_TIME_FRU_MODULE = new String[]{"backEndIntf", "frontEndIntf", "ipScaleOutIntf", "bbu", "power", "manageBoard", "fan"};
    private static final String[] DISK_FAULT_STATUS = new String[]{"Fault", "\u6545\u969c"};
    private static ReplaceTip instance = new ReplaceTip();

    private ReplaceTip() {
        if (FRU_IDENTINFO_MAP.isEmpty()) {
            FRU_IDENTINFO_MAP.put(FRU_MODULE_CABLEMGMT, new String[]{"startLoc", "cableMgmt.selectfru.frutab_port0.name"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_CABLEPCIE, new String[]{"cpLocation", "cablePCIe.selectfru.tabcol.cardportlocation"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_CABLESAS, new String[]{"startPortLoc", "cableSas.selectfru.frutab.startPort.location"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_CABLEFRONTEND, new String[]{"location", "cableFrontEnd.selectfru.tabcol.location"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_IPSWITCH, new String[]{"id", "id"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_DISKENC, new String[]{"name", "name"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_CTRLENC, new String[]{"name", "name"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_PCIESWITCH, new String[]{"name", "name"});
            FRU_IDENTINFO_MAP.put(FRU_MODULE_DISKDRAWER, new String[]{"name", "name"});
        }
        if (FRU_IDENTINFO_MUTITABLE_MAP.isEmpty()) {
            FRU_IDENTINFO_MUTITABLE_MAP.put(FRU_MODULE_CABLEMGMT, new String[]{"cableMgmt.selectfru.frutab_port0.name", "location"});
            FRU_IDENTINFO_MUTITABLE_MAP.put(FRU_MODULE_CABLEIPSCALEOUT, new String[]{CABLEIPSCALEOUT_TABNAME, CABLEIPSCALEOUT_LOCNAME});
        }
    }

    public static ReplaceTip getInstance() {
        return instance;
    }

    public boolean execTips(List<TableItem> selectTableItems) {
        try {
            if (!this.isNeedTips()) {
                return true;
            }
            List<JSONObject> selData = this.getSelData(selectTableItems);
            if (selData == null || selData.isEmpty()) {
                return false;
            }
            BizWizardConfig bwCfg = BizPackageContext.getInstance().getCurBizWizardCfg();
            String fruType = bwCfg.getId();
            String fruName = this.getFruName();
            List<String> needPwdList = Arrays.asList(NEED_PWD_FRU_MODULE);
            if (needPwdList.contains(fruType)) {
                if (fruType.equalsIgnoreCase(FRU_MODULE_FAN) && !this.hasConfirmTipForFan(selData.get(0))) {
                    return this.doReplaceTipConfirm(fruType, fruName, selData);
                }
                if (fruType.equalsIgnoreCase(FRU_MODULE_BBU) && !this.hasConfirmTipForFan(selData.get(0))) {
                    return this.doReplaceTipConfirm(fruType, fruName, selData);
                }
                return this.doReplaceInputConfirm(fruType, fruName, selData);
            }
            return this.doReplaceTipConfirm(fruType, fruName, selData);
        }
        catch (Exception e) {
            LOGGER.error("execTips Error", (Throwable)e);
            return true;
        }
    }

    private boolean isNeedTips() {
        BizPackage bPa = BizPackageContext.getInstance().getCurBizPackage();
        if (!TOOLTYPES[0].equalsIgnoreCase(bPa.getType()) && !TOOLTYPES[1].equalsIgnoreCase(bPa.getType())) {
            return false;
        }
        return !BizPackageSceneUtils.isFruEvalScene();
    }

    private String getFruName() {
        BizWizardConfig bwCfg = BizPackageContext.getInstance().getCurBizWizardCfg();
        String fruType = bwCfg.getId();
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String ofruName = resutil.getString(bwCfg.getTitle());
        String fruName = fruType.equalsIgnoreCase(FRU_MODULE_BBU) ? ofruName : (fruType.startsWith("ipScaleOut") ? ofruName.substring(0, 2).toUpperCase(Locale.ENGLISH).concat(ofruName.substring(2).toLowerCase(Locale.ENGLISH)) : ofruName.substring(0, 1).toUpperCase(Locale.ENGLISH).concat(ofruName.substring(1).toLowerCase(Locale.ENGLISH)));
        return fruName;
    }

    private List<JSONObject> getSelData(List<TableItem> selectTableItems) {
        if (selectTableItems == null) {
            LOGGER.error("execTips, selectTableItems is null.");
            return null;
        }
        try {
            ArrayList<JSONObject> selData = new ArrayList<JSONObject>();
            for (TableItem ti : selectTableItems) {
                Object aSelData;
                String selectedTb = (String)BizPackageContext.getInstance().getJythonContext().getDict().get(ti.getSelectTabelItemId());
                if (ti.isNeedMultiCheck()) {
                    aSelData = new JSONArray(selectedTb);
                    for (int i = 0; i < ((JSONArray)aSelData).length(); ++i) {
                        selData.add(((JSONArray)aSelData).getJSONObject(i));
                    }
                } else {
                    aSelData = new JSONObject(selectedTb);
                    selData.add((JSONObject)aSelData);
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("execTips, selected table data:" + selectedTb);
            }
            return selData;
        }
        catch (Exception e) {
            LOGGER.error("execTips, getSelData error.", (Throwable)e);
            return null;
        }
    }

    private boolean hasConfirmTipForFan(JSONObject jsonObject) {
        return jsonObject != null && jsonObject.has("hasConfirmTip") && jsonObject.getBoolean("hasConfirmTip");
    }

    private boolean doReplaceTipConfirm(String fruType, String fruName, List<JSONObject> selData) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("doReplaceTipConfirm, fruType=" + fruType + " | fruName=" + fruName);
        }
        String appendTip = this.getAppendTipInfo(fruType, fruName, selData);
        String fruIdentName = this.getFruIdentName(fruType, selData).toLowerCase(Locale.ENGLISH);
        String fruIdent = this.getFruIdentInfo(fruType, selData);
        ReplaceTipConfirmDialog repTipDialog = new ReplaceTipConfirmDialog(fruType, new String[]{fruName, fruIdentName, fruIdent, appendTip});
        repTipDialog.setModal(true);
        repTipDialog.setVisible(true);
        boolean isOk = repTipDialog.isOKClick();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("select result:" + isOk);
        }
        return isOk;
    }

    private boolean doReplaceInputConfirm(String fruType, String fruName, List<JSONObject> selData) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("doReplaceInputConfirm, fruType=" + fruType + " | fruName=" + fruName);
        }
        String appendTip = this.getAppendTipInfo(fruType, fruName, selData);
        String fruIdentName = this.getFruIdentName(fruType, selData).toLowerCase(Locale.ENGLISH);
        String fruIdent = this.getFruIdentInfo(fruType, selData);
        DevNode devNode = BizPackageContext.getInstance().getCurDevice();
        if (!"true".equalsIgnoreCase(System.getenv("fruSkipConfirm"))) {
            ReplaceInputConfirmDialog repInputDialog = new ReplaceInputConfirmDialog(devNode, fruType, new String[]{fruName, fruIdentName, fruIdent, appendTip});
            repInputDialog.setModal(true);
            repInputDialog.setVisible(true);
            boolean isOk = repInputDialog.isOKClick();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("select result:" + isOk);
            }
            if (!isOk) {
                return false;
            }
        }
        return true;
    }

    private String getAppendTipInfo(String fruType, String fruName, List<JSONObject> selData) {
        String appendInfo = "";
        String appendInfoTime = this.getAppendInfoTime(fruType, fruName);
        List<String> needAppendTipList = Arrays.asList(NEED_APPENDTIP_FRU_MODULE);
        if (FRU_MODULE_DISK.equals(fruType)) {
            String poolID = (String)selData.get(0).get("poolID");
            String healthStatus = (String)selData.get(0).get("healthStatus");
            if (!("".equals(poolID) || DISK_FAULT_STATUS[0].equals(healthStatus) || DISK_FAULT_STATUS[1].equals(healthStatus))) {
                appendInfo = ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.disk");
            }
            return appendInfo;
        }
        if (needAppendTipList.contains(fruType) && (!FRU_MODULE_FAN.equals(fruType) || this.hasConfirmTipForFan(selData.get(0)))) {
            appendInfo = this.getAppendInfoByFruType(fruType);
        }
        if (Objects.equals(fruType, FRU_MODULE_BBU) && this.hasConfirmTipForFan(selData.get(0))) {
            appendInfo = ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.bbu");
        }
        if (Objects.equals(fruType, FRU_MODULE_DISKDRAWER)) {
            appendInfo = ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.disk.drawer");
        }
        if (Objects.equals(fruType, FRU_MODULE_XPU)) {
            appendInfo = ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.xpu");
        }
        if (FRU_MODULE_FRONTENDINTF.equalsIgnoreCase(fruType)) {
            appendInfo = ResourceUtil.getString("bizpack.select.comfirm.dlg.frontEndInft");
        }
        if (FRU_MODULE_BACKENDINTF.equalsIgnoreCase(fruType)) {
            appendInfo = ResourceUtil.getString("bizpack.select.comfirm.dlg.backEndInft");
        }
        if (FRU_MODULE_IPSCALEOUT_INTF.equalsIgnoreCase(fruType)) {
            appendInfo = ReplaceTip.getAppendInfoForIpScaleOutInterface();
        }
        return appendInfoTime + appendInfo;
    }

    public static String getAppendInfoForIpScaleOutInterface() {
        DevNode devNode = BizPackageContext.getInstance().getCurDevice();
        String productModel = devNode.getDeviceType().toString();
        String productVersion = devNode.getProductVersion();
        LOGGER.info("productModel: {}, productVersion: {}", (Object)productModel, (Object)productVersion);
        if (Products.isDoradoV6SeriseDev((String)productModel) || Products.isKunpengHighDev((String)productModel, (String)productVersion)) {
            return ResourceUtil.getString("bizpack.select.comfirm.dlg.frontEndInft");
        }
        return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.ip.scale.out.intf");
    }

    String getAppendInfoByFruType(String fruType) {
        switch (fruType) {
            case "diskEnclosure": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.disk.enc");
            }
            case "controllerEnclosure": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.ctrl.enc");
            }
            case "controller": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.ctrl");
            }
            case "pcieIntf": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.pcie.intf");
            }
            case "fan": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.fan");
            }
            case "boxDisk": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.box.disk");
            }
            case "boxIntf": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.box.intf");
            }
            case "systemDisk": {
                return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.system.disk");
            }
        }
        return ResourceUtil.getString("bizpack.select.comfirm.dlg.appendtip.common");
    }

    private String getAppendInfoTime(String fruType, String fruName) {
        String appendInfoTime = "";
        List<String> needAppendTipForTimeList = Arrays.asList(NEED_APPENDTIP_FOR_TIME_FRU_MODULE);
        if (needAppendTipForTimeList.contains(fruType)) {
            String fruNameFinal = fruName;
            if (!fruType.equalsIgnoreCase(FRU_MODULE_BBU) && !fruType.startsWith("ipScaleOut")) {
                fruNameFinal = fruName.toLowerCase(Locale.ENGLISH);
            }
            appendInfoTime = fruType.equalsIgnoreCase(FRU_MODULE_BBU) ? ResourceUtil.getStringWithParams("bizpack.select.comfirm.dlg.time.second", fruNameFinal, BBU_SELECT_COMFIRM_DLG_SECOND) : ResourceUtil.getStringWithParams("bizpack.select.comfirm.dlg.time", fruNameFinal);
        }
        return appendInfoTime;
    }

    private String getFruIdentName(String fruType, List<JSONObject> selData) {
        String fruIdentName = "";
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        if (FRU_MODULE_RISK_POWER.equals(fruType)) {
            return resutil.getString("name");
        }
        boolean needMultiCheck = (Boolean)BizPackageContext.getInstance().getJythonContext().getDict().get("needMultiCheck");
        if (selData.size() == 1 || needMultiCheck) {
            if (FRU_MODULE_MEMORY.equals(fruType)) {
                fruIdentName = resutil.getString(FRU_MODULE_CTRL);
                return fruIdentName;
            }
            if (FRU_IDENTINFO_MAP.containsKey(fruType)) {
                fruIdentName = resutil.getString(FRU_IDENTINFO_MAP.get(fruType)[1]);
                return fruIdentName;
            }
            fruIdentName = resutil.getString("location");
            return fruIdentName;
        }
        if (selData.size() == 2) {
            String fruTbTatle = "";
            if (FRU_IDENTINFO_MUTITABLE_MAP.containsKey(fruType)) {
                fruTbTatle = resutil.getString(FRU_IDENTINFO_MUTITABLE_MAP.get(fruType)[0]);
                fruIdentName = resutil.getString(FRU_IDENTINFO_MUTITABLE_MAP.get(fruType)[1]);
                return fruTbTatle + " " + fruIdentName;
            }
            fruIdentName = resutil.getString("location");
            return fruIdentName;
        }
        return fruIdentName;
    }

    private String getFruIdentInfo(String fruType, List<JSONObject> selData) {
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String fruIdentInfo = "";
        boolean needMultiCheck = (Boolean)BizPackageContext.getInstance().getJythonContext().getDict().get("needMultiCheck");
        LOGGER.info("fruType:{},sel_data:{}", (Object)fruType, selData);
        if (FRU_MODULE_MEMORY.equals(fruType)) {
            String controller = (String)selData.get(0).get(FRU_MODULE_CTRL);
            String slotName = resutil.getString("memory.replacefru.confirm.slot");
            ArrayList infoList = new ArrayList();
            selData.stream().filter(j -> j.get("slot_name") != null).forEach(j -> infoList.add((String)j.get("slot_name")));
            return controller + " " + slotName + StringUtils.join(infoList, (String)",");
        }
        if (FRU_MODULE_SYSTEM_DISK.equals(fruType)) {
            String controller = resutil.getString("systemDisk.replacefru.confirm.controller");
            String slotName = resutil.getString("systemDisk.replacefru.confirm.slot");
            ArrayList infoList = new ArrayList();
            selData.stream().filter(data -> data.get("slot_name") != null).forEach(data -> infoList.add((String)data.get("slot_name")));
            return controller + selData.get(0).get("location") + " " + slotName + StringUtils.join(infoList, (String)",");
        }
        if (selData.size() == 1) {
            if (FRU_IDENTINFO_MAP.containsKey(fruType)) {
                Object info = selData.get(0).get(FRU_IDENTINFO_MAP.get(fruType)[0]);
                fruIdentInfo = info == null ? "" : (String)info;
                return fruIdentInfo;
            }
        } else if (needMultiCheck) {
            ArrayList<String> infoList = new ArrayList<String>();
            for (JSONObject j2 : selData) {
                Object info = j2.get("location");
                if (info == null) continue;
                infoList.add((String)info);
            }
            return StringUtils.join(infoList, (String)",");
        }
        return selData.get(0).get("location") == null ? "" : (String)selData.get(0).get(FRU_MODULE_RISK_POWER.equals(fruType) ? "name" : "location");
    }
}

