/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.select;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.FileChooser;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.LoadItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableData;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.select.ReplaceTip;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.select.SelectForReplaceStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.select.SelectForReplaceStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONArray;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectForReplaceStep
extends AbstractBizStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectForReplaceStep.class);
    private SelectForReplaceStepLayout preSSLayout;
    private SelectForReplaceStepCfg cfg;
    private List<TableItem> selectTableItems;
    private ExecPyScriptTask preSelectTask;
    private String preScriptPath;
    private String pyName;
    private boolean promiseBoxFlag = false;
    private boolean tableSelected = false;
    private boolean fileChooserFlag = true;

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        if (stepConfig instanceof SelectForReplaceStepCfg) {
            this.cfg = (SelectForReplaceStepCfg)stepConfig;
            this.preSSLayout = new SelectForReplaceStepLayout(this.cfg);
            this.selectTableItems = this.cfg.getSelectTableList();
            this.preScriptPath = this.getScriptPath();
            this.pyName = this.cfg.getScriptFile();
            super.setParamAbs(this.cfg.getParam());
            super.setBackwardAbs(this.cfg.isBackward());
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            BizPackageContext.getInstance().getJythonContext().getDict().put("needMultiCheck", false);
            for (TableItem item : this.selectTableItems) {
                if (!item.isNeedMultiCheck()) continue;
                BizPackageContext.getInstance().getJythonContext().getDict().put("needMultiCheck", true);
                break;
            }
            this.setDocLinkParentWindow(this.cfg);
        }
    }

    protected FlowWizardCardLayout getLayout() {
        return this.preSSLayout;
    }

    protected boolean init() {
        this.setCurStepID();
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        if (!this.cfg.isShowall()) {
            this.preSSLayout.getDefaultVisible().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectForReplaceStep.this.updateTableData();
                    SelectForReplaceStep.this.tableSelected = SelectForReplaceStep.this.isAllTableSelected();
                    SelectForReplaceStep.this.chgState();
                }
            });
        }
        if (!this.preSSLayout.init(this.cfg)) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.parseproductsfailed"));
            return false;
        }
        this.initListener(this.cfg);
        super.setIndex(this.getStageIndex());
        this.preSSLayout.getCheck().setSelected(false);
        this.tableSelected = this.isAllTableSelected();
        this.fileChooserFlag = this.isAllFileChooserHasInfo();
        this.promiseBoxFlag = this.isCheckBoxSelected();
        this.chgState();
        this.preSSLayout.getDefaultVisible().setSelected(true);
        this.preSSLayout.getCheck().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectForReplaceStep.this.promiseBoxFlag = SelectForReplaceStep.this.isCheckBoxSelected();
                SelectForReplaceStep.this.chgState();
            }
        });
        if (null != this.cfg.getLoadItem()) {
            this.initLoadItem();
        } else {
            SwingUtilities.invokeLater(new InitDataTread());
        }
        return true;
    }

    public void initLoadItem() {
        this.cfg.getLoadItem().init(this.getSsEnv(), this.getScriptPath(), new LoadItem.ICallback(){

            @Override
            public void init() {
                for (TableItem tableItem : SelectForReplaceStep.this.selectTableItems) {
                    tableItem.getIsmTable().getSelectionModel().clearSelection();
                    tableItem.getTableModel().removeAll();
                }
                SelectForReplaceStep.this.clearTableData();
            }

            @Override
            public void finish(boolean isSuc, String errMsg) {
                if (isSuc) {
                    SwingUtilities.invokeLater(new InitDataTread());
                }
            }
        });
    }

    private void updateTableData() {
        if (!this.preSSLayout.getDefaultVisible().isSelected()) {
            Window parentWindow = this.getParentWindow();
            if (parentWindow instanceof JDialog) {
                WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)((JDialog)parentWindow), (String)ResourceUtil.getString("wizard.select.warn.defaultvisible.all"));
                if (0 == wdialog.getValue()) {
                    this.update2AllData();
                } else {
                    this.preSSLayout.getDefaultVisible().setSelected(true);
                }
            }
        } else {
            this.update2FaultyData();
        }
    }

    private void update2AllData() {
        boolean hasInfo = false;
        for (TableItem tableItem : this.selectTableItems) {
            List<String> refeshItems = tableItem.getRefreshItems();
            Map<String, InfoItem> id2Component = this.preSSLayout.getId2Component();
            for (String id : refeshItems) {
                InfoItem lable = id2Component.get(id);
                lable.setText("");
            }
            tableItem.getIsmTable().getSelectionModel().clearSelection();
            tableItem.getTableModel().removeAll();
            tableItem.initFresh();
            if (tableItem.getTableModel().getAllRows().isEmpty()) continue;
            hasInfo = true;
        }
        if (!hasInfo) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.info.fru.normal.nodevice"));
        }
    }

    private void update2FaultyData() {
        for (TableItem tableItem : this.selectTableItems) {
            List<String> refeshItems = tableItem.getRefreshItems();
            Map<String, InfoItem> id2Component = this.preSSLayout.getId2Component();
            for (String id : refeshItems) {
                InfoItem lable = id2Component.get(id);
                lable.setText("");
            }
            tableItem.getIsmTable().getSelectionModel().clearSelection();
            tableItem.getTableModel().removeAll();
            tableItem.init2FaultyData();
        }
    }

    private void chgState() {
        if (this.promiseBoxFlag && this.tableSelected && this.fileChooserFlag) {
            this.chgWizState(true);
        } else {
            this.chgWizState(false);
        }
    }

    private void initTableData() {
        boolean hasInfo = false;
        boolean getJsonFailed = false;
        for (TableItem tableItem : this.selectTableItems) {
            String json = (String)this.getSsEnv().getDict().get("retData_" + tableItem.getId());
            if (null == json) {
                getJsonFailed = true;
                break;
            }
            tableItem.setJsonRetData(json);
            if (this.cfg.isShowall()) {
                tableItem.initFresh();
            } else {
                tableItem.init2FaultyData();
            }
            if (tableItem.getTableModel().getAllRows().isEmpty()) continue;
            hasInfo = true;
        }
        if (getJsonFailed) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpack.wizard.selectstep.error.initdata"));
            return;
        }
        if (!hasInfo) {
            if (((Boolean)this.getSsEnv().getDict().getOrDefault("is_no_system_disk_fault", false)).booleanValue()) {
                DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.info.fru.system.disk.nodevice"));
            }
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.info.fru.nodevice"));
        }
        this.verifyFilepath(this.cfg);
    }

    private void clearTableData() {
        for (TableItem tableItem : this.selectTableItems) {
            tableItem.setJsonRetData("");
        }
    }

    private void initListener(SelectForReplaceStepCfg initCfg) {
        List<TableItem> selectedTableItems = initCfg.getSelectTableList();
        for (TableItem selectTableItem : selectedTableItems) {
            this.initOneTableListener(selectTableItem);
        }
        List<Object> infos = initCfg.getInfoList();
        for (Object object : infos) {
            if (!(object instanceof FileChooser)) continue;
            this.fileChooserFlag = false;
            FileChooser fileChooser = (FileChooser)object;
            this.getSsEnv().getDict().put(this.getSelectTabelItemId(fileChooser.getId()), fileChooser.getTextField().getText());
            this.removeAllChooseBtnListener(fileChooser);
            this.initFileChooserListner(fileChooser);
        }
    }

    private void verifyFilepath(SelectForReplaceStepCfg initCfg) {
        List<Object> infos = initCfg.getInfoList();
        for (Object object : infos) {
            if (!(object instanceof FileChooser)) continue;
            int mincapacity = ((FileChooser)object).getMincapacity();
            String userPath = BizPackageSceneUtils.sceneResultPath();
            File backupDir = new File(FilePathUtils.filterPath(userPath));
            this.check(userPath, backupDir, mincapacity);
        }
    }

    private void check(String userPath, File backupDir, int mincapacity) {
        if (userPath != null && !userPath.isEmpty() && !this.checkDiskFreeSpace(backupDir, mincapacity)) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.remind.diskspacenotenough"));
            LOGGER.error("The selected file path is less than " + mincapacity + "M");
        }
    }

    private void removeAllChooseBtnListener(FileChooser fileChooser) {
        ActionListener[] lsts;
        for (ActionListener actionListener : lsts = fileChooser.getChooseFileButton().getActionListeners()) {
            fileChooser.getChooseFileButton().removeActionListener(actionListener);
        }
    }

    private void initFileChooserListner(FileChooser fileChooser) {
        int chooseType = 0;
        String title = "";
        String desc = "";
        FileChooser.FileChooserType type = fileChooser.getType();
        if (type.equals((Object)FileChooser.FileChooserType.DIR)) {
            chooseType = 1;
            title = ResourceUtil.getString("bizpack.wizard.selectstep.filechooser.dir.title");
            desc = ResourceUtil.getString("bizpack.wizard.selectstep.filechooser.dir.desc");
        } else if (type.equals((Object)FileChooser.FileChooserType.DIR_AND_FILE)) {
            chooseType = 2;
            title = ResourceUtil.getString("bizpack.wizard.selectstep.filechooser.dirandfile.title");
            desc = ResourceUtil.getString("bizpack.wizard.selectstep.filechooser.dirandfile.desc");
        } else if (type.equals((Object)FileChooser.FileChooserType.FILE)) {
            chooseType = 0;
            title = ResourceUtil.getString("bizpack.wizard.selectstep.filechooser.file.title");
            desc = ResourceUtil.getString("bizpack.wizard.selectstep.filechooser.file.desc");
        }
        fileChooser.getChooseFileButton().addActionListener(new FileChooseListener(fileChooser, title, desc, chooseType));
    }

    private void fileChooserAction(File selectFile, FileChooser fileChooser, String id) {
        if (null == selectFile) {
            LOGGER.info("selectFile is null");
            return;
        }
        if (selectFile.exists() && this.isValidPath(selectFile, fileChooser.getMincapacity())) {
            fileChooser.getTextField().setText(FilePathUtils.getCanonicalPath(selectFile));
            this.getSsEnv().getDict().put(this.getSelectTabelItemId(id), FilePathUtils.getCanonicalPath(selectFile));
            this.fileChooserFlag = this.isAllFileChooserHasInfo();
            this.chgState();
        } else {
            LOGGER.info("selectFile does not exist");
        }
    }

    private boolean isValidPath(File selectFile, int miniCapacity) {
        if (!selectFile.canWrite()) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.remind.path.cannot.write"));
            LOGGER.error("The selected file path can not write");
            return false;
        }
        if (miniCapacity == 0) {
            return true;
        }
        if (!this.checkDiskFreeSpace(selectFile, miniCapacity)) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.remind.diskspacenotenough"));
            LOGGER.error("The selected file path is less than " + miniCapacity + "M");
            return false;
        }
        return true;
    }

    private boolean checkDiskFreeSpace(File file, int miniCapacity) {
        long capacity;
        long freeSpace = file.getFreeSpace();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Disk free space is: " + freeSpace);
        }
        return freeSpace >= (capacity = (long)miniCapacity * 1024L * 1024L);
    }

    private boolean isAllFileChooserHasInfo() {
        List<Object> infos = this.cfg.getInfoList();
        for (Object object : infos) {
            FileChooser fileChooser;
            if (!(object instanceof FileChooser) || !(fileChooser = (FileChooser)object).getTextField().getText().equals("")) continue;
            return false;
        }
        return true;
    }

    private boolean isCheckBoxSelected() {
        if ("".equals(this.cfg.getPromise().trim())) {
            return true;
        }
        return this.preSSLayout.getCheck().isSelected();
    }

    private void initOneTableListener(TableItem selectTableItem) {
        selectTableItem.getIsmTable().getSelectionModel().addListSelectionListener(new TabelSelectListener(selectTableItem));
    }

    private boolean isAllTableSelected() {
        for (TableItem item : this.selectTableItems) {
            if (!item.isNeedSelect() || !item.getIsmTable().getMarkedRows().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void refreshItem(List<String> refreshItems, boolean needFreshItems) {
        this.preSelectTask.execFunc("refreshData", this.getParamAbs());
        if (!((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue()) {
            String errText = (String)this.getSsEnv().getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            return;
        }
        if (!needFreshItems) {
            return;
        }
        Map<String, InfoItem> id2Component = this.preSSLayout.getId2Component();
        for (String id : refreshItems) {
            String itemId = this.getRefreshItemId(id);
            String text = (String)this.getSsEnv().getDict().get(itemId);
            InfoItem lable = id2Component.get(id);
            lable.setText(text);
        }
    }

    private String getRefreshItemId(String id) {
        StringBuilder itemId = new StringBuilder();
        itemId.append("input");
        itemId.append('_');
        itemId.append(this.getId());
        itemId.append('_');
        itemId.append(id);
        return itemId.toString();
    }

    private String getSelectTabelItemId(String id) {
        StringBuilder itemId = new StringBuilder();
        itemId.append("input");
        itemId.append('_');
        itemId.append(this.getId());
        itemId.append('_');
        itemId.append(id);
        return itemId.toString();
    }

    private String tableData2json(TableData oneRow) {
        com.huawei.json.JSONObject tableData = new com.huawei.json.JSONObject(oneRow.getId2DataMap());
        return tableData.toString();
    }

    private String tableData2json(List<TableRow> rows) {
        ArrayList<com.huawei.json.JSONObject> jsonObjects = new ArrayList<com.huawei.json.JSONObject>();
        for (TableRow row : rows) {
            TableData oneRow = (TableData)row.getIdentifier();
            oneRow.getId2DataMap().remove("_self_marked");
            com.huawei.json.JSONObject tableData = new com.huawei.json.JSONObject(oneRow.getId2DataMap());
            jsonObjects.add(tableData);
        }
        JSONArray array = new JSONArray(jsonObjects);
        return array.toString();
    }

    private void refreshTableLinkItem(TableItem selectTableItem, List<String> refreshItemIDs) {
        if (null == refreshItemIDs || refreshItemIDs.isEmpty()) {
            if (selectTableItem.isNeedFreshForDevGraph()) {
                this.refreshItem(refreshItemIDs, false);
            }
            return;
        }
        this.refreshItem(refreshItemIDs, true);
    }

    public boolean ending() {
        if (UserOpDataSaveUtil.isAutoTestEnv()) {
            return this.saveData();
        }
        return this.saveData() && ReplaceTip.getInstance().execTips(this.selectTableItems);
    }

    private boolean saveData() {
        WarningDialog wdialog;
        for (TableItem item : this.selectTableItems) {
            item.putAllData();
        }
        BizPackageContext.getInstance().getJythonContext().clearMsgData();
        this.preSelectTask.execFunc("saveData", this.getParamAbs());
        boolean needNext = (Boolean)this.getSsEnv().getDict().getOrDefault("needNext", true);
        if (!needNext) {
            LOGGER.warn("The component selection is abnormal. needNext:{}", (Object)needNext);
            return false;
        }
        Object confirm = this.getSsEnv().getDict().get("confirmMsg");
        if (!((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue()) {
            String errText = (String)this.getSsEnv().getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            return false;
        }
        if (null == confirm || "".equals(((String)confirm).trim())) {
            return true;
        }
        Window parentWindow = this.getParentWindow();
        if (parentWindow instanceof JDialog && 0 == (wdialog = DialogUtils.createWarningDialog((JDialog)((JDialog)parentWindow), (String)((String)confirm))).getValue()) {
            BizPackageContext.getInstance().getJythonContext().clearMsgData();
            return true;
        }
        BizPackageContext.getInstance().getJythonContext().clearMsgData();
        return false;
    }

    public boolean flowExiting() {
        return this.cancel();
    }

    @Override
    public void onStepDialogDisplayed() {
        boolean match = true;
        String currentProcess = AutoProcessConfig.getInstance().getCurrentProcess();
        String inputJson = ((String)AutoProcessConfig.getInstance().getProcessInput().get(currentProcess)).trim();
        for (TableItem tableItem : this.selectTableItems) {
            TypeReference<HashMap<String, String>> type;
            HashMap tableInputMap;
            String key = this.getSelectTabelItemId(tableItem.getId());
            String tableInput = "";
            tableInput = this.selectTableItems.size() > 1 ? ((tableInputMap = (HashMap)JSONObject.parseObject((String)inputJson, (TypeReference)(type = new TypeReference<HashMap<String, String>>(){}), (Feature[])new Feature[0])) == null ? "" : (String)tableInputMap.get(key)) : inputJson;
            String json = this.filterSelectedRowByInput(tableItem, tableInput);
            if (json == null) {
                match = false;
                break;
            }
            this.getSsEnv().getDict().put(key, json);
        }
        if (match) {
            this.notifyObserver(AutoProcessStatus.SUCCESS);
        } else {
            this.notifyObserver(AutoProcessStatus.FAILURE);
        }
    }

    private String filterSelectedRowByInput(TableItem tableItem, String inputJson) {
        String key = "retData_" + tableItem.getId();
        String jsonList = (String)this.getSsEnv().getDict().get(key);
        JSONArray jsonArray = new JSONArray(jsonList);
        Object object = JSON.parse((String)inputJson);
        if (object instanceof com.alibaba.fastjson.JSONArray) {
            com.alibaba.fastjson.JSONArray input = (com.alibaba.fastjson.JSONArray)object;
            JSONArray filteredArray = this.filterJsonArray(input.toJSONString(), jsonArray);
            return filteredArray.length() > 0 ? filteredArray.toString() : null;
        }
        if (object instanceof JSONObject) {
            JSONObject input = (JSONObject)object;
            com.huawei.json.JSONObject filteredObject = this.filterJson(input.toJSONString(), jsonArray);
            return filteredObject.keySet().size() > 0 ? filteredObject.toString() : null;
        }
        LOGGER.error("Input string in AutoProcessConfig.xml is not Json!");
        return null;
    }

    private com.huawei.json.JSONObject filterJson(String inputJson, JSONArray jsonArray) {
        com.huawei.json.JSONObject inputJsonObj = new com.huawei.json.JSONObject(inputJson);
        com.huawei.json.JSONObject filteredJsonObj = new com.huawei.json.JSONObject();
        for (int i = 0; i < jsonArray.length(); ++i) {
            com.huawei.json.JSONObject jsonObj = (com.huawei.json.JSONObject)jsonArray.get(i);
            boolean match = this.matchAttribute(inputJsonObj, jsonObj);
            if (!match) continue;
            filteredJsonObj = jsonObj;
            break;
        }
        return filteredJsonObj;
    }

    private JSONArray filterJsonArray(String inputJson, JSONArray jsonArray) {
        JSONArray inputJsonArray = new JSONArray(inputJson);
        JSONArray filteredArray = new JSONArray();
        for (int i = 0; i < inputJsonArray.length(); ++i) {
            com.huawei.json.JSONObject inputJsonObj = (com.huawei.json.JSONObject)inputJsonArray.get(i);
            com.huawei.json.JSONObject filteredJsonObj = this.filterJson(inputJsonObj.toString(), jsonArray);
            filteredArray.put(filteredJsonObj);
        }
        LOGGER.info(String.format(Locale.ROOT, "auto select rows is: %s", filteredArray.toString()));
        return filteredArray;
    }

    private boolean matchAttribute(com.huawei.json.JSONObject inputJsonObj, com.huawei.json.JSONObject jsonObj) {
        Iterator iterator = inputJsonObj.keys();
        boolean match = true;
        while (iterator.hasNext()) {
            String inputKey = (String)iterator.next();
            String inputValue = inputJsonObj.getString(inputKey);
            String value = jsonObj.getString(inputKey);
            if (value != null && value.equalsIgnoreCase(inputValue)) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.outputResult(status);
        if (BizPackageContext.getInstance().getWizard() instanceof FlowWizardDialog) {
            FlowWizardDialog wizardDialog = (FlowWizardDialog)BizPackageContext.getInstance().getWizard();
            if (status.equals((Object)AutoProcessStatus.SUCCESS)) {
                wizardDialog.clickNaviButton(Navigation.NEXT);
            } else {
                AutoProcessResult.getInstance().setStepFailure(true);
                wizardDialog.clickNaviButton(Navigation.CANCEL);
            }
        }
    }

    private void outputResult(AutoProcessStatus status) {
        String stepId = BizPackageContext.getInstance().getCurStepId();
        AutoProcessResult.getInstance().append(String.format(Locale.ROOT, "%s--------step: %s, result: %s", System.lineSeparator(), stepId, status.toString()));
    }

    private class TabelSelectListener
    implements ListSelectionListener {
        private TableItem selectTableItem = null;

        public TabelSelectListener(TableItem selectTableItem) {
            this.selectTableItem = selectTableItem;
        }

        @Override
        public void valueChanged(ListSelectionEvent selectionEvent) {
            String jsonStr;
            if (!selectionEvent.getValueIsAdjusting() && !this.selectTableItem.isNeedMultiCheck()) {
                return;
            }
            List rows = this.selectTableItem.getIsmTable().getMarkedRows();
            if (null == rows || rows.isEmpty()) {
                return;
            }
            SelectForReplaceStep.this.tableSelected = SelectForReplaceStep.this.isAllTableSelected();
            SelectForReplaceStep.this.chgState();
            SelectForReplaceStep.this.getSsEnv().getDict().put("input_changed_id", SelectForReplaceStep.this.getSelectTabelItemId(this.selectTableItem.getId()));
            if (this.selectTableItem.isNeedMultiCheck()) {
                jsonStr = SelectForReplaceStep.this.tableData2json(rows);
            } else {
                TableData oneRow = (TableData)((TableRow)rows.get(0)).getIdentifier();
                jsonStr = SelectForReplaceStep.this.tableData2json(oneRow);
            }
            String selectKey = SelectForReplaceStep.this.getSelectTabelItemId(this.selectTableItem.getId());
            SelectForReplaceStep.this.getSsEnv().getDict().put(selectKey, jsonStr);
            LOGGER.info(String.format(Locale.ROOT, "selected row key: %s", selectKey));
            LOGGER.info(String.format(Locale.ROOT, "selected row json: %s", jsonStr));
            List<String> refreshItemIDs = this.selectTableItem.getRefreshItems();
            SelectForReplaceStep.this.refreshTableLinkItem(this.selectTableItem, refreshItemIDs);
        }
    }

    private class InitDataTread
    implements Runnable {
        private InitDataTread() {
        }

        @Override
        public void run() {
            BizPackageContext.getInstance().getJythonContext().clearMsgData();
            Window parent = SelectForReplaceStep.this.getParentWindow();
            List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(SelectForReplaceStep.this.preScriptPath, SelectForReplaceStep.this.pyName, "initData", SelectForReplaceStep.this.getParamAbs())});
            WaitDialogResult result = (WaitDialogResult)fs.get(0);
            if (!WaitDialogResult.handleResult(SelectForReplaceStep.this.getParentWindow(), result)) {
                return;
            }
            SelectForReplaceStep.this.preSelectTask = result.getTask();
            if (null == SelectForReplaceStep.this.preSelectTask) {
                DialogUtils.showErrorDialog((Window)SelectForReplaceStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                SelectForReplaceStep.this.clearTableData();
                return;
            }
            if (!((Boolean)SelectForReplaceStep.this.getSsEnv().getDict().get("succ")).booleanValue()) {
                String errText = (String)SelectForReplaceStep.this.getSsEnv().getDict().get("errMsg");
                DialogUtils.showErrorDialog((Window)SelectForReplaceStep.this.getParentWindow(), (String)errText);
                SelectForReplaceStep.this.clearTableData();
                return;
            }
            SelectForReplaceStep.this.initTableData();
            IStep currentStep = BizPackageContext.getInstance().getCurrentStep();
            if (currentStep != null && currentStep instanceof SelectForReplaceStep) {
                ((SelectForReplaceStep)currentStep).notifyObserver(AutoProcessStatus.DISPLAY);
            }
        }
    }

    private class FileChooseListener
    implements ActionListener {
        private FileChooser fileChooser = null;
        private String dialogTitle = "";
        private String dialogDesc = "";
        private int typeInt = 1;

        public FileChooseListener(FileChooser fileChooser, String dialogTitle, String dialogDesc, int typeInt) {
            this.fileChooser = fileChooser;
            this.dialogTitle = dialogTitle;
            this.dialogDesc = dialogDesc;
            this.typeInt = typeInt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectfileDefaultId = this.fileChooser.getSelectID();
            String id = this.fileChooser.getId();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("click FileChooser[" + id + "]");
            }
            File selectFile = ToolFileChooser.selectFile((Window)SelectForReplaceStep.this.getParentWindow(), (String)this.dialogTitle, (String[])new String[]{"*.*"}, (String)selectfileDefaultId, (String)this.dialogDesc, (int)this.typeInt, (boolean)true, (boolean)true, (Locale)Locale.getDefault());
            SelectForReplaceStep.this.fileChooserAction(selectFile, this.fileChooser, id);
        }
    }
}

