/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class BizPackageSceneUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BizPackageSceneUtils.class);
    private static final String JSON_SCENERESULT_PATH = "jsonSceneResultPath";
    public static final String ARG_LIST = "jsonSceneArgsList";
    private static final String TOOL_KEY = "toolScene";
    private static final String FRU_EVALUATION = "fruEvaluation";
    private static final String FRU_REPLACEMENT = "fruReplacement";
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String EMPTY_DATA = "";
    private static final String SCENE_STATUS = "status";
    private static final String SCENE_DEV_TOOLID = "toolId";
    public static final String SCENE_RESULT_SUCCESS = "SUCCESS";
    public static final String SCENE_RESULT_FAILED = "FAILED";
    public static final String SCENE_CHM_CLICK_EVENT = "chm_click_event";
    public static final String SCENE_CHM_RECORD_CONTENT_SUCCESS = "success";
    public static final String SCENE_CHM_RECORD_CLOSE_SCENE = "6";
    private static boolean neededRecord = false;
    private static Map<String, String> sceneResultMap = new ConcurrentHashMap<String, String>();
    private static JSONArray jsonArray = new JSONArray();
    public static final int STAUTS = 3;

    public static boolean isScene() {
        return SceneUtils.isScene();
    }

    public static String sceneResultPath() {
        ScenePathValue sceneValue = null;
        String scenePath = EMPTY_DATA;
        try {
            sceneValue = (ScenePathValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey(JSON_SCENERESULT_PATH);
            if (null == sceneValue) {
                return EMPTY_DATA;
            }
            scenePath = sceneValue.getJsonSceneResultPathValue();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The sceneResultPath is:{}", (Object)StringUtils.getCleanMessage(scenePath));
            }
        }
        catch (ToolException e) {
            LOGGER.error("the sceneResultPath exception:", (Throwable)e);
        }
        return scenePath;
    }

    public static JSONObject getArgsJsonObj() {
        String argListStr = System.getenv(ARG_LIST);
        if (!StringUtils.isNULLStr(argListStr)) {
            JSONObject jsonObject = new JSONObject(argListStr);
            return jsonObject;
        }
        return null;
    }

    public static boolean sceneSelectDevNode(String sn, String toolId) {
        String sceneStatus = null;
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            sceneStatus = environment.getDataVarByKey(BizPackageSceneUtils.getDevNodeJsonQuery(sn, toolId));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the dev status is :" + sceneStatus);
            }
        }
        catch (ToolException e) {
            LOGGER.error("get scene select device node failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getDevNodeJsonQuery(String sn, String toolId) {
        HashMap<String, String> jsonQueryMap = new HashMap<String, String>();
        jsonQueryMap.put(SCENE_DEV_TOOLID, toolId);
        jsonQueryMap.put(SCENE_SN, sn);
        JSONObject jsonObject = new JSONObject(jsonQueryMap);
        return jsonObject.toString();
    }

    public static TaskResult finishedSceneTask(String toolId) {
        if (BizPackageSceneUtils.isNeededRecord()) {
            BizPackageSceneUtils.closeDataRecord(new Date(), SCENE_CHM_RECORD_CLOSE_SCENE);
        }
        TaskResult ret = null;
        try {
            List<Map<String, String>> sceneData = BizPackageSceneUtils.sceneEnvirData(toolId);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the sceneData is " + sceneData);
            }
            if (sceneData.isEmpty()) {
                sceneData.add(BizPackageSceneUtils.emptyNata(toolId));
            }
            ret = SceneEnvironmentImpl.getInstance().finishedSceneTask(sceneData);
        }
        catch (ToolException e) {
            LOGGER.error("the finishedSceneTask exception", (Throwable)e);
        }
        catch (Exception e1) {
            LOGGER.error("the finishedSceneTask has exception.", (Throwable)e1);
        }
        return ret;
    }

    public static List<Map<String, String>> sceneEnvirData(String toolId) {
        ArrayList<Map<String, String>> sceneListMap = new ArrayList<Map<String, String>>();
        Map devMap = (Map)BizPackageContext.getInstance().getJythonContext().getDict().get("dev");
        sceneResultMap.put(SCENE_IP, (String)devMap.get("ip"));
        sceneResultMap.put(SCENE_SN, (String)devMap.get("sn"));
        sceneResultMap.put(SCENE_DEV_TOOLID, toolId);
        sceneResultMap.put(SCENE_CHM_CLICK_EVENT, jsonArray.toString());
        sceneListMap.add(sceneResultMap);
        return sceneListMap;
    }

    private static Map<String, String> emptyNata(String toolId) {
        HashMap<String, String> scenceMap = new HashMap<String, String>();
        scenceMap.put(SCENE_IP, EMPTY_DATA);
        scenceMap.put(SCENE_SN, EMPTY_DATA);
        scenceMap.put(SCENE_STATUS, EMPTY_DATA);
        scenceMap.put(SCENE_DEV_TOOLID, toolId);
        scenceMap.put(SCENE_CHM_CLICK_EVENT, EMPTY_DATA);
        return scenceMap;
    }

    public static void putResult(String result) {
        sceneResultMap.put(SCENE_STATUS, result);
    }

    private static void exeCancelScript(String scriptName, BizPackage bizPackage, JythonContext ssEnv) throws SignException, FileNotFoundException {
        if (!StringUtils.isNULLStr(scriptName)) {
            String processDir = bizPackage.getAbsolutPath() + File.separator + BizPackage.getProcessNode();
            String pyPath = processDir + File.separator + scriptName;
            try {
                JythonExecuter jythonExecuter = bizPackage.getJythonExecuter();
                File pyFile = new File(pyPath);
                ssEnv.getDict().put("logger", LOGGER);
                jythonExecuter.compileScript(pyFile);
                ssEnv.clearMsgData();
                jythonExecuter.invokeFunction("execute", ssEnv.getDict());
            }
            catch (com.huawei.ism.tool.obase.exception.ToolException e) {
                LOGGER.error("Error when executing script.", (Throwable)e);
            }
        } else {
            LOGGER.info("No script to be executed.");
        }
    }

    public static void finishedScene(String toolId) {
        BizPackageSceneUtils.executeCancelScript();
        if (BizPackageSceneUtils.isScene()) {
            BizPackageSceneUtils.backHaulData(toolId);
        }
    }

    private static void backHaulData(String toolId) {
        try {
            TaskResult taskResult = BizPackageSceneUtils.finishedSceneTask(toolId);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("taskResult:" + taskResult);
            }
            sceneResultMap.clear();
        }
        catch (Exception e) {
            LOGGER.error("scene data error.", (Throwable)e);
        }
    }

    private static void executeCancelScript() {
        try {
            BizPackage bizPackage = BizPackageContext.getInstance().getCurBizPackage();
            BizPackageSceneUtils.exeCancelScript(bizPackage.getCancelScript(), bizPackage, BizPackageContext.getInstance().getJythonContext());
        }
        catch (Exception e) {
            LOGGER.error("scene data error.", (Throwable)e);
        }
    }

    public static boolean isNeededRecord() {
        return neededRecord;
    }

    public static void setNeededRecord(boolean record) {
        neededRecord = record;
    }

    public static void openDataRecord(Date date, String url, String type) {
        BizPackageSceneUtils.setNeededRecord(true);
        BizPackageSceneUtils.addDataToArray(type, date, url);
    }

    public static void closeDataRecord(Date date, String type) {
        BizPackageSceneUtils.addDataToArray(type, date, SCENE_CHM_RECORD_CONTENT_SUCCESS);
    }

    private static void addDataToArray(String type, Date date, String content) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", type);
        jsonObject.put("time", StringUtils.formatDate(date, "yyyyMMdd HH:mm:ss"));
        jsonObject.put("content", content);
        jsonObject.put("platfrom", "toolkit");
        jsonObject.put("module", BizPackageContext.getInstance().getCurToolName());
        jsonArray.put(jsonObject);
    }

    public static boolean isChineseLanguage() {
        return LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE);
    }

    public static boolean isFruEvalScene() {
        try {
            JSONObject argsObj = BizPackageSceneUtils.getArgsJsonObj();
            return argsObj != null && argsObj.getString(TOOL_KEY).equalsIgnoreCase(FRU_EVALUATION);
        }
        catch (JSONException e) {
            LOGGER.error("get scene args error, or no config args.");
            return false;
        }
    }

    public static boolean isFruReplacement() {
        try {
            JSONObject argsObj = BizPackageSceneUtils.getArgsJsonObj();
            return argsObj != null && argsObj.getString(TOOL_KEY).equalsIgnoreCase(FRU_REPLACEMENT);
        }
        catch (JSONException e) {
            LOGGER.error("get scene args error, or no config args.");
            return false;
        }
    }

    static {
        sceneResultMap.put(SCENE_STATUS, SCENE_RESULT_FAILED);
    }
}

