/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable;

import com.huawei.ism.tool.sdk.unified.log.filter.LogFilterMark;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.IncludeDefaultSensitiveThrowableRule;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.SensitiveThrowable;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.SensitiveThrowableRule;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.SensitiveThrowableRuleChain;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.slf4j.Log4jLogger;

@Plugin(name="SensitiveThrowableFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public class SensitiveThrowableFilter
extends AbstractFilter {
    private static final String CONFIGURED_MARK = "##SensitiveThrowableFilter_Configured##";
    private static final String FQCN = Log4jLogger.FQCN;
    private final SensitiveThrowableRule rule;
    private final Configuration configuration;

    public SensitiveThrowableFilter(Filter.Result onMatch, Filter.Result onMismatch, SensitiveThrowableRule rule, Configuration configuration) {
        super(onMatch, onMismatch);
        this.rule = rule;
        this.configuration = configuration;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable throwable) {
        if (!SensitiveThrowable.containsSensitiveThrowable(throwable, this.rule)) {
            return this.onMismatch;
        }
        if (SensitiveThrowableFilter.isLoggerLevelEnabled(logger, level)) {
            Throwable replaced = SensitiveThrowable.replaceSensitiveThrowable(throwable, this.rule);
            logger.logMessage(level, marker, FQCN, this.getLocation(logger), msg, replaced);
        }
        return this.onMatch;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable throwable) {
        if (!SensitiveThrowable.containsSensitiveThrowable(throwable, this.rule)) {
            return this.onMismatch;
        }
        if (SensitiveThrowableFilter.isLoggerLevelEnabled(logger, level)) {
            Throwable replaced = SensitiveThrowable.replaceSensitiveThrowable(throwable, this.rule);
            logger.logMessage(level, marker, FQCN, this.getLocation(logger), logger.getMessageFactory().newMessage(msg), replaced);
        }
        return this.onMatch;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        if (params == null || params.length == 0 || !(params[params.length - 1] instanceof Throwable)) {
            return this.onMismatch;
        }
        if (params.length > 1 && params[params.length - 2] == LogFilterMark.INSENSITIVE) {
            return this.onMismatch;
        }
        Throwable throwable = (Throwable)params[params.length - 1];
        if (!SensitiveThrowable.containsSensitiveThrowable(throwable, this.rule)) {
            return this.onMismatch;
        }
        if (SensitiveThrowableFilter.isLoggerLevelEnabled(logger, level)) {
            Throwable replaced = SensitiveThrowable.replaceSensitiveThrowable(throwable, this.rule);
            Object[] newParams = Arrays.copyOf(params, params.length);
            newParams[newParams.length - 1] = replaced;
            Message message = logger.getMessageFactory().newMessage(msg, newParams);
            logger.logMessage(level, marker, FQCN, this.getLocation(logger), message, message.getThrowable());
        }
        return this.onMatch;
    }

    @PerformanceSensitive
    private StackTraceElement getLocation(Logger logger) {
        return this.configuration == null || this.configuration.getLoggerConfig(logger.getName()).requiresLocation() ? StackLocatorUtil.calcLocation((String)FQCN) : null;
    }

    public String toString() {
        return "SensitiveThrowableFilter{rule=" + this.rule + ", onMatch=" + this.onMatch + ", onMismatch=" + this.onMismatch + '}';
    }

    private static boolean isLoggerLevelEnabled(Logger logger, Level level) {
        return level != null && logger.getLevel().intLevel() >= level.intLevel();
    }

    private static SensitiveThrowableRule buildDefaultRule() {
        return IncludeDefaultSensitiveThrowableRule.newBuilder().build();
    }

    public static Filter buildOnRequired(Configuration configuration) {
        return configuration.getProperties().containsKey(CONFIGURED_MARK) ? null : ((FilterBuilder)((FilterBuilder)SensitiveThrowableFilter.newBuilder().setOnMatch(Filter.Result.DENY)).setOnMismatch(Filter.Result.NEUTRAL)).setConfiguration(configuration).build();
    }

    @PluginBuilderFactory
    public static FilterBuilder newBuilder() {
        return (FilterBuilder)((FilterBuilder)new FilterBuilder().setOnMatch(Filter.Result.DENY)).setOnMismatch(Filter.Result.NEUTRAL);
    }

    public static class FilterBuilder
    extends AbstractFilter.AbstractFilterBuilder<FilterBuilder>
    implements Builder<SensitiveThrowableFilter> {
        @PluginBuilderAttribute(value="enable")
        private boolean enable = true;
        @PluginElement(value="SensitiveThrowableRule")
        private SensitiveThrowableRule[] rules;
        @PluginConfiguration
        private Configuration configuration;

        public SensitiveThrowableFilter build() {
            SensitiveThrowableRule[] sensitiveThrowableRuleArray;
            if (!this.enable) {
                this.configuration.getProperties().put(SensitiveThrowableFilter.CONFIGURED_MARK, SensitiveThrowableFilter.CONFIGURED_MARK);
                return null;
            }
            if (this.rules == null || this.rules.length == 0) {
                SensitiveThrowableRule[] sensitiveThrowableRuleArray2 = new SensitiveThrowableRule[1];
                sensitiveThrowableRuleArray = sensitiveThrowableRuleArray2;
                sensitiveThrowableRuleArray2[0] = SensitiveThrowableFilter.buildDefaultRule();
            } else {
                sensitiveThrowableRuleArray = this.rules;
            }
            SensitiveThrowableRuleChain actualRule = new SensitiveThrowableRuleChain(sensitiveThrowableRuleArray);
            return new SensitiveThrowableFilter(this.getOnMatch(), this.getOnMismatch(), actualRule, this.configuration);
        }

        public boolean isEnable() {
            return this.enable;
        }

        public SensitiveThrowableRule[] getRules() {
            return this.rules;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public FilterBuilder setEnable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public FilterBuilder setRules(SensitiveThrowableRule[] rules) {
            this.rules = rules;
            return this;
        }

        public FilterBuilder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }
    }
}

