/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words;

import com.huawei.ism.tool.sdk.unified.log.filter.LogFilterMark;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule.IncludeDefaultSensitiveWordsRule;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule.SensitiveWordsRule;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.slf4j.Log4jLogger;

@Plugin(name="SensitiveWordsFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public abstract class SensitiveWordsFilter
extends AbstractFilter {
    private static final String CONFIGURED_MARK = "##SensitiveWordsFilter_Configured##";
    private static final String FQCN = Log4jLogger.FQCN;
    private static final String[] DEFAULT_FILTER_LOGGER_PATH_PREFIXES = new String[]{""};
    protected final SensitiveWordsRule[] rules;
    private final String[] loggerPathPrefixes;
    private final Configuration configuration;
    private final boolean checkThrowableMessage;
    private final boolean filterAllLogger;

    public SensitiveWordsFilter(Filter.Result onMatch, Filter.Result onMismatch, String loggerPathPrefixesStr, SensitiveWordsRule[] rules, Configuration configuration, boolean checkThrowableMessage) {
        super(onMatch, onMismatch);
        this.loggerPathPrefixes = SensitiveWordsFilter.parseLoggerPathPrefixes(loggerPathPrefixesStr);
        this.rules = rules;
        this.configuration = configuration;
        this.checkThrowableMessage = checkThrowableMessage;
        this.filterAllLogger = this.isFilterAllLogger();
    }

    private boolean isFilterAllLogger() {
        if (this.loggerPathPrefixes.length == 0) {
            return true;
        }
        for (String loggerPathPrefix : this.loggerPathPrefixes) {
            if (!loggerPathPrefix.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable throwable) {
        if (this.noNeedFilter(logger)) {
            return this.onMismatch;
        }
        return this.filterSensitiveWords(logger, level, marker, msg.getFormattedMessage(), throwable);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable throwable) {
        if (this.noNeedFilter(logger)) {
            return this.onMismatch;
        }
        return this.filterSensitiveWords(logger, level, marker, logger.getMessageFactory().newMessage(msg).getFormattedMessage(), throwable);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        Object last2ndParam;
        if (this.noNeedFilter(logger)) {
            return this.onMismatch;
        }
        Object lastParam = params != null && params.length > 0 ? params[params.length - 1] : null;
        Object object = last2ndParam = params != null && params.length > 1 ? params[params.length - 2] : null;
        if (lastParam == LogFilterMark.INSENSITIVE || last2ndParam == LogFilterMark.INSENSITIVE && lastParam instanceof Throwable) {
            return this.onMismatch;
        }
        return this.filterSensitiveWords(logger, level, marker, logger.getMessageFactory().newMessage(msg, params).getFormattedMessage(), lastParam instanceof Throwable ? (Throwable)lastParam : null);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object param) {
        if (this.noNeedFilter(logger)) {
            return this.onMismatch;
        }
        if (param == LogFilterMark.INSENSITIVE) {
            return this.onMismatch;
        }
        return this.filterSensitiveWords(logger, level, marker, logger.getMessageFactory().newMessage(msg, new Object[]{param}).getFormattedMessage(), param instanceof Throwable ? (Throwable)param : null);
    }

    protected final boolean filterMessage(Logger logger, Level level, Marker marker, String message) {
        if (Strings.isEmpty((CharSequence)message)) {
            return false;
        }
        for (SensitiveWordsRule rule : this.rules) {
            String filteredMessage = rule.filterSensitiveWords(message);
            if (filteredMessage == null) continue;
            if (level != null && logger.getLevel().intLevel() >= level.intLevel()) {
                Message logMessage = logger.getMessageFactory().newMessage(filteredMessage + "{}", new Object[]{LogFilterMark.INSENSITIVE});
                logger.logMessage(level, marker, FQCN, this.getLocation(logger), logMessage, logMessage.getThrowable());
            }
            return true;
        }
        return false;
    }

    protected abstract Filter.Result filterSensitiveWords(Logger var1, Level var2, Marker var3, String var4, Throwable var5);

    @PerformanceSensitive
    protected final StackTraceElement getLocation(Logger logger) {
        return this.configuration.getLoggerConfig(logger.getName()).requiresLocation() ? StackLocatorUtil.calcLocation((String)FQCN) : null;
    }

    private boolean noNeedFilter(Logger logger) {
        if (this.filterAllLogger) {
            return false;
        }
        String name = logger.getName();
        for (String prefix : this.loggerPathPrefixes) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SensitiveWordsFilter{onMatch=" + this.onMatch + ", loggerPathPrefixes=" + Arrays.toString(this.loggerPathPrefixes) + ", checkThrowableMessage=" + this.checkThrowableMessage + ", rules=" + Arrays.toString(this.rules) + ", filterAllLogger=" + this.filterAllLogger + ", onMismatch=" + this.onMismatch + '}';
    }

    private static SensitiveWordsRule[] buildDefaultRules() {
        return new SensitiveWordsRule[]{IncludeDefaultSensitiveWordsRule.newBuilder().build()};
    }

    private static String[] parseLoggerPathPrefixes(String value) {
        if (value == null || value.isEmpty()) {
            return (String[])DEFAULT_FILTER_LOGGER_PATH_PREFIXES.clone();
        }
        String[] split = (String[])Arrays.stream(value.split(",")).filter(part -> !part.isEmpty()).distinct().toArray(String[]::new);
        return split.length == 0 ? (String[])DEFAULT_FILTER_LOGGER_PATH_PREFIXES.clone() : split;
    }

    public static Filter buildOnRequired(Configuration configuration) {
        return configuration.getProperties().containsKey(CONFIGURED_MARK) ? null : new FilterLogMessageOnly(Filter.Result.DENY, Filter.Result.NEUTRAL, "", SensitiveWordsFilter.buildDefaultRules(), configuration);
    }

    @PluginBuilderFactory
    public static FilterBuilder newBuilder() {
        return (FilterBuilder)((FilterBuilder)new FilterBuilder().setOnMatch(Filter.Result.DENY)).setOnMismatch(Filter.Result.NEUTRAL);
    }

    public static class FilterBuilder
    extends AbstractFilter.AbstractFilterBuilder<FilterBuilder>
    implements Builder<SensitiveWordsFilter> {
        @PluginBuilderAttribute(value="enable")
        private boolean enable = true;
        @PluginBuilderAttribute(value="loggerPathPrefixes")
        private String loggerPathPrefixes;
        @PluginElement(value="SensitiveWordsRule")
        private SensitiveWordsRule[] rules;
        @PluginBuilderAttribute(value="checkThrowableMessage")
        private boolean checkThrowableMessage = false;
        @PluginConfiguration
        private Configuration configuration;

        public SensitiveWordsFilter build() {
            if (!this.enable) {
                this.configuration.getProperties().put(SensitiveWordsFilter.CONFIGURED_MARK, SensitiveWordsFilter.CONFIGURED_MARK);
                return null;
            }
            SensitiveWordsRule[] actualRules = this.rules == null || this.rules.length == 0 ? SensitiveWordsFilter.buildDefaultRules() : this.rules;
            return this.checkThrowableMessage ? new FilterLogAndThrowableMessage(this.getOnMatch(), this.getOnMismatch(), this.loggerPathPrefixes, actualRules, this.configuration) : new FilterLogMessageOnly(this.getOnMatch(), this.getOnMismatch(), this.loggerPathPrefixes, actualRules, this.configuration);
        }

        public boolean isEnable() {
            return this.enable;
        }

        public String getLoggerPathPrefixes() {
            return this.loggerPathPrefixes;
        }

        public SensitiveWordsRule[] getRules() {
            return this.rules;
        }

        public boolean isCheckThrowableMessage() {
            return this.checkThrowableMessage;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public FilterBuilder setEnable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public FilterBuilder setLoggerPathPrefixes(String loggerPathPrefixes) {
            this.loggerPathPrefixes = loggerPathPrefixes;
            return this;
        }

        public FilterBuilder setRules(SensitiveWordsRule[] rules) {
            this.rules = rules;
            return this;
        }

        public FilterBuilder setCheckThrowableMessage(boolean checkThrowableMessage) {
            this.checkThrowableMessage = checkThrowableMessage;
            return this;
        }

        public FilterBuilder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }
    }

    private static class FilterLogAndThrowableMessage
    extends SensitiveWordsFilter {
        private FilterLogAndThrowableMessage(Filter.Result onMatch, Filter.Result onMismatch, String loggerPathPrefixesStr, SensitiveWordsRule[] rules, Configuration configuration) {
            super(onMatch, onMismatch, loggerPathPrefixesStr, rules, configuration, true);
        }

        @Override
        protected Filter.Result filterSensitiveWords(Logger logger, Level level, Marker marker, String logMessage, Throwable throwable) {
            if (this.filterMessage(logger, level, marker, logMessage)) {
                return this.onMatch;
            }
            if (this.filterThrowableMessage(logger, level, marker, throwable)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }

        private boolean filterThrowableMessage(Logger logger, Level level, Marker marker, Throwable throwable) {
            if (throwable == null) {
                return false;
            }
            String message = throwable.getLocalizedMessage();
            if (!Strings.isEmpty((CharSequence)message) && this.filterMessage(logger, level, marker, message)) {
                return true;
            }
            if (this.filterThrowableMessage(logger, level, marker, throwable.getCause())) {
                return true;
            }
            Throwable[] suppressed = throwable.getSuppressed();
            if (suppressed == null) {
                return false;
            }
            for (Throwable oneSuppressed : suppressed) {
                if (!this.filterThrowableMessage(logger, level, marker, oneSuppressed)) continue;
                return true;
            }
            return false;
        }
    }

    private static class FilterLogMessageOnly
    extends SensitiveWordsFilter {
        private FilterLogMessageOnly(Filter.Result onMatch, Filter.Result onMismatch, String loggerPathPrefixesStr, SensitiveWordsRule[] rules, Configuration configuration) {
            super(onMatch, onMismatch, loggerPathPrefixesStr, rules, configuration, false);
        }

        @Override
        protected Filter.Result filterSensitiveWords(Logger logger, Level level, Marker marker, String logMessage, Throwable ignored) {
            return this.filterMessage(logger, level, marker, logMessage) ? this.onMatch : this.onMismatch;
        }
    }
}

