/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule;

import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule.SensitiveWordsRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.NotBlank;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="RegexFilterRule", category="Core", elementType="SensitiveWordsRule", printObject=true)
public abstract class RegexFilterRule
implements SensitiveWordsRule {
    protected final Pattern pattern;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    protected RegexFilterRule(Pattern pattern) {
        this.pattern = pattern;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<RegexFilterRule> {
        @NotBlank
        @PluginBuilderAttribute(value="regex")
        private String regex;
        @PluginBuilderAttribute(value="match")
        private boolean match = false;
        @PluginBuilderAttribute(value="replacement")
        private String replacement;

        public RegexFilterRule build() {
            Pattern actualPattern = Pattern.compile(this.regex);
            if (this.match) {
                return Strings.isEmpty((CharSequence)this.replacement) ? new MatchDefault(actualPattern) : new MatchReplace(actualPattern, this.replacement);
            }
            return Strings.isEmpty((CharSequence)this.replacement) ? new FindDefault(actualPattern) : new FindReplace(actualPattern, this.replacement);
        }

        public Builder setRegex(String regex) {
            this.regex = regex;
            return this;
        }

        public Builder setMatch(boolean match) {
            this.match = match;
            return this;
        }

        public Builder setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public String getRegex() {
            return this.regex;
        }

        public boolean isMatch() {
            return this.match;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }

    protected static class FindDefault
    extends RegexFilterRule {
        private FindDefault(Pattern pattern) {
            super(pattern);
        }

        @Override
        public String filterSensitiveWords(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.find()) {
                return SensitiveWordsRule.getDefaultShieldedMsg(this.pattern.toString());
            }
            return null;
        }

        public String toString() {
            return "RegexFilterRule.FindDefault{pattern=" + this.pattern + '}';
        }
    }

    protected static class FindReplace
    extends RegexFilterRule {
        private final String replacement;

        private FindReplace(Pattern pattern, String replacement) {
            super(pattern);
            this.replacement = replacement;
        }

        @Override
        public String filterSensitiveWords(String line) {
            Matcher matcher = this.pattern.matcher(line);
            boolean found = matcher.find();
            if (found) {
                StringBuffer sb = new StringBuffer();
                do {
                    matcher.appendReplacement(sb, this.replacement);
                } while (found = matcher.find());
                matcher.appendTail(sb);
                return sb.toString();
            }
            return null;
        }

        public String toString() {
            return "RegexFilterRule.FindReplace{replacement='" + this.replacement + '\'' + ", pattern=" + this.pattern + '}';
        }
    }

    protected static class MatchDefault
    extends RegexFilterRule {
        private MatchDefault(Pattern pattern) {
            super(pattern);
        }

        @Override
        public String filterSensitiveWords(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                return SensitiveWordsRule.getDefaultShieldedMsg(this.pattern.toString());
            }
            return null;
        }

        public String toString() {
            return "RegexFilterRule.MatchDefault{pattern=" + this.pattern + '}';
        }
    }

    protected static class MatchReplace
    extends RegexFilterRule {
        private final String replacement;

        private MatchReplace(Pattern pattern, String replacement) {
            super(pattern);
            this.replacement = replacement;
        }

        @Override
        public String filterSensitiveWords(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                return matcher.replaceAll(this.replacement);
            }
            return null;
        }

        public String toString() {
            return "RegexFilterRule.MatchReplace{replacement='" + this.replacement + '\'' + ", pattern=" + this.pattern + '}';
        }
    }
}

