/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.lifecycle.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.lifecycle.model.ToolLifecycleMessage;
import com.huawei.ism.tool.lifecycle.service.ToolLifecycleListener;
import com.huawei.ism.tool.lifecycle.util.ToolLifecycleMessageReportUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolLifecycleListenerManager {
    private static final Logger log = LoggerFactory.getLogger(ToolLifecycleListenerManager.class);
    private static final ToolLifecycleListenerManager INSTANCE = new ToolLifecycleListenerManager();
    private static final Pattern MESSAGE_FILE_PATTERN = Pattern.compile("^(?<bizType>[A-Z_]+)-(?<num>\\d{17})\\.json$");
    private static final Path TOOLBOX_MESSAGE_DIRECTORY = Paths.get(ApplicationContext.getInstance().getWorkPath(), new String[0]).resolve(ToolLifecycleMessageReportUtil.TOOL_MESSAGE_DIRECTORY);
    private final Map<String, List<ToolLifecycleListener<?>>> listeners = new HashMap();
    private final Map<String, Map<String, Type>> messageTypes = new HashMap<String, Map<String, Type>>();

    public static ToolLifecycleListenerManager getInstance() {
        return INSTANCE;
    }

    public void register(ToolLifecycleListener<?> listener) {
        String toolName = listener.getInterestedToolName();
        String bizType = listener.getInterestedBizType();
        if (this.messageTypes.getOrDefault("*", Collections.emptyMap()).containsKey(bizType)) {
            log.warn("Common listener of the {} has been registered in the {} tool. ", (Object)bizType, (Object)toolName);
            return;
        }
        TypeReference<?> messageType = listener.getReportMessageType();
        this.messageTypes.computeIfAbsent(toolName, ignored -> new HashMap()).put(bizType, new ParameterizedTypeImpl(((ParameterizedType)messageType.getClass().getGenericSuperclass()).getActualTypeArguments(), ToolLifecycleMessage.class, ToolLifecycleMessage.class));
        this.listeners.computeIfAbsent(toolName, ignored -> new ArrayList()).add(listener);
        log.info("Succeeded in registering the listener for the {} of the {} tool.", (Object)bizType, (Object)toolName);
    }

    public void tryReadMessageAndFire() {
        try (Stream<Path> toolFolders = Files.list(TOOLBOX_MESSAGE_DIRECTORY);){
            toolFolders.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> this.scanToolMessage((Path)path, path.getFileName().toString()));
        }
        catch (IOException e) {
            log.error("Read message failed", (Throwable)e);
        }
    }

    public void scanToolMessage(Path path, String toolName) {
        if (!this.listeners.containsKey(toolName) && !this.listeners.containsKey("*")) {
            return;
        }
        try (Stream<Path> messages = Files.list(path);){
            messages.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(messageFile -> this.parseAndFire(toolName, (Path)messageFile)).filter(Objects::nonNull).sorted(Comparator.comparing(MessageEntity::getNum)).forEach(this::safeFireMessage);
        }
        catch (IOException exception) {
            log.error("read tool lifecycle message files from {} error", (Object)path, (Object)exception);
        }
    }

    private void safeFireMessage(MessageEntity messageEntity) {
        try {
            log.info("firing tool lifecycle message {}", (Object)messageEntity);
            Stream.concat(this.listeners.getOrDefault(messageEntity.getToolName(), Collections.emptyList()).stream(), this.listeners.getOrDefault("*", Collections.emptyList()).stream()).filter(listener -> listener.getInterestedBizType().equals(messageEntity.getBizType())).forEach(listener -> ToolLifecycleListenerManager.safeConsumeMessage(messageEntity, listener));
        }
        catch (Exception exception) {
            log.warn("fire tool message {} error", (Object)messageEntity, (Object)exception);
        }
        finally {
            try {
                Files.delete(messageEntity.getMessageFile());
            }
            catch (IOException exception) {
                log.error("delete message file {} error", (Object)messageEntity.getMessageFile(), (Object)exception);
            }
        }
    }

    private static void safeConsumeMessage(MessageEntity messageEntity, ToolLifecycleListener<?> listener) {
        try {
            listener.onToolMessageReport(messageEntity.getData());
        }
        catch (Exception exception) {
            log.warn("fire tool {} message for {} error", new Object[]{listener.getInterestedToolName(), listener.getInterestedBizType(), exception});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageEntity parseAndFire(String toolName, Path messageFile) {
        String fileName = messageFile.getFileName().toString();
        Matcher matcher = MESSAGE_FILE_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        log.info("Tool lifecycle message files in: {} has been scanned", (Object)messageFile);
        String bizType = matcher.group("bizType");
        String num = matcher.group("num");
        Type messageDataType = this.getMessageDataType(toolName, bizType);
        try (InputStream inputStream = Files.newInputStream(messageFile, new OpenOption[0]);){
            ToolLifecycleMessage message = (ToolLifecycleMessage)JSON.parseObject((InputStream)inputStream, (Charset)StandardCharsets.UTF_8, (Type)messageDataType, (Feature[])new Feature[0]);
            MessageEntity messageEntity = new MessageEntity(toolName, bizType, num, message, messageFile);
            return messageEntity;
        }
        catch (IOException exception) {
            log.error("parse tool {} message file {} error", new Object[]{toolName, messageFile, exception});
            return null;
        }
    }

    private Type getMessageDataType(String toolName, String bizType) {
        Type type = (Type)this.messageTypes.getOrDefault(toolName, Collections.emptyMap()).get(bizType);
        if (type == null) {
            return (Type)this.messageTypes.getOrDefault("*", Collections.emptyMap()).get(bizType);
        }
        return type;
    }

    private ToolLifecycleListenerManager() {
    }

    private static class MessageEntity {
        private final String toolName;
        private final String bizType;
        private final String num;
        private final ToolLifecycleMessage data;
        private final Path messageFile;

        public String toString() {
            return "MessageEntity{toolName='" + this.toolName + '\'' + ", bizType='" + this.bizType + '\'' + ", num='" + this.num + '\'' + ", messageFile=" + this.messageFile + '}';
        }

        public String getToolName() {
            return this.toolName;
        }

        public String getBizType() {
            return this.bizType;
        }

        public String getNum() {
            return this.num;
        }

        public ToolLifecycleMessage getData() {
            return this.data;
        }

        public Path getMessageFile() {
            return this.messageFile;
        }

        public MessageEntity(String toolName, String bizType, String num, ToolLifecycleMessage data, Path messageFile) {
            this.toolName = toolName;
            this.bizType = bizType;
            this.num = num;
            this.data = data;
            this.messageFile = messageFile;
        }
    }
}

