/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.utils;

import com.huawei.ism.tool.certbase.enums.SafeEncodeAlgorithmEnum;
import com.huawei.ism.tool.certbase.exception.CertAlgorithmUnsafeException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Optional;
import javax.crypto.interfaces.DHPublicKey;

public class CertPublicKeyValidator {
    public static final String UNSAFE_ALGORITHM_ERROR_KEY = "Unsafe algorithm: ";

    public static void checkPublicKeyLength(PublicKey publicKey) throws CertificateException {
        if (publicKey instanceof RSAPublicKey) {
            CertPublicKeyValidator.checkRsaKeyLength((RSAPublicKey)publicKey);
            return;
        }
        if (publicKey instanceof DSAPublicKey) {
            CertPublicKeyValidator.checkDsaKeyLength((DSAPublicKey)publicKey);
            return;
        }
        if (publicKey instanceof ECPublicKey) {
            CertPublicKeyValidator.checkEccKeyLength((ECPublicKey)publicKey);
            return;
        }
        if (publicKey instanceof DHPublicKey) {
            CertPublicKeyValidator.checkDhKeyLength((DHPublicKey)publicKey);
            return;
        }
        throw new CertAlgorithmUnsafeException(publicKey.getAlgorithm());
    }

    private static void checkRsaKeyLength(RSAPublicKey publicKey) throws CertificateException {
        int keyLength = publicKey.getModulus().bitLength();
        if (keyLength < SafeEncodeAlgorithmEnum.RSA.getBits()) {
            throw new CertAlgorithmUnsafeException(publicKey.getAlgorithm() + keyLength);
        }
    }

    private static void checkDsaKeyLength(DSAPublicKey publicKey) throws CertificateException {
        int keyLength = publicKey.getY().bitLength();
        if (keyLength < SafeEncodeAlgorithmEnum.DSA.getBits()) {
            throw new CertAlgorithmUnsafeException(publicKey.getAlgorithm() + keyLength);
        }
    }

    private static void checkEccKeyLength(ECPublicKey publicKey) throws CertificateException {
        Integer keyLength = Optional.ofNullable(publicKey.getParams()).map(ECParameterSpec::getOrder).map(BigInteger::bitLength).orElse(0);
        if (keyLength < SafeEncodeAlgorithmEnum.EC.getBits()) {
            throw new CertAlgorithmUnsafeException(publicKey.getAlgorithm() + keyLength);
        }
    }

    private static void checkDhKeyLength(DHPublicKey publicKey) throws CertificateException {
        int keyLength = publicKey.getParams().getP().bitLength();
        if (keyLength < SafeEncodeAlgorithmEnum.DH.getBits()) {
            throw new CertAlgorithmUnsafeException(publicKey.getAlgorithm() + keyLength);
        }
    }

    private CertPublicKeyValidator() {
    }
}

