/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.util;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tool.devicegraph.service.DeviceGraphUiImpl;
import com.huawei.ism.tool.devicegraph.util.TypeConverter;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.IDeviceRetriever;
import com.huawei.ism.tool.framework.pubservice.exception.DeviceException;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareDetail;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;
import com.huawei.ism.tool.framework.pubui.common.ui.AbstractDeviceGraph;
import com.huawei.ism.tool.framework.pubui.entity.DeviceStatusEnum;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class DeviceGraphOp {
    private static final DeviceGraphOp INSTANCE = new DeviceGraphOp();
    private static IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
    private static IDeviceRetriever retriver = devMng.getDeviceRetriever(devMng.getCurrentDevice());
    private AbstractDeviceGraph deviceGraph = null;

    private DeviceGraphOp() {
    }

    public static DeviceGraphOp getInstance() {
        return INSTANCE;
    }

    public void buildGraph(String deviceType, List<Map<String, String>> devMapList, boolean isBack, boolean isSupportLight) {
        ApplicationContext context = ApplicationContext.getInstance();
        context.setDeviceGraphCfgPath("packages\\sometool\\products\\somtype\\DeviceGraphConfig.xml");
        context.setDeviceImgCfgPath("packages\\sometool\\products\\somtype\\res\\image");
        ArrayList<IHardwareInfo> hardwareList = new ArrayList<IHardwareInfo>();
        for (Map<String, String> devMap : devMapList) {
            hardwareList.add(TypeConverter.buildHardware(devMap));
        }
        DeviceGraphUiImpl uiImpl = new DeviceGraphUiImpl();
        this.deviceGraph = uiImpl.buildDeviceGraph(deviceType, hardwareList, isBack, isSupportLight);
    }

    public void highlightCable(Map<String, String> fromPortMap, Map<String, String> toPortMap, String status) throws DeviceException {
        IHardwareInfo fromPort = TypeConverter.buildHardware(fromPortMap);
        IHardwareInfo toPort = TypeConverter.buildHardware(toPortMap);
        IHardwareInfo fromParent = retriver.retrieveModule(MOType.getType((int)fromPort.getParentType()).name(), fromPort.getParentID());
        if (fromParent == null) {
            return;
        }
        HardwareDetail fromParentDetail = retriver.retrieveDetail(fromParent);
        IHardwareInfo toParent = retriver.retrieveModule(MOType.getType((int)toPort.getParentType()).name(), toPort.getParentID());
        if (toParent == null) {
            return;
        }
        HardwareDetail toParentDetail = retriver.retrieveDetail(toParent);
        this.deviceGraph.updateGraph(fromParentDetail);
        this.deviceGraph.updateGraph(toParentDetail);
        this.deviceGraph.highlightCable((IPortInfo)fromPort, (IPortInfo)toPort, DeviceStatusEnum.valueOf(status));
    }

    public void highlightModule(Map<String, String> moduleMap, String status) throws DeviceException {
        LoggerFactory.getLogger(DeviceGraphOp.class).info("[HL]" + moduleMap);
        IHardwareInfo module = TypeConverter.buildHardware(moduleMap);
        ArrayList<IHardwareInfo> moduleList = new ArrayList<IHardwareInfo>();
        moduleList.add(module);
        if (module.getTypeName().contains("PORT")) {
            IHardwareInfo parentInfo = retriver.retrieveModule(MOType.getTypeName((int)module.getParentType()), module.getParentID());
            if (parentInfo == null) {
                return;
            }
            HardwareDetail parentDetail = retriver.retrieveDetail(parentInfo);
            this.deviceGraph.updateGraph(parentDetail);
            List<Rectangle> recList = this.deviceGraph.getModulesLocation(moduleList);
            if (null != recList) {
                for (Rectangle rec : recList) {
                    this.deviceGraph.highLightModule(rec, DeviceStatusEnum.valueOf(status));
                }
            }
        } else {
            this.deviceGraph.highlightModules(moduleList, DeviceStatusEnum.valueOf(status));
        }
    }

    public void highlightModuleList(List<Map<String, String>> moduleMapList, String status) throws DeviceException {
        for (Map<String, String> moduleMap : moduleMapList) {
            this.highlightModule(moduleMap, status);
        }
    }

    public void clearGraph() {
        this.deviceGraph.clearDeviceGraph();
    }
}

