/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.entity;

import com.huawei.ism.tool.exttool.entity.ProductPackage;
import com.huawei.ism.tool.exttool.entity.Tool;
import com.huawei.ism.tool.exttool.entity.Version;
import com.huawei.ism.tool.exttool.util.ToolMngResource;

public final class EnumType {

    public static enum SoftStatus {
        NEWEST("newest"),
        UPDATABLE("updatable"),
        NOT_INSTALLED("notInstalled"),
        LATEST("latest");

        private String lowerClassValue;

        private SoftStatus(String lowerClassValue) {
            this.lowerClassValue = lowerClassValue;
        }

        public static SoftStatus getSoftStatus(Object object) {
            Version curVer = null;
            Version newVer = null;
            if (object instanceof Tool) {
                Tool tool = (Tool)object;
                curVer = tool.getCurVersion();
                newVer = tool.getNewVersion();
            } else if (object instanceof ProductPackage) {
                ProductPackage pro = (ProductPackage)object;
                curVer = pro.getCurVersion();
                newVer = pro.getNewVersion();
            }
            if (null == curVer) {
                return NOT_INSTALLED;
            }
            if (null != newVer && newVer.getReleaseDate().trim().compareTo(curVer.getReleaseDate().trim()) > 0) {
                return UPDATABLE;
            }
            return LATEST;
        }

        public String getLowerClassValue() {
            return this.lowerClassValue;
        }

        public String getValue() {
            return ToolMngResource.getString("soft.status." + this.getLowerClassValue());
        }

        public String toString() {
            return this.lowerClassValue;
        }
    }
}

