/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.util;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicemanager.ui.former.ExtendNodeSaveUtil;
import com.huawei.ism.tool.devicemanager.ui.former.service.IntelligentComputeSceneImpl;
import com.huawei.ism.tool.exttool.util.ToolEntry;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IConnSettingService;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.MultiRouteNode;
import com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo;
import com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;

public final class DeviceUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ToolEntry.class);

    private static String getDeviceJsonStrEncode(DevNode device, boolean nDev) throws JSONException {
        JSONObject json = new JSONObject();
        DeviceUtil.generateBasicInfoJson(device, nDev, json);
        json.put("storageDeviceType", (Object)device.getStorageDeviceType().getName());
        DeviceUtil.setComputerStorageCountInfo(device, nDev, json);
        json.put("ipListAreInnerIp", (Object)String.valueOf(device.isIpListAreInnerIp()));
        json.put("serialNo", (Object)device.getDeviceSerialNumber());
        String debugPwd = device.getDeveloperPwd();
        json.put("developerPwd", (Object)AESEncrypt.encrypt((String)debugPwd));
        json.put("scenarioInfo", (Object)device.getScenarioInfo());
        if (null != device.getRemoteSNs()) {
            JSONArray remoteSNList = new JSONArray();
            for (String devSN : device.getRemoteSNs()) {
                remoteSNList.put((Object)devSN);
            }
            json.put("remoteSNs", (Object)remoteSNList);
        }
        StringUtils.cleanPwd((String)debugPwd);
        if (null != device.getSocks5Proxy()) {
            JSONObject st = DeviceUtil.toSocks5ProxyJsonEncode(device.getSocks5Proxy(), nDev);
            json.put("sock5", (Object)st.toString());
        }
        if (null != device.getSshForwardList()) {
            json.put("sshForward", (Object)DeviceUtil.toListSshForwardJsonEncode(device.getSshForwardList(), nDev));
        }
        if (null != device.getPriKey()) {
            json.put("priKey", (Object)DeviceUtil.toPriKey(device.getPriKey(), nDev));
        }
        JSONArray ipList = new JSONArray();
        for (String ip : device.getIpList()) {
            ipList.put((Object)ip);
        }
        json.put("devInnerIps", (Object)ipList);
        json.put("highDevSVPModuleInfo", (Object)device.getHighDevSVPModuleInfo());
        json.put("canEnterDiagnose", device.canEnterDiagnose());
        return json.toString();
    }

    private static void setComputerStorageCountInfo(DevNode device, boolean isNewDev, JSONObject json) {
        if (device.getComputeStorageDevNode() != null) {
            json.put("computeStorageInfoFcvOpenApiUserName", (Object)DeviceUtil.encodeByBase64(device.getComputeStorageDevNode().getOpenapiUser().getUserName(), isNewDev));
            json.put("computeStorageInfoFcvOpenApiUserPwd", (Object)AESEncrypt.encrypt((String)device.getComputeStorageDevNode().getOpenapiUser().getPassword()));
            json.put("computeStorageInfoFcvIp", (Object)device.getComputeStorageDevNode().getFcvIp());
            json.put("computeStorageInfoFcvPort", (Object)String.valueOf(device.getComputeStorageDevNode().getFcvPort()));
            json.put("computeStorageInfoFcvDeviceId", (Object)String.valueOf(device.getComputeStorageDevNode().getComputeStorageFcvDeviceId()));
            json.put("computeStorageInfoChassisNum", (Object)device.getComputeStorageDevNode().getChassisNum());
            json.put("computeStorageInfoList", (Object)new JSONArray((Collection)device.getComputeStorageDevNode().getStorageNodesInfo()).toString());
        } else {
            DeviceUtil.setCubePassword(device, json);
        }
        String pwd = device.getLoginUser().getPassword();
        json.put("password", (Object)AESEncrypt.encrypt((String)pwd));
        if (device.getRootUser() != null) {
            json.put("rootPassword", (Object)AESEncrypt.encrypt((String)device.getRootUser().getPassword()));
        }
        StringUtils.cleanPwd((String)pwd);
    }

    private static void setCubePassword(DevNode device, JSONObject json) {
        if (!device.isFusionCube() || Objects.isNull(device.getFusionCubeLoginUser())) {
            return;
        }
        json.put("sshPassword", (Object)AESEncrypt.encrypt((String)device.getFusionCubeLoginUser().getPassword()));
    }

    private static void generateBasicInfoJson(DevNode device, boolean nDev, JSONObject json) {
        json.put("itDeviceTypeName", (Object)device.getItDeviceType().getName());
        if (VerifyUtil.isEmpty((Object)device.getDeviceType())) {
            json.put("devType", (Object)device.getDeviceType());
        } else {
            json.put("devType", (Object)device.getDeviceType().toString());
        }
        json.put("devVersion", (Object)device.getProductVersion());
        json.put("hotpatchversion", (Object)device.getHotPatchVersion());
        json.put("relatedSNIPs", device.getRelatedSNIPs());
        json.put("devName", (Object)DeviceUtil.encodeByBase64(device.getDeviceName(), nDev));
        json.put("username", (Object)DeviceUtil.encodeByBase64(device.getLoginUser().getUserName(), nDev));
        json.put("devIp", (Object)device.getIp());
        DeviceUtil.setFusionCubeInfo(json, nDev, device);
        json.put("port", device.getPort());
        json.put("isVerifyCertificate", device.isVerifyCertificate());
        json.put("sshHostKey", (Object)AESEncrypt.encrypt((String)device.getSshHostKey()));
        json.put("isVerifySshHostKey", (Object)AESEncrypt.encrypt((String)Boolean.toString(device.isVerifySshHostKey())));
        json.put("domain", device.getLoginUser().getUserName().startsWith("domain/"));
    }

    private static void setFusionCubeInfo(JSONObject json, boolean nDev, DevNode device) {
        if (!device.isFusionCube() || Objects.isNull(device.getFusionCubeLoginUser())) {
            return;
        }
        json.put("sshUsername", (Object)DeviceUtil.encodeByBase64(device.getFusionCubeLoginUser().getUserName(), nDev));
    }

    private static JSONObject toSocks5ProxyJsonEncode(Socks5Proxy socks5Proxy, boolean nDev) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("uuid", (Object)socks5Proxy.getUuid());
        json.put("name", (Object)DeviceUtil.encodeByBase64(socks5Proxy.getName(), nDev));
        json.put("serverIp", (Object)socks5Proxy.getServerIp());
        json.put("port", (Object)socks5Proxy.getPort());
        json.put("user", (Object)DeviceUtil.encodeByBase64(socks5Proxy.getUser(), nDev));
        String pwd = socks5Proxy.getPass();
        json.put("pass", (Object)AESEncrypt.encrypt((String)pwd));
        StringUtils.cleanPwd((String)pwd);
        json.put("authentic", socks5Proxy.isAuthentic());
        return json;
    }

    public static void setDevJsonEncode(StringBuffer envSb, IDeviceManage devMng) {
        int j = 0;
        for (DevNode device : devMng.getNodeList()) {
            try {
                String json = DeviceUtil.getDeviceJsonStrEncode(device, false);
                envSb.append("set jsonDevEncode_" + ++j + "=");
                envSb.append(json + "\r\n ");
            }
            catch (JSONException e) {
                LOGGER.error("Get device json error:" + device.getIp());
            }
        }
        int i = 0;
        for (DevNode device : devMng.getNodeList()) {
            try {
                String jsonNew = DeviceUtil.getDeviceJsonStrEncode(device, true);
                envSb.append("set jsonDevEncodeNew_" + ++i + "=");
                envSb.append(jsonNew + "\r\n ");
            }
            catch (JSONException e) {
                LOGGER.error("Get device json error:" + device.getIp());
            }
        }
    }

    private static String toPriKey(PriKeyInfo priKey, boolean nDev) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("keyname", (Object)DeviceUtil.encodeByBase64(priKey.getKeyName(), nDev));
        jsonObj.put("keypath", (Object)DeviceUtil.encodeByBase64(priKey.getKeyPath(), nDev));
        jsonObj.put("keypwd", (Object)AESEncrypt.encrypt((String)priKey.getKeyPwd()));
        return jsonObj.toString();
    }

    public static String toListSshForwardJsonEncode(List<MultiRouteNode> sshForwardList, boolean nDev) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (MultiRouteNode mu : sshForwardList) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("port", mu.getPort());
            jsonObj.put("host", (Object)mu.getHost());
            String pwd = mu.getPwd();
            jsonObj.put("pwd", (Object)AESEncrypt.encrypt((String)pwd));
            StringUtils.cleanPwd((String)pwd);
            jsonObj.put("uname", (Object)DeviceUtil.encodeByBase64(mu.getUname(), nDev));
            jsonArray.put((Object)jsonObj);
        }
        return jsonArray.toString();
    }

    private static String encodeByBase64(String pliant, boolean nDev) {
        if (nDev) {
            return Base64EncodeUtils.encodeNew(pliant);
        }
        return Base64EncodeUtils.encode(pliant);
    }

    public static String getSocks5JsonArrStrEncode() {
        IConnSettingService connSettingService = (IConnSettingService)PublicServiceManage.getInstance().getService(IConnSettingService.class);
        List lSock5 = connSettingService.getProxies();
        JSONArray socks5JsonArr = new JSONArray();
        for (Socks5Proxy socks5Proxy : lSock5) {
            try {
                JSONObject json = DeviceUtil.toSocks5ProxyJsonEncode(socks5Proxy, false);
                socks5JsonArr.put((Object)json);
            }
            catch (JSONException e) {
                LOGGER.error("Get Socks5Porxy json error");
            }
        }
        return socks5JsonArr.toString();
    }

    public static String getSocks5JsonArrStrEncodeNew() {
        IConnSettingService connSettingService = (IConnSettingService)PublicServiceManage.getInstance().getService(IConnSettingService.class);
        List lSock5New = connSettingService.getProxies();
        JSONArray socks5JsonArr = new JSONArray();
        for (Socks5Proxy socks5ProxyNew : lSock5New) {
            try {
                JSONObject json = DeviceUtil.toSocks5ProxyJsonEncode(socks5ProxyNew, true);
                socks5JsonArr.put((Object)json);
            }
            catch (JSONException e) {
                LOGGER.error("Get Socks5Porxy json error");
            }
        }
        return socks5JsonArr.toString();
    }

    public static String getSshJsonArrStrEncode() {
        return DeviceUtil.getSshJsonArrStrEncode(false);
    }

    public static String getSshJsonArrStrEncodeNew() {
        return DeviceUtil.getSshJsonArrStrEncode(true);
    }

    private static String getSshJsonArrStrEncode(boolean isNewDev) {
        IConnSettingService connSettingService = (IConnSettingService)PublicServiceManage.getInstance().getService(IConnSettingService.class);
        KeyOrderedHashMap kl = connSettingService.getSshForwards();
        Iterator iterator = kl.entrySet().iterator();
        JSONArray sshJsonArr = new JSONArray();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            try {
                JSONObject json = DeviceUtil.toSshForwardJsonEncode((String)entry.getKey(), (List)entry.getValue(), isNewDev);
                sshJsonArr.put((Object)json);
            }
            catch (JSONException e) {
                LOGGER.error("Get json error:{}", entry.getKey());
            }
        }
        return sshJsonArr.toString();
    }

    private static JSONObject toSshForwardJsonEncode(String key, List<MultiRouteNode> muList, boolean nDev) throws JSONException {
        JSONArray jsonArr = new JSONArray();
        for (MultiRouteNode mu : muList) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("port", mu.getPort());
            jsonObj.put("host", (Object)mu.getHost());
            jsonObj.put("pwd", (Object)AESEncrypt.encrypt((String)mu.getPwd()));
            jsonObj.put("uname", (Object)DeviceUtil.encodeByBase64(mu.getUname(), nDev));
            jsonArr.put((Object)jsonObj);
        }
        JSONObject json = new JSONObject();
        json.put("key", (Object)key);
        json.put("val", (Object)jsonArr);
        return json;
    }

    public static void writeAiNodeToPrepareFile() {
        IntelligentComputeSceneImpl intelligentComputeScene = new IntelligentComputeSceneImpl();
        intelligentComputeScene.saveAiExtend(ExtendNodeSaveUtil.TO_PREPARE_FILE);
    }
}

