/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.util;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.common.toolbox.IStartBsChangeListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.slf4j.Logger;

public class ExecUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExecUtil.class);
    private static final int START_TOOL_TIME = 60;
    private static final String CMD_EXE = "cmd.exe";
    private static final String SH = "sh";
    private static final String CMDC = "/c";
    private static final String START_TOOL_ENV_SET = "set";
    private static final String EQUAL_SIGN = "=";
    private static final int SET_ENVNAME_START = 4;
    private static final int REFRESH_SLEEP_TIME = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execStartTool(String cmd, String workPath, String proName, String toolName) {
        File workDir = ExecUtil.getToolWorkPath(workPath);
        String result = "";
        ProcessBuilder pb = ExecUtil.buildProcessBuilder(cmd, workDir, proName);
        pb.redirectErrorStream(true);
        Process process = null;
        StreamClearThread inClearThread = null;
        int waitForCode = -1;
        int exitCode = -1;
        boolean exitFlag = false;
        try {
            process = pb.start();
            inClearThread = new StreamClearThread(process.getInputStream());
            inClearThread.setName(toolName + " Start inputStream Clear Thread");
            inClearThread.start();
            inClearThread.join();
            LOGGER.info("start tool {} begin waitFor.", (Object)toolName);
            waitForCode = process.waitFor();
            exitCode = process.exitValue();
            exitFlag = true;
            LOGGER.info("start tool {} end waitFor.", (Object)toolName);
        }
        catch (IOException e) {
            LOGGER.error("start tool process Io exception.");
        }
        catch (InterruptedException | RuntimeException e) {
            LOGGER.error("start tool get exit code error.");
            if (!VerifyUtil.isEmpty(inClearThread)) {
                while (!exitFlag) {
                    try {
                        Thread.sleep(1000L);
                        inClearThread.refreshNoIo();
                        exitCode = process.exitValue();
                        exitFlag = true;
                    }
                    catch (InterruptedException | RuntimeException ex) {
                        LOGGER.error("start tool get exit code error.", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            ExecUtil.closeResource(process);
        }
        result = "waitForCode:" + waitForCode + " ,exitCode:" + exitCode;
        LOGGER.info("start tool destroy success proName:{} result:{}", (Object)toolName, (Object)result);
        return result;
    }

    private static File getToolWorkPath(String workPath) {
        File workDir = null;
        if (!StringUtils.isNULLObjectOrNullStr((String)workPath)) {
            String toolkitPath = ApplicationContext.getInstance().getWorkPath();
            workDir = new File(toolkitPath, workPath);
        }
        return workDir;
    }

    private static void closeResource(Process process) {
        if (null != process) {
            StreamUtils.closeResource(null, (Closeable)process.getOutputStream());
            StreamUtils.closeResource(null, (Closeable)process.getInputStream());
            StreamUtils.closeResource(null, (Closeable)process.getErrorStream());
            process.destroy();
        }
    }

    private static ProcessBuilder buildProcessBuilder(String cmd, File workDir, String processName) {
        String[] cmdArr;
        ProcessBuilder pb = ApplicationContext.getInstance().isWindowsOS() ? new ProcessBuilder(CMD_EXE, CMDC, processName) : new ProcessBuilder(SH, processName);
        pb.directory(workDir);
        Map<String, String> env = pb.environment();
        for (String cmdStr : cmdArr = cmd.split(System.lineSeparator())) {
            if (!(cmdStr = cmdStr.trim()).startsWith(START_TOOL_ENV_SET) || !cmdStr.contains(EQUAL_SIGN)) continue;
            String keyValue = cmdStr.substring(4);
            int idx = keyValue.indexOf(EQUAL_SIGN);
            String key = keyValue.substring(0, idx);
            String value = keyValue.substring(idx + 1);
            env.put(key, value);
        }
        return pb;
    }

    static class StreamClearThread
    extends Thread {
        InputStream in;

        public StreamClearThread(InputStream in) {
            this.in = in;
        }

        public void refreshNoIo() {
            try {
                this.refresh();
            }
            catch (IOException e) {
                LOGGER.error("refresh io error.", (Throwable)e);
            }
        }

        private void refresh() throws IOException {
            String line = null;
            try (BufferedReader bf = new BufferedReader(new InputStreamReader(this.in, "utf-8"));){
                while (!VerifyUtil.isEmpty((Object)bf) && (line = bf.readLine()) != null) {
                    IStartBsChangeListener startBsChangeListener = ApplicationContext.getInstance().getStartBsChangeListener();
                    if (null == startBsChangeListener || StringUtils.isNULLStr((String)line)) continue;
                    startBsChangeListener.refreshCMDOutputStr(line.toString());
                }
            }
        }

        @Override
        public void run() {
            try {
                this.refresh();
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("refresh io error unsupport encoding.", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("refresh io error io error.", (Throwable)e);
            }
        }
    }
}

