/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.util;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.exttool.entity.ToolOperationState;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class StartToolCheck {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(StartToolCheck.class);
    private static final int MAX_WAIT_SECORDS = 180000;
    private static final String RUNNING_FLAG = "runningFlag";
    private static volatile StartToolCheck instace = null;

    private StartToolCheck() {
    }

    public static StartToolCheck getInstace() {
        if (null == instace) {
            instace = new StartToolCheck();
        }
        return instace;
    }

    public boolean getToolStartViewCallable(Window parent, String toolPath, ToolOperationState state) {
        List ret = AsyncExcutor.execute((Window)parent, (boolean)false, (long)0L, (Callable[])new Callable[]{new GetToolStartCallable(toolPath, state)});
        return (Boolean)ret.get(0);
    }

    public boolean getToolStopViewCallable(Window parent, String toolPath, ToolOperationState state) {
        List ret = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new GetToolStartCallable(toolPath, state)});
        return (Boolean)ret.get(0);
    }

    private boolean checkToolState(String toolPath, ToolOperationState state) {
        boolean isFlag = true;
        try {
            long currSecords = System.currentTimeMillis();
            if (this.isExecuteWaitStop(state)) {
                while (true) {
                    if (System.currentTimeMillis() - currSecords >= 180000L) {
                        isFlag = false;
                        break;
                    }
                    if (this.checkSingleToolStop(toolPath)) break;
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
            }
            if (this.isExecuteWaitStart(state) && isFlag) {
                while (true) {
                    if (System.currentTimeMillis() - currSecords >= 180000L) {
                        isFlag = false;
                    } else if (!this.checkSingleToolStart(toolPath)) {
                        TimeUnit.MILLISECONDS.sleep(1000L);
                        continue;
                    }
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            isFlag = false;
            LOGGER.error("wait tool start exception");
        }
        return isFlag;
    }

    private boolean checkSingleToolStop(String toolPath) {
        String runFlagPath = toolPath + File.separator + RUNNING_FLAG;
        File file = new File(runFlagPath);
        return !file.exists() || file.delete();
    }

    private boolean checkSingleToolStart(String toolPath) {
        String runFlagPath = toolPath + File.separator + RUNNING_FLAG;
        File file = new File(runFlagPath);
        return file.exists() && !file.delete();
    }

    private boolean isExecuteWaitStop(ToolOperationState state) {
        return ToolOperationState.STOP_TOOL.equals((Object)state) || ToolOperationState.RESTART_TOOL.equals((Object)state);
    }

    private boolean isExecuteWaitStart(ToolOperationState state) {
        return ToolOperationState.START_TOOL.equals((Object)state) || ToolOperationState.RESTART_TOOL.equals((Object)state);
    }

    private class GetToolStartCallable
    implements Callable<Boolean> {
        private String toolPath;
        private ToolOperationState state;

        public GetToolStartCallable(String toolPath, ToolOperationState state) {
            this.toolPath = toolPath;
            this.state = state;
        }

        @Override
        public Boolean call() {
            return StartToolCheck.this.checkToolState(this.toolPath, this.state);
        }
    }
}

