/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Connection;
import io.nats.client.impl.AckType;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

class NatsJetStreamMessage
extends NatsMessage.InternalMessage {
    private NatsJetStreamMetaData jsMetaData = null;

    NatsJetStreamMessage() {
    }

    @Override
    public void ack() {
        this.ackReply(AckType.AckAck, -1L);
    }

    @Override
    public void ackSync(Duration d) throws InterruptedException, TimeoutException {
        if (this.ackHasntBeenTermed()) {
            Validator.validateDurationRequired(d);
            Connection nc = this.getJetStreamValidatedConnection();
            if (nc.request(this.replyTo, AckType.AckAck.bytes, d) == null) {
                throw new TimeoutException("Ack response timed out.");
            }
            this.lastAck = AckType.AckAck;
        }
    }

    @Override
    public void nak() {
        this.ackReply(AckType.AckNak, -1L);
    }

    @Override
    public void nakWithDelay(Duration nakDelay) {
        this.ackReply(AckType.AckNak, nakDelay.toNanos());
    }

    @Override
    public void nakWithDelay(long nakDelayMillis) {
        this.ackReply(AckType.AckNak, nakDelayMillis * 1000000L);
    }

    @Override
    public void inProgress() {
        this.ackReply(AckType.AckProgress, -1L);
    }

    @Override
    public void term() {
        this.ackReply(AckType.AckTerm, -1L);
    }

    @Override
    public NatsJetStreamMetaData metaData() {
        if (this.jsMetaData == null) {
            this.jsMetaData = new NatsJetStreamMetaData(this);
        }
        return this.jsMetaData;
    }

    @Override
    public boolean isJetStream() {
        return true;
    }

    private void ackReply(AckType ackType, long delayNanos) {
        if (this.ackHasntBeenTermed()) {
            Connection nc = this.getJetStreamValidatedConnection();
            nc.publish(this.replyTo, ackType.bodyBytes(delayNanos));
            this.lastAck = ackType;
        }
    }

    private boolean ackHasntBeenTermed() {
        return this.lastAck == null || !this.lastAck.terminal;
    }

    Connection getJetStreamValidatedConnection() {
        if (this.getSubscription() == null) {
            throw new IllegalStateException("Message is not bound to a subscription.");
        }
        Connection c = this.getConnection();
        if (c == null) {
            throw new IllegalStateException("Message is not bound to a connection");
        }
        return c;
    }
}

