/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicemanager.entity.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProductUniqueIdConfig {
    private static final Logger log = LoggerFactory.getLogger(ProductUniqueIdConfig.class);
    private static final String UID_CONFIG_FILE = "config/product_uid.xml";
    private static final Map<String, List<Platform>> HARDWARE_TYPE_MAP = new HashMap<String, List<Platform>>();
    public static final ProductUniqueIdConfig INS = new ProductUniqueIdConfig();

    private ProductUniqueIdConfig() {
        this.initUid();
    }

    public HardwareType getHardwareTypeByUid(String uid) {
        for (Map.Entry<String, List<Platform>> hardware2Platform : HARDWARE_TYPE_MAP.entrySet()) {
            if (!ProductUniqueIdConfig.searchInPlatform(uid, hardware2Platform.getValue())) continue;
            return HardwareType.getByType(hardware2Platform.getKey());
        }
        log.info("no type found by uid :{}", (Object)uid);
        return HardwareType.UNKNOWN;
    }

    public HardwarePlatform getPlatformTypeByUid(String uid) {
        for (Map.Entry<String, List<Platform>> stringListEntry : HARDWARE_TYPE_MAP.entrySet()) {
            List<Platform> platforms = stringListEntry.getValue();
            for (Platform platform : platforms) {
                if (!ProductUniqueIdConfig.searchInPlatformType(platform, uid)) continue;
                return HardwarePlatform.getById(platform.getPlatformId());
            }
        }
        log.info("no type found by uid :{}", (Object)uid);
        return HardwarePlatform.UNKNOWN;
    }

    public Optional<String> getTypeIdByUid(String uid) {
        if (StringUtils.isNULLStr((String)uid)) {
            return Optional.empty();
        }
        for (Map.Entry<String, List<Platform>> stringListEntry : HARDWARE_TYPE_MAP.entrySet()) {
            List<Platform> platforms = stringListEntry.getValue();
            for (Platform platform : platforms) {
                Optional<String> typeId = platform.getPlatformTypes().stream().filter(e -> e.getProductUniqueIds().contains(uid.toUpperCase(Locale.ROOT))).map(Platform.PlatformType::getTypeId).findFirst();
                if (!typeId.isPresent()) continue;
                return typeId;
            }
        }
        log.info("no type found by uid :{}", (Object)uid);
        return Optional.empty();
    }

    private static boolean searchInPlatform(String uid, List<Platform> platforms) {
        for (Platform platform : platforms) {
            if (!ProductUniqueIdConfig.searchInPlatformType(platform, uid)) continue;
            return true;
        }
        return false;
    }

    private static boolean searchInPlatformType(Platform platform, String uid) {
        String upperUid = uid.toUpperCase(Locale.ROOT);
        for (Platform.PlatformType platformType : platform.getPlatformTypes()) {
            Set<String> productUniqueIds = platformType.getProductUniqueIds();
            if (!productUniqueIds.contains(upperUid)) continue;
            return true;
        }
        return false;
    }

    private void initUid() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream fileInputStream = classLoader.getResourceAsStream(UID_CONFIG_FILE);){
            if (Objects.isNull(fileInputStream)) {
                log.warn("file not exists :{}", (Object)UID_CONFIG_FILE);
                return;
            }
            Document document = XmlUtils.parseDocument((InputStream)fileInputStream);
            this.parseDoc(document);
        }
        catch (IOException e) {
            log.error("parse uid file error.", (Throwable)e);
        }
    }

    private void parseDoc(Document document) {
        Map<String, Element> stringNodeMap = this.searchHardwareType(document);
        this.searchPlatform(stringNodeMap);
    }

    private void searchPlatform(Map<String, Element> stringNodeMap) {
        for (Map.Entry<String, Element> stringNodeEntry : stringNodeMap.entrySet()) {
            Element productNode = stringNodeEntry.getValue();
            NodeList platform = XmlUtils.searchNodeByExp((Element)productNode, (String)"platform");
            HARDWARE_TYPE_MAP.put(stringNodeEntry.getKey(), this.getPlatform(platform));
        }
    }

    private List<Platform> getPlatform(NodeList platformNodeList) {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        if (platformNodeList == null) {
            log.info("platforms is null");
            return platforms;
        }
        for (int i = 0; i < platformNodeList.getLength(); ++i) {
            Node platformNode = platformNodeList.item(i);
            if (!(platformNode instanceof Element)) continue;
            String platformId = ((Element)platformNode).getAttribute("id");
            Platform platform = new Platform(platformId, this.getPlatformTypeList(XmlUtils.searchNodeByExp((Element)((Element)platformNode), (String)"type")));
            platforms.add(platform);
        }
        return platforms;
    }

    private List<Platform.PlatformType> getPlatformTypeList(NodeList typeNode) {
        ArrayList<Platform.PlatformType> types = new ArrayList<Platform.PlatformType>();
        if (typeNode == null) {
            log.info("typeNode is null");
            return types;
        }
        for (int i = 0; i < typeNode.getLength(); ++i) {
            Node type = typeNode.item(i);
            if (!(type instanceof Element)) continue;
            String id = ((Element)type).getAttribute("id");
            Set<String> uidSet = this.getProductUniqueSet(XmlUtils.searchNodeByExp((Element)((Element)type), (String)"productUniqueId"));
            types.add(new Platform.PlatformType(id, uidSet));
        }
        return types;
    }

    private Set<String> getProductUniqueSet(NodeList productUniqueId) {
        HashSet<String> uidSet = new HashSet<String>();
        if (productUniqueId == null) {
            log.info("productUniqueId is null");
            return uidSet;
        }
        for (int i = 0; i < productUniqueId.getLength(); ++i) {
            Node item = productUniqueId.item(i);
            if (!(item instanceof Element)) continue;
            uidSet.addAll(Arrays.stream(item.getTextContent().trim().split(",")).map(String::trim).map(String::toUpperCase).collect(Collectors.toSet()));
        }
        return uidSet;
    }

    private Map<String, Element> searchHardwareType(Document document) {
        HashMap<String, Element> productMap = new HashMap<String, Element>();
        NodeList nodes = XmlUtils.searchNodeByExp((Document)document, (String)"product/hardwareType");
        if (nodes == null) {
            log.error("search HardwareType failed. nodes is null. ");
            return productMap;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            String id;
            Node node = nodes.item(i);
            if (!(node instanceof Element) || StringUtils.isNULLStr((String)(id = ((Element)node).getAttribute("id")))) continue;
            productMap.put(id, (Element)node);
        }
        return productMap;
    }

    public static enum HardwarePlatform {
        TAISHAN_V1("TaiShan V1"),
        TAISHAN_V2("TaiShan V2"),
        X86_64("x86_64"),
        HG_X86_64("HG x86"),
        ATLANTIC("atlantic"),
        PACIFIC("pacific"),
        X86_V6("x86_v6"),
        EAST_SEA("eastSea"),
        CUBE_2288("x86_2288"),
        CUBE_2488("x86_2488"),
        NEW_ATLANTIC("new_atlantic"),
        SSM_ATLANTIC("ssm_atlantic"),
        SI_NAN("siNan"),
        UNKNOWN("unknown");

        private final String id;

        public static HardwarePlatform getById(String id) {
            return Arrays.stream(HardwarePlatform.values()).filter(platform -> platform.id.equals(id)).findFirst().orElse(UNKNOWN);
        }

        public String toString() {
            return this.id;
        }

        private HardwarePlatform(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum HardwareType {
        X86("x86"),
        KUN_PENG("kunpeng"),
        UNKNOWN("unknown");

        private final String type;

        private static HardwareType getByType(String type) {
            return Arrays.stream(HardwareType.values()).filter(hardwareType -> hardwareType.type.equals(type)).findFirst().orElse(UNKNOWN);
        }

        private HardwareType(String type) {
            this.type = type;
        }
    }
}

