/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.cert.auth.AbstractAuthStep;
import com.huawei.ism.tool.cert.auth.CollectDevice9000AuthStep;
import com.huawei.ism.tool.cert.auth.CollectDeviceTV3AuthStep;
import com.huawei.ism.tool.cert.auth.RestAuthStep;
import com.huawei.ism.tool.devicemanager.utils.CertCheckCfmUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.NetUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CertCheckUtil {
    private static final int PORT_8080 = 8080;
    private static final int PORT_19001 = 19001;
    private static final int PORT_8088 = 8088;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CertCheckUtil.class);

    public static int checkDevCert(DevNode devNode) {
        if (CertCheckCfmUtils.isTCfmrusteDev(devNode.getDeviceSerialNumber())) {
            return 0;
        }
        if (CertCheckUtil.isDevSupported(devNode)) {
            return new CertCheckTask(devNode).check();
        }
        return 0;
    }

    private static boolean isHostDevice(DevNode devNode) {
        return ItDeviceType.Host.equals((Object)devNode.getItDeviceType());
    }

    private static boolean isDevSupported(DevNode devNode) {
        return !CertCheckUtil.isHostDevice(devNode);
    }

    private static class CertCheckTask {
        private static final int CONN_ERROR_TMT = 15;
        private static final int DEFAULT_TIMEOUT = 30;
        private DevNode devNode;
        private CountDownLatch checkOverLatch = new CountDownLatch(1);
        private CountDownLatch connerrorLatch = new CountDownLatch(3);
        private CountDownLatch doneLatch = new CountDownLatch(3);
        private boolean isFailed = false;

        public CertCheckTask(DevNode devNode) {
            this.devNode = devNode;
        }

        public Integer check() {
            try {
                AsyncExcutor.submit((Callable)new SingleCertChecker((AbstractAuthStep)new CollectDeviceTV3AuthStep(this.devNode, 8080)));
                AsyncExcutor.submit((Callable)new SingleCertChecker((AbstractAuthStep)new RestAuthStep(this.devNode, 8088)));
                AsyncExcutor.submit((Callable)new SingleCertChecker((AbstractAuthStep)new CollectDevice9000AuthStep(this.devNode, 19001)));
                if (this.checkOverLatch.await(30L, TimeUnit.SECONDS)) {
                    if (this.isFailed) {
                        LOGGER.error("certificate check failed.");
                        return -2;
                    }
                    return 0;
                }
                if (this.connerrorLatch.await(15L, TimeUnit.SECONDS)) {
                    LOGGER.error("certificate check exception.");
                    return -1;
                }
                LOGGER.info("time out when waiting for the connerrorLatch.");
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(CertCheckUtil.class).error("exec check error", (Throwable)e);
                return -3;
            }
            return -2;
        }

        private class SingleCertChecker
        implements Callable<Integer> {
            private AbstractAuthStep authStep;

            public SingleCertChecker(AbstractAuthStep authStep) {
                this.authStep = authStep;
            }

            @Override
            public Integer call() {
                int result = -2;
                if (this.authStep == null) {
                    return result;
                }
                try {
                    if (!NetUtil.isHostConnectable((String)this.authStep.getIp(), (int)this.authStep.getPort())) {
                        ToolLoggerFactory.getLogger(CertCheckUtil.class).info("Host not reachable in 2 seconds:" + this.authStep.getIp() + " port:" + this.authStep.getPort());
                        Integer n = -2;
                        return n;
                    }
                    result = this.authStep.process();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("process result is:" + result);
                    }
                    if (0 == result) {
                        CertCheckTask.this.checkOverLatch.countDown();
                    } else if (-1 == result) {
                        CertCheckTask.this.connerrorLatch.countDown();
                    }
                }
                finally {
                    CertCheckTask.this.doneLatch.countDown();
                    if (CertCheckTask.this.doneLatch.getCount() == 0L && 0 != result && CertCheckTask.this.connerrorLatch.getCount() != 0L) {
                        LOGGER.error("cert check failed.");
                        CertCheckTask.this.checkOverLatch.countDown();
                        CertCheckTask.this.isFailed = true;
                    }
                }
                return result;
            }
        }
    }
}

