/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.devicemanager.service.AbstractDeviceService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.A3000InfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.CyberEngineInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DpcClusterQueryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.FusionCubeInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import java.util.Collection;
import org.slf4j.Logger;

public class DeviceModifyService
extends AbstractDeviceService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceModifyService.class);

    public TaskResult modifyDevice(DevNode devNode, DeviceOpr opr) {
        TaskResult result = null;
        if (devNode.isFusionCube()) {
            FusionCubeInfoQryServiceImpl cubeInfoQryService = new FusionCubeInfoQryServiceImpl();
            result = cubeInfoQryService.queryNodeInfo(devNode, opr);
        } else if (devNode.isA3000()) {
            A3000InfoQryServiceImpl a3000InfoQryService = new A3000InfoQryServiceImpl();
            result = a3000InfoQryService.queryNodeInfo(devNode, opr);
        } else if (devNode.isA800DpcOm()) {
            result = new DpcClusterQueryServiceImpl().queryNodeInfo(devNode, opr);
        } else if (devNode.isDsStorage() && !devNode.isFusionCube()) {
            result = this.getDstorageNodeTypeQuery().queryNodeInfo(devNode, opr);
        } else if (devNode.getStorageDeviceType().equals((Object)ItDeviceType.COMPUTE_STORAGE)) {
            result = this.getComputeStorageTypeQuery().queryNodeInfo(devNode, opr);
        } else if (devNode.isOceanCyber()) {
            CyberEngineInfoQryServiceImpl cyberEngineInfoQryService = new CyberEngineInfoQryServiceImpl();
            result = cyberEngineInfoQryService.queryNodeInfo(devNode, opr);
        } else {
            result = this.getNodeTypeQueryObject().queryNodeInfo(devNode, opr);
        }
        if (result.getResult() == TaskResult.Result.FAILED || result.getResultObject() == null) {
            return result;
        }
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            DevNode modifyDevNode = (DevNode)result.getResultObject();
            try {
                if (DeviceAddUtil.isA800SceneInToolBox() && ItDeviceType.A800_OM.equals((Object)modifyDevNode.getItDeviceType())) {
                    this.updateOmNode(modifyDevNode);
                } else {
                    DefaultNodeProviderImpl.getInstance().modifyDevice(modifyDevNode);
                }
            }
            catch (ToolException e) {
                LOGGER.error("Modify device error.", (Throwable)e);
                result.setResult(TaskResult.Result.FAILED);
                result.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
                result.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
                return result;
            }
        }
        return result;
    }

    private void updateOmNode(DevNode modifyDevNode) {
        DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getOmNodes).flatMap(Collection::stream).filter(node -> node.getDeviceSerialNumber().equals(modifyDevNode.getDeviceSerialNumber())).forEach(node -> node.setLoginUser(modifyDevNode.getLoginUser()));
    }
}

