/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.devicemanager.utils.ModeTypeParse;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.DpaRestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnFactory;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpaInfoQryServiceImpl
implements INodeTypeQuery {
    private static final Logger log = LoggerFactory.getLogger(DpaInfoQryServiceImpl.class);
    public static final String DEVICE_CANNOT_CONNECT = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
    public static final String FCE_LOGIN_ROLE_NOT_OPENAPI = "fce.login.role.is.not.openapi";
    public static final String CLUSTER_INFO_QUERY_FAIL = "devicemanager.layout.device.add.deviceadddialog.query.cluster.info.fail";
    public static final Map<String, List<String>> DPA_RELATIONSHIP_HOST = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, String> DPA_CDM_SOLUTION_MAP = new HashMap<String, String>(){
        {
            this.put("8.0.1.7", "8.2.RC2");
            this.put("8.0.1.8", "8.2.0");
            this.put("8.0.1.9", "8.3.RC1");
            this.put("8.0.2.0", "8.3.RC2");
        }
    };
    protected INodeSupport nodeSupport = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        TaskResult ret = new TaskResult();
        ret.setResultObject((Object)devNode);
        try {
            DpaRestConnection restConn = RestConnFactory.getDpaRestConn(devNode);
            restConn.login();
            if (!restConn.isLogin()) {
                String errId = DEVICE_CANNOT_CONNECT;
                ret.setErrorId(errId);
                ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)errId, (Object[])new Object[]{devNode.getIp()}));
                ret.setResult(TaskResult.Result.FAILED);
                log.error("rest conn is build failed.");
                TaskResult taskResult = ret;
                return taskResult;
            }
            if (!this.getStorageDeviceInfo(devNode, restConn)) {
                log.error("Query cluster info by dpa failed.");
                this.makeQueryCluserInfoFailResult(devNode, ret);
            }
            log.info("Query node info by dpa success.");
            ret.setResult(TaskResult.Result.SUCCESS);
            ret.setErrorLocaleDescription("");
            ret.setResultObject((Object)devNode);
            this.nodeSupportCheck(devNode, ret);
            this.checkRestCert(restConn, devNode);
            TaskResult taskResult = ret;
            return taskResult;
        }
        catch (ToolException e) {
            if ("No trusted certificate found".equals(e.getErrorId())) {
                ret.setNeedCertWarn(true);
                TaskResult taskResult = ret;
                return taskResult;
            }
            ret.setErrorId(e.getErrorId());
            log.error("execute cmd error.", (Throwable)e);
            this.makeErrorTaskResult(devNode, ret);
            TaskResult taskResult = ret;
            return taskResult;
        }
        finally {
            RestConnectionManager.releaseDpaConnection(devNode);
        }
    }

    protected void nodeSupportCheck(DevNode devNode, TaskResult ret) {
        if (this.nodeSupport == null || TaskResult.Result.FAILED.equals((Object)ret.getResult())) {
            return;
        }
        DeviceType tmpType = DeviceType.valueOf((String)(devNode.getDeviceType() + " " + devNode.getProductVersion()));
        com.huawei.ism.tool.framework.pubservice.entity.DevNode newDevNode = EntityUtils.toNewDev((DevNode)devNode);
        if (this.nodeSupport.isNodeSupport(newDevNode)) {
            return;
        }
        if (this.nodeSupport instanceof SceneAddDeviceAction) {
            this.setTaskFailedResultWithSceneNotSupportErrMsg((SceneAddDeviceAction)this.nodeSupport, ret, devNode, tmpType);
            return;
        }
        this.setTaskFailedResult(ret, devNode, tmpType);
    }

    protected void setTaskFailedResultWithSceneNotSupportErrMsg(SceneAddDeviceAction sceneAddDeviceAction, TaskResult ret, DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
        } else {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)sceneAddDeviceAction.getAddDevErrMsgPropKey(), (Object[])new Object[]{devNode.getIp(), tmpType}));
        }
    }

    protected void setTaskFailedResult(TaskResult ret, DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
            return;
        }
        ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.nosupportdevtype", (Object[])new Object[]{devNode.getIp(), tmpType}));
    }

    public boolean getStorageDeviceInfo(DevNode devNode, DpaRestConnection conn) {
        try {
            ResponseInfo dpaRelationshipHost = conn.execGet(conn.getQueryDpaRelationshipHost());
            ResponseInfo clusterPdtInfoResp = conn.execGet(conn.getQueryDevTypeInfoUrl());
            JSONObject jsonObj = new JSONObject(clusterPdtInfoResp.getContent());
            JSONObject jsonObjDpaRelationshipHost = new JSONObject(dpaRelationshipHost.getContent());
            JSONArray dataArray = jsonObjDpaRelationshipHost.getJSONObject("responseData").getJSONArray("data");
            ArrayList<String> nodeIpList = new ArrayList<String>();
            for (int i = 0; i < dataArray.length(); ++i) {
                JSONObject node = dataArray.getJSONObject(i);
                nodeIpList.add(node.getString("nodeIp"));
            }
            DPA_RELATIONSHIP_HOST.put(devNode.getIp(), nodeIpList);
            String errorCode = jsonObj.getStringOrDefault("status", "fail");
            String errorDes = jsonObj.getStringOrDefault("error", "");
            if (!"success".equals(errorCode)) {
                log.error("Query dpa nodes failed, error code:" + errorCode + ", error description:" + errorDes);
                throw new ToolException("error code:" + errorCode + ", error desc:" + errorDes);
            }
            JSONObject obj = jsonObj.getJSONObject("responseData");
            String productType = obj.getStringOrDefault("productType", "CDM");
            devNode.setProductModel(productType);
            devNode.setProductVersion(this.getProductVersion(obj));
            devNode.setDeviceName(obj.getStringOrDefault("productName", "CDM 8.0.0"));
            devNode.setDeviceModel(productType);
            String deviceMode = ModeTypeParse.getModelType(productType);
            DeviceType type = DeviceType.valueOf((String)deviceMode);
            devNode.setDeviceType(type);
            devNode.setDeviceSerialNumber("CONVERGED-DATA-MANAGEMENT-" + devNode.getIp().replace(".", "-"));
            log.info("query dpa ProductInfo : node info:{}", (Object)devNode.toString());
            return true;
        }
        catch (JSONException e) {
            log.error("get dpa DeviceInfo JSONException:", (Throwable)e);
            return false;
        }
        catch (ToolException te) {
            log.error("get dpa DeviceInfo tool exception:", (Throwable)te);
            return false;
        }
        catch (Exception e) {
            log.error("get dpa DeviceInfo exception:", (Throwable)e);
            return false;
        }
    }

    private String getProductVersion(JSONObject obj) {
        String productVersion = obj.getStringOrDefault("productVersion", "8.0.1.8.219");
        productVersion = StringUtils.isNULLStr((String)DPA_CDM_SOLUTION_MAP.get(productVersion.substring(0, 7))) ? productVersion : DPA_CDM_SOLUTION_MAP.get(productVersion.substring(0, 7));
        return productVersion;
    }

    private void makeErrorTaskResult(DevNode devNode, TaskResult ret) {
        String errorDes;
        if (ret.getErrorId().equals(FCE_LOGIN_ROLE_NOT_OPENAPI)) {
            errorDes = ResourceUtil.getString((String)FCE_LOGIN_ROLE_NOT_OPENAPI);
            ret.setErrorLocaleDescription(errorDes);
            ret.setResult(TaskResult.Result.FAILED);
        }
        errorDes = ResourceUtil.getStringWithParams((String)DEVICE_CANNOT_CONNECT, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeQueryCluserInfoFailResult(DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)CLUSTER_INFO_QUERY_FAIL, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    public static Map<String, List<String>> getDPA_RELATIONSHIP_HOST() {
        return DPA_RELATIONSHIP_HOST;
    }

    public INodeSupport getNodeSupport() {
        return this.nodeSupport;
    }

    public void setNodeSupport(INodeSupport nodeSupport) {
        this.nodeSupport = nodeSupport;
    }
}

