/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.implement;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.enums.LoginStep;
import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.SettingAction;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.AiStorageAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceModifyDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.AbstractPublicUI;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.framework.pubui.common.IPublicUI;
import com.huawei.ism.tool.framework.pubui.common.IToolBoxUI;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JDialog;

public class IDeviceManageUIImpl
extends AbstractPublicUI
implements IDeviceManageUI {
    private static final List<LoginStep> A800_SHOW_STEPS = Arrays.asList(LoginStep.DME_LOGIN, LoginStep.ZONE_LOGIN);

    protected boolean init() {
        IToolBoxUI toolBoxUI = (IToolBoxUI)PublicUiManage.getInstance().getUi(IToolBoxUI.class);
        if (null != toolBoxUI) {
            toolBoxUI.registerSettingAction((AbstractAction)new SettingAction());
        }
        return true;
    }

    public boolean showAddDeviceDialog(JDialog parent, List<String> devTypeList, boolean needDevPwd, boolean needForward, boolean needSocks5) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), ShowSysConstans.getShowSysCmds());
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
        DeviceAddDialog dialog = new DeviceAddDialog((Window)parent, nodeTypeQuery, tips);
        dialog.setForwardEnabled(needForward);
        dialog.setSocks5Enabled(needSocks5);
        if (!needForward && !needSocks5) {
            dialog.setNoProxyEnabled(false);
        }
        if (needDevPwd) {
            dialog.setDeveloperSelected(true);
        }
        if (ApplicationContext.getInstance().isJunit()) {
            return false;
        }
        dialog.setVisible(true);
        return true;
    }

    @Deprecated
    public boolean showModifyDeviceDialog(Window parent, boolean needDevPwd, String key, List<DevNode> devNodes) {
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        com.huawei.ism.tool.obase.entity.DevNode devNode = this.getDevNodeByIp(key, devMng.getNodeList());
        if (null == devNode) {
            return false;
        }
        DeviceModifyDialog dialog = new DeviceModifyDialog(parent, devNode, EntityUtils.toOldDevList(devNodes), needDevPwd);
        if (StringUtils.isNULLStr((String)devNode.getLoginUser().getPassword()) && null != devNode.getPriKey()) {
            dialog.setPasswordDisable();
        }
        dialog.setVisible(true);
        return true;
    }

    private com.huawei.ism.tool.obase.entity.DevNode getDevNodeByIp(String ip, List<DevNode> list) {
        for (DevNode devNode : list) {
            if (!devNode.getIp().equals(ip)) continue;
            return EntityUtils.toOldDev((DevNode)devNode);
        }
        return null;
    }

    private com.huawei.ism.tool.obase.entity.DevNode getDevNodeByDevKey(String devKey, List<DevNode> list) {
        for (DevNode devNode : list) {
            if (!devNode.getDevKey().equals(devKey)) continue;
            return EntityUtils.toOldDev((DevNode)devNode);
        }
        return null;
    }

    public boolean showAddDeviceDialog(JDialog parent, List<String> devTypeList, boolean needDevPwd) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), ShowSysConstans.getShowSysCmds());
        return this.showDialog(parent, nodeTypeQuery, needDevPwd);
    }

    public boolean showAddDeviceDialog(JDialog parent, List<String> devTypeList, INodeSupport devSupport, boolean needDevPwd) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), devSupport, ShowSysConstans.getShowSysCmds());
        return this.showDialog(parent, nodeTypeQuery, needDevPwd);
    }

    public boolean showAddDeviceDialog(JDialog parent, List<String> devTypeList, INodeSupport devSupport, DeviceDialogType dlgType, DeviceManageSetting manageSetting) {
        return this.showAddDialogByType(parent, devTypeList, devSupport, dlgType, manageSetting);
    }

    public boolean showAddDeviceDialog(JDialog parent, List<String> devTypeList, INodeSupport devSupport, DeviceManageSetting manageSetting) {
        return this.showAddDialogByType(parent, devTypeList, devSupport, DeviceDialogType.StorageOnly, manageSetting);
    }

    private boolean showAddDialogByType(JDialog parent, List<String> devTypeList, INodeSupport devSupport, DeviceDialogType dlgType, DeviceManageSetting manageSetting) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), devSupport, ShowSysConstans.getShowSysCmds());
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
        SceneAddDeviceAction.setSetting(manageSetting);
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (Objects.nonNull(sceneJson) && sceneJson.getStringOrDefault("subScene", "").contains("ReplacingCertificates")) {
            return this.showCertReplaceAddDialog(parent, manageSetting, nodeTypeQuery, tips);
        }
        if (SceneUtils.isA800SceneInTool() || DeviceAddUtil.isA800SceneInToolBox()) {
            return this.showIntelligentComputeDialog(parent);
        }
        return this.showDefaultAddDialog(parent, dlgType, manageSetting, nodeTypeQuery, tips);
    }

    private boolean showIntelligentComputeDialog(JDialog parent) {
        if (SceneUtils.isA800UpgradeCheck()) {
            new AiStorageAddDialog((Window)parent, A800_SHOW_STEPS).setVisible(true);
        } else {
            new AiStorageAddDialog((Window)parent).setVisible(true);
        }
        return true;
    }

    private boolean showDefaultAddDialog(JDialog parent, DeviceDialogType dlgType, DeviceManageSetting manageSetting, DefaultNodeTypeQuery nodeTypeQuery, DeviceAddDialog.InfoTips tips) {
        DeviceAddDialog dialog = null;
        dialog = DeviceDialogType.StorageOnly.equals((Object)dlgType) ? new DeviceAddDialog((Window)parent, nodeTypeQuery, tips) : new DeviceAddDialog((Window)parent, (INodeTypeQuery)nodeTypeQuery, tips, manageSetting, SettingType.Socks5Proxy, SettingType.SshForward);
        if (manageSetting.isNeedDevPwd()) {
            dialog.setDeveloperSelected(true);
        }
        dialog.setForwardEnabled(manageSetting.isNeedForward());
        dialog.setSocks5Enabled(manageSetting.isNeedSocks5());
        if (!manageSetting.isNeedForward() && !manageSetting.isNeedSocks5()) {
            dialog.setNoProxyEnabled(false);
        }
        if (ApplicationContext.getInstance().isJunit()) {
            return false;
        }
        dialog.setVisible(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showCertReplaceAddDialog(JDialog parent, DeviceManageSetting manageSetting, INodeTypeQuery nodeTypeQuery, DeviceAddDialog.InfoTips tips) {
        try {
            System.setProperty("deviceAddProperties", "replaceCert");
            manageSetting.getItDeviceList().add(ItDeviceType.Storage);
            manageSetting.getItDeviceList().add(ItDeviceType.FUSION_STORAGE);
            manageSetting.getItDeviceList().add(ItDeviceType.FUSIONCUBE);
            manageSetting.getItDeviceList().add(ItDeviceType.FUSION_COMPUTE);
            manageSetting.getItDeviceList().add(ItDeviceType.Host);
            SceneDeviceAddDialog sceneDeviceAddDialog = new SceneDeviceAddDialog((Window)parent, manageSetting, nodeTypeQuery, tips);
            sceneDeviceAddDialog.setVisible(true);
            boolean bl = true;
            return bl;
        }
        finally {
            System.getProperties().remove("deviceAddProperties");
        }
    }

    private boolean showDialog(JDialog parent, DefaultNodeTypeQuery nodeTypeQuery, boolean needDevPwd) {
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
        DeviceAddDialog dialog = new DeviceAddDialog((Window)parent, nodeTypeQuery, tips);
        if (needDevPwd) {
            dialog.setDeveloperSelected(true);
        }
        if (ApplicationContext.getInstance().isJunit()) {
            return false;
        }
        dialog.setVisible(true);
        return true;
    }

    private List<DeviceType> getDevTypeList(List<String> devTypeStrListS) {
        ArrayList<DeviceType> type = new ArrayList<DeviceType>();
        for (String deviceTypeStr : devTypeStrListS) {
            type.add(DeviceType.valueOf((String)deviceTypeStr));
        }
        return type;
    }

    public List<IPublicUI> getImplementedUIs() {
        ArrayList<IPublicUI> list = new ArrayList<IPublicUI>();
        list.add((IPublicUI)this);
        return list;
    }

    protected AbstractContext getContext() {
        return null;
    }

    public boolean showMultiInfoDialog(Window parent, Map<String, String> deviceMap, boolean newWindow) {
        if (null == deviceMap || deviceMap.isEmpty()) {
            return true;
        }
        ArrayList<ArrayList<Object>> failRet = new ArrayList<ArrayList<Object>>();
        for (Map.Entry<String, String> entry : deviceMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(entry.getKey());
            tmp.add(entry.getValue());
            failRet.add(tmp);
        }
        return SubDialogUtils.showMultiInfoDialog(parent, failRet, newWindow);
    }

    public boolean showMultiInfoDialog(Map<String, Map<String, String>> deviceMap, Window parent, boolean newWindow) {
        if (null == deviceMap || deviceMap.isEmpty()) {
            return true;
        }
        ArrayList<ArrayList<Object>> failRet = new ArrayList<ArrayList<Object>>();
        Iterator<Map.Entry<String, Map<String, String>>> iterator = deviceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            int failRetSize = failRet.size();
            Map.Entry<String, Map<String, String>> entry = iterator.next();
            String entryKey = entry.getKey();
            Map<String, String> entryValue = entry.getValue();
            if (!entryValue.containsKey(entryKey)) {
                ArrayList<String> headTmp = new ArrayList<String>();
                headTmp.add(entryKey);
                headTmp.add("NA");
                failRet.add(failRetSize, headTmp);
            }
            for (Map.Entry<String, String> entry2 : entryValue.entrySet()) {
                String entryKey2 = entry2.getKey();
                String entryValue2 = entry2.getValue();
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add((entryKey2.equals(entryKey) ? "" : "    ") + entryKey2);
                tmp.add(entryValue2);
                if (entryKey2.equals(entryKey)) {
                    failRet.add(failRetSize, tmp);
                    continue;
                }
                failRet.add(tmp);
            }
        }
        return SubDialogUtils.showMultiInfoDialog(parent, failRet, newWindow);
    }

    public boolean showMultiInfoDialog(Window parent, String msg, String[] headers, Map<String, String> map) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        ArrayList fail = new ArrayList();
        for (Map.Entry<String, String> en : map.entrySet()) {
            ArrayList<String> tmpObj = new ArrayList<String>();
            tmpObj.add(en.getKey());
            tmpObj.add(en.getValue());
            fail.add(tmpObj);
        }
        SubDialogUtils.showMultiInfoDialog(parent, msg, headers, fail);
        return true;
    }

    public boolean showModifyDeviceDialogByDevKey(Window parent, boolean needDevPwd, String devKey, List<DevNode> devNodes) {
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        com.huawei.ism.tool.obase.entity.DevNode devNode = this.getDevNodeByDevKey(devKey, devMng.getNodeList());
        if (null == devNode) {
            return false;
        }
        DeviceModifyDialog dialog = new DeviceModifyDialog(parent, devNode, EntityUtils.toOldDevList(devNodes), needDevPwd);
        dialog.setVisible(true);
        return true;
    }

    @Deprecated
    public boolean showModifyIntegrateDeviceDialog(Window parent, boolean needDevPwd, String key, List<DevNode> devNodes) {
        com.huawei.ism.tool.obase.entity.DevNode devNode = this.getDevNodeByIp(key, devNodes);
        if (null == devNode) {
            return false;
        }
        DeviceModifyDialog dialog = new DeviceModifyDialog(parent, devNode, EntityUtils.toOldDevList(devNodes), needDevPwd);
        dialog.setVisible(true);
        return true;
    }

    public boolean showModifyIntegrateDeviceDialogByDevKey(Window parent, boolean needDevPwd, String devKey, List<DevNode> devNodes) {
        com.huawei.ism.tool.obase.entity.DevNode devNode = this.getDevNodeByDevKey(devKey, devNodes);
        if (null == devNode) {
            return false;
        }
        DeviceModifyDialog dialog = new DeviceModifyDialog(parent, devNode, EntityUtils.toOldDevList(devNodes), needDevPwd);
        dialog.setVisible(true);
        return true;
    }
}

