/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.implement;

import com.huawei.ism.tool.devicemanager.service.implement.DevQueryTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class XlsTemplateResolver {
    private static List<String> allIP = new ArrayList<String>();

    public List<DevQueryTask> parseXls2Tasks(File xlsFile) throws ToolException {
        HSSFSheet devInfoSheet;
        ArrayList<DevQueryTask> qrList;
        FileInputStream fis;
        HSSFWorkbook workbook;
        block6: {
            ToolLoggerFactory.getLogger(this.getClass()).info("start resolve xls file :" + xlsFile);
            workbook = null;
            fis = null;
            qrList = new ArrayList<DevQueryTask>();
            fis = new FileInputStream(xlsFile);
            workbook = new HSSFWorkbook((InputStream)fis);
            devInfoSheet = workbook.getSheetAt(0);
            Row row = devInfoSheet.getRow(0);
            String devIp = POIUtils.getStringCellValue((Cell)row.getCell(0));
            String username = POIUtils.getStringCellValue((Cell)row.getCell(1));
            String password = POIUtils.getStringCellValue((Cell)row.getCell(2));
            if (devIp.equals(ResourceUtil.getString((String)"device.importdialog.ip")) && username.equals(ResourceUtil.getString((String)"device.importdialog.username")) && password.equals(ResourceUtil.getString((String)"device.importdialog.pwd"))) break block6;
            List<DevQueryTask> list = null;
            StreamUtils.closeResource(null, (Closeable)workbook);
            StreamUtils.closeStream(null, (InputStream)fis);
            return list;
        }
        try {
            int rows = devInfoSheet.getLastRowNum() + 1;
            for (int startLine = 1; startLine < rows; ++startLine) {
                DevQueryTask t = this.parseLine((Sheet)devInfoSheet, startLine);
                qrList.add(t);
            }
        }
        catch (Exception e) {
            try {
                throw new ToolException("parseXls2Tasks error.", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, workbook);
                StreamUtils.closeStream(null, (InputStream)fis);
                throw throwable;
            }
        }
        StreamUtils.closeResource(null, (Closeable)workbook);
        StreamUtils.closeStream(null, (InputStream)fis);
        return qrList;
    }

    private DevQueryTask parseLine(Sheet devInfoSheet, int lineNum) {
        Row row = devInfoSheet.getRow(lineNum);
        String devIp = POIUtils.getStringCellValue((Cell)row.getCell(0));
        String username = POIUtils.getStringCellValue((Cell)row.getCell(1));
        String password = POIUtils.getStringCellValue((Cell)row.getCell(2));
        allIP.add(devIp);
        return new DevQueryTask(devIp, username, password);
    }

    public static List<String> getIP() {
        return allIP;
    }
}

