/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.pub;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DebugPwdStepDialog;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.IDeviceRetriever;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.slf4j.Logger;

public class DeviceManageImpl
implements IDeviceManage {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceManageImpl.class);
    private static DefaultNodeProviderImpl devContainer = DefaultNodeProviderImpl.getInstance();

    public void addDevice(DevNode node) {
        com.huawei.ism.tool.obase.entity.DevNode dev = EntityUtils.toOldDev((DevNode)node);
        try {
            if (devContainer.isContainsNode(dev)) {
                devContainer.removeNode(dev);
            }
            devContainer.addNode(dev);
        }
        catch (ToolException e) {
            LOGGER.error("[Add device >> " + dev + "][Failed]", (Throwable)e);
        }
    }

    public void addNodeObservers(com.huawei.ism.tool.framework.pubservice.listener.INodeObserver observer) {
        if (null == observer) {
            return;
        }
        devContainer.addNodeObservers(new DevNodeObservers(observer));
    }

    public List<com.huawei.ism.tool.framework.pubservice.listener.INodeObserver> getAllNodeObservers() {
        return new ArrayList<com.huawei.ism.tool.framework.pubservice.listener.INodeObserver>();
    }

    public IDeviceRetriever getDeviceRetriever(DevNode node) {
        return null;
    }

    public DevNode getCurrentDevice() {
        if (devContainer.getNodeList().isEmpty()) {
            return null;
        }
        return EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)devContainer.getNodeList().get(0));
    }

    public List<DevNode> getNodeList() {
        return EntityUtils.toNewDevList(devContainer.getNodeList());
    }

    public boolean isContainsNode(DevNode node) {
        return devContainer.isContainsNode(EntityUtils.toOldDev((DevNode)node));
    }

    public void removeAllNodeObservers(com.huawei.ism.tool.framework.pubservice.listener.INodeObserver observer) {
    }

    public void removeNodeObserver(Class<? extends com.huawei.ism.tool.framework.pubservice.listener.INodeObserver> clazz) {
    }

    public String[] getShowSysCmds() {
        return new String[0];
    }

    public boolean showDebugSetDialog(JFrame parent, String title) {
        DebugPwdStepDialog dialog = new DebugPwdStepDialog(parent, title);
        dialog.setVisible(true);
        return dialog.isCheckOK();
    }

    public void updateDevVersion(String type, String sn, String newVersion) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("updating dev version success:" + type + "," + sn + "," + newVersion);
        }
        for (com.huawei.ism.tool.obase.entity.DevNode dev : devContainer.getNodeList()) {
            if (!dev.getDeviceType().toString().equals(type) || !dev.getDeviceSerialNumber().equals(sn)) continue;
            dev.setProductVersion(newVersion);
            try {
                devContainer.modifyDevice(dev);
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("updated dev version success:" + type + "," + sn + "," + newVersion);
            }
            catch (ToolException e) {
                LOGGER.error("[Modify dev version >> sn = " + sn + "][Failed]", (Throwable)e);
            }
            break;
        }
    }

    public IDeviceRetriever getDeviceRetriever(DevNode node, IConnectionManage conmm) {
        return null;
    }

    public synchronized boolean deleteOneDevice(String ip) {
        List<com.huawei.ism.tool.obase.entity.DevNode> nodes = devContainer.getNodeList();
        for (com.huawei.ism.tool.obase.entity.DevNode devNode : nodes) {
            if (!ip.equals(devNode.getIp())) continue;
            try {
                devContainer.removeNode(devNode);
            }
            catch (ToolException e) {
                LOGGER.error("[Delete dev >> " + ip + "][Failed]", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void addInfoGrabNodeObservers(com.huawei.ism.tool.framework.pubservice.listener.INodeObserver observer) {
        if (null == observer) {
            return;
        }
        devContainer.addInfoGrabNodeObservers(new DevNodeObservers(observer));
    }

    public void updateDevVersion(String type, String sn, String newVersion, String hotpatch) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("updating dev version success:" + type + "," + sn + "," + newVersion + "," + hotpatch);
        }
        for (com.huawei.ism.tool.obase.entity.DevNode dev : devContainer.getNodeList()) {
            if (!dev.getDeviceType().toString().equals(type) || !dev.getDeviceSerialNumber().equals(sn)) continue;
            dev.setProductVersion(newVersion);
            dev.setHotPatchVersion(hotpatch);
            try {
                devContainer.modifyDevice(dev);
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("updated dev version success:" + type + "," + sn + "," + newVersion + "," + hotpatch);
            }
            catch (ToolException e) {
                LOGGER.error("[Modify dev version >> sn = " + sn + "][Failed]", (Throwable)e);
            }
            break;
        }
    }

    public static final class DevNodeObservers
    implements INodeObserver {
        private final com.huawei.ism.tool.framework.pubservice.listener.INodeObserver observer;

        public com.huawei.ism.tool.framework.pubservice.listener.INodeObserver getObserver() {
            return this.observer;
        }

        private DevNodeObservers(com.huawei.ism.tool.framework.pubservice.listener.INodeObserver observer) {
            this.observer = observer;
        }

        @Override
        public void fireNodeAdd(com.huawei.ism.tool.obase.entity.DevNode dev) throws ToolException {
            this.observer.fireNodeAdd(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)dev));
        }

        @Override
        public void fireNodeDelete(com.huawei.ism.tool.obase.entity.DevNode dev) throws ToolException {
            this.observer.fireNodeDelete(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)dev));
        }

        @Override
        public void fireNodeModify(com.huawei.ism.tool.obase.entity.DevNode dev) throws ToolException {
            this.observer.fireNodeModify(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)dev));
        }
    }
}

