/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.task;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicemanager.service.DeviceManageService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.IDeviceManageService;
import com.huawei.ism.tool.devicemanager.service.task.IDeviceOperaObserver;
import com.huawei.ism.tool.devicemanager.ui.former.XmlFormer;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserDataType;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDeviceData;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ModifyTask
extends ServiceTask {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ModifyTask.class);
    private IDeviceManageService deviceManageService = new DeviceManageService();
    private ProgressNumDialog progressDialog;
    private List<DevNode> devNodes;
    private User newUser;
    private User fusionCubeLoginUser;
    private String devPwd;
    private PriKeyInfo info;
    private IDeviceOperaObserver deviceModifyObserver = null;
    private boolean deviceStatus = false;
    private DeviceOpr opr = DeviceOpr.EDIT;
    private AtomicInteger deviceIndex = new AtomicInteger(0);

    public ModifyTask(ProgressNumDialog progressDialog, List<DevNode> devNodes, boolean devStatus, DeviceOpr opr) {
        this.progressDialog = progressDialog;
        this.devNodes = devNodes;
        this.deviceStatus = devStatus;
        this.opr = opr;
    }

    public ModifyTask(ProgressNumDialog progressDialog, List<DevNode> devNodes, DevNode updateInfo, boolean devStatus, DeviceOpr opr) {
        this(progressDialog, devNodes, devStatus, opr);
        this.newUser = updateInfo.getLoginUser();
        this.fusionCubeLoginUser = updateInfo.getFusionCubeLoginUser();
        this.info = updateInfo.getPriKey();
        this.setDevPwd(updateInfo.getDeveloperPwd());
        this.deviceStatus = devStatus;
        for (DevNode devNode : devNodes) {
            devNode.setRootUser(updateInfo.getRootUser());
        }
    }

    public String getDevPwd() {
        if (null == this.devPwd) {
            return null;
        }
        return AESEncrypt.decrypt((String)this.devPwd);
    }

    public void setDevPwd(String devPwd) {
        this.devPwd = AESEncrypt.encrypt((String)devPwd);
    }

    public void setDeviceModifyObserver(IDeviceOperaObserver observer) {
        this.deviceModifyObserver = observer;
    }

    protected TaskResult doTask() {
        TaskResult ret = null;
        int count = 0;
        for (DevNode devNode : this.devNodes) {
            DevNode queryDev = this.constructQueryDev(devNode);
            ret = this.deviceManageService.modifyDevice(queryDev, this.opr);
            this.refreshDev2Tool(queryDev);
            count = this.refleshProgress(count);
            this.modifySceneFileDevInfo(ret, devNode);
            this.deviceModifyObserver.observe(ret, devNode.getIp());
            if (this.deviceStatus) {
                if (ret.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
                    LogUtils.addOperaLog("operalog.name.upddevice", devNode, ret, "");
                    continue;
                }
                LogUtils.addOperaLog("operalog.name.upddevice", devNode, ret, ret.getErrorId());
                continue;
            }
            if (ret.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
                LogUtils.addOperaLog("operalog.name.moddevice", devNode, ret, "");
                continue;
            }
            LogUtils.addOperaLog("operalog.name.moddevice", devNode, ret, ret.getErrorId());
        }
        return ret;
    }

    private void refreshDev2Tool(DevNode devNode) {
        LOGGER.info("write device xml for refresh toolbox.");
        String fileName = UserDataType.deviceNode.getFileName() + this.deviceIndex.getAndIncrement();
        String refreshDataPath = ApplicationContext.getInstance().getToolRefreshPath();
        File devFile = new File(refreshDataPath, fileName);
        LOGGER.info("write device xml for refresh refreshDataPath:{}.", (Object)refreshDataPath);
        ArrayList<com.huawei.ism.tool.framework.pubservice.entity.DevNode> nodes = new ArrayList<com.huawei.ism.tool.framework.pubservice.entity.DevNode>();
        nodes.add(EntityUtils.toNewDev((DevNode)devNode));
        try {
            List listMap = SceneDeviceData.injectDeviceDataBySubTool(nodes);
            SceneXmlData.getInstance().writeDevData2File(nodes, listMap, devFile);
            LOGGER.info("write device file success.");
        }
        catch (Exception e) {
            LOGGER.error("write device file error.");
        }
    }

    private void modifySceneFileDevInfo(TaskResult ret, DevNode devNode) {
        if (TaskResult.Result.SUCCESS.equals((Object)ret.getResult())) {
            try {
                XmlFormer xmlFormer = new XmlFormer();
                List list = SceneXmlData.getInstance().getDeviceToModify(EntityUtils.toNewDev((DevNode)devNode));
                List<Map<String, String>> listMap = xmlFormer.injectDeviceData(list);
                SceneXmlData.getInstance().doModify(list, listMap);
            }
            catch (Exception e) {
                LOGGER.error("update device info to scene file error!", (Throwable)e);
            }
        }
    }

    private DevNode constructQueryDev(DevNode devNode) {
        String debPwdTmp;
        DevNode queryDev = new DevNode();
        if (devNode.isComputeStorage()) {
            queryDev = EntityUtils.cloneDevNode((DevNode)devNode);
        }
        if (devNode.isFusionCube()) {
            queryDev = EntityUtils.cloneDevNode((DevNode)devNode);
        }
        if (this.newUser != null) {
            queryDev.setLoginUser(this.newUser);
            queryDev.setPort(this.newUser.getPort());
        } else {
            User user = new User(devNode.getLoginUser());
            queryDev.setLoginUser(user);
            queryDev.setPort(devNode.getPort());
        }
        if (this.fusionCubeLoginUser != null) {
            queryDev.setFusionCubeLoginUser(this.fusionCubeLoginUser);
        }
        this.copyOldToNewNode(queryDev, devNode);
        queryDev.setRootUser(devNode.getRootUser());
        if (!devNode.isNotSocks5Proxy()) {
            queryDev.setSocks5Proxy(devNode.getSocks5Proxy());
        }
        if (!devNode.isNotSshForward()) {
            queryDev.setSshForwardList(devNode.getSshForwardList());
        }
        if ((debPwdTmp = this.getDevPwd()) != null) {
            queryDev.setDeveloperPwd(debPwdTmp);
        } else {
            String debugPwdTmp2 = devNode.getDeveloperPwd();
            queryDev.setDeveloperPwd(debugPwdTmp2);
        }
        queryDev.setIp(devNode.getIp());
        if (null != this.info) {
            queryDev.setPriKey(this.info);
        } else {
            queryDev.setPriKey(devNode.getPriKey());
        }
        return queryDev;
    }

    private void copyOldToNewNode(DevNode newDevNode, DevNode oldNode) {
        if (oldNode.getItDeviceType() != null) {
            newDevNode.setItDeviceType(oldNode.getItDeviceType());
        }
        if (oldNode.getDevTypeLevel2() != null) {
            newDevNode.setDevTypeLevel2(oldNode.getDevTypeLevel2());
        }
    }

    private int refleshProgress(int count) {
        this.progressDialog.updateProgress((count + 1) * 100 / this.devNodes.size());
        return count + 1;
    }

    public boolean isDeviceStatus() {
        return this.deviceStatus;
    }

    public void setDeviceStatus(boolean deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public String toString() {
        return "ModifyTask";
    }
}

