/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.task;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnFactory;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import java.text.Normalizer;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class PsdValidator {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PsdValidator.class);
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String DEVELOPER = "developer:/>";
    private static final String CHANGETODEVELOPER = "change user_mode current_mode user_mode=developer";
    private static final String OPENTLV = "change system external_TLV_channel enabled=";
    private static final String YORN = "(y/n)";
    private static final String YSTR = "y";
    private static final String SUCC = "successfully.";
    private static final String EXIT = "exit";
    private static final String SHOWTLV = "show system external_TLV_channel";
    private static final int TIME_OUT = 50;
    private DevNode devNode;
    private CountDownLatch cdSucLatch = new CountDownLatch(1);

    public DevNode getDevNode() {
        return this.devNode;
    }

    public PsdValidator(DevNode devNode) {
        this.devNode = devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public TaskResult validate() {
        TaskResult tr = new TaskResult(TaskResult.Result.FAILED);
        TlvVlidator tv = new TlvVlidator();
        RestVlidator rv = new RestVlidator();
        try {
            AsyncExcutor.submit((Callable[])new Callable[]{tv, rv});
            if (this.cdSucLatch.await(50L, TimeUnit.SECONDS)) {
                return new TaskResult(TaskResult.Result.SUCCESS);
            }
        }
        catch (Exception e) {
            LOGGER.error("check pwd error", (Throwable)e);
        }
        tr.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceautherror");
        return tr;
    }

    private class TlvVlidator
    implements Callable<TaskResult> {
        private TlvVlidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskResult call() throws Exception {
            ICliConnection con = null;
            boolean needInitTlv = false;
            try {
                con = SshConnectionManager.getSshConnection((DevNode)PsdValidator.this.devNode, null, (boolean)true, (boolean)true);
                needInitTlv = this.isTlvChannelOpen(con);
                this.closeOrOpenTlvChannel(con, true, needInitTlv);
                this.createTlvConnection(PsdValidator.this.devNode);
                PsdValidator.this.cdSucLatch.countDown();
                this.closeOrOpenTlvChannel(con, false, needInitTlv);
            }
            catch (Exception e) {
                try {
                    LOGGER.error("Connect devError", (Throwable)e);
                    this.closeOrOpenTlvChannel(con, false, needInitTlv);
                }
                catch (Throwable throwable) {
                    this.closeOrOpenTlvChannel(con, false, needInitTlv);
                    SshConnectionManager.releaseConnection((ICliConnection)con);
                    throw throwable;
                }
                SshConnectionManager.releaseConnection((ICliConnection)con);
            }
            SshConnectionManager.releaseConnection((ICliConnection)con);
            return new TaskResult(TaskResult.Result.SUCCESS);
        }

        private boolean isTlvChannelOpen(ICliConnection con) {
            boolean isNeedInitTlv = true;
            try {
                String userTypeCli = con.execCmdWithTimout(PsdValidator.CHANGETODEVELOPER, 50);
                userTypeCli = Normalizer.normalize(userTypeCli, Normalizer.Form.NFKC);
                if (userTypeCli.contains(PsdValidator.DEVELOPER)) {
                    String isTlvOpen = con.execCmdWithTimout(PsdValidator.SHOWTLV, 50);
                    if ((isTlvOpen = Normalizer.normalize(isTlvOpen, Normalizer.Form.NFKC)).contains(PsdValidator.YES)) {
                        LOGGER.info("tlv is open yet...");
                        isNeedInitTlv = false;
                    }
                    con.execCmdWithTimout(PsdValidator.EXIT, 50);
                } else {
                    LOGGER.info("change user mode to developer failed...");
                    isNeedInitTlv = false;
                }
            }
            catch (ToolException e) {
                LOGGER.error("show tlv connection error...");
                isNeedInitTlv = false;
            }
            return isNeedInitTlv;
        }

        private void closeOrOpenTlvChannel(ICliConnection con, boolean enable, boolean needInitTlv) {
            if (!needInitTlv) {
                return;
            }
            String enableStr = enable ? PsdValidator.YES : PsdValidator.NO;
            try {
                String userTypeCli = con.execCmdWithTimout(PsdValidator.CHANGETODEVELOPER, 50);
                userTypeCli = Normalizer.normalize(userTypeCli, Normalizer.Form.NFKC);
                if (userTypeCli.contains(PsdValidator.DEVELOPER)) {
                    this.openTlvConnection(con, enableStr);
                    con.execCmdWithTimout(PsdValidator.EXIT, 50);
                } else {
                    LOGGER.info("change user mode to developer failed...");
                }
            }
            catch (Exception e) {
                LOGGER.error("change tlv enabled = " + enableStr + "error...");
            }
        }

        private void openTlvConnection(ICliConnection con, String enableStr) throws Exception {
            String openTlvCli = con.execCmdWithTimout(PsdValidator.OPENTLV + enableStr, 50);
            if ((openTlvCli = Normalizer.normalize(openTlvCli, Normalizer.Form.NFKC)).trim().endsWith(PsdValidator.YORN)) {
                openTlvCli = con.execCmdWithTimout(PsdValidator.YSTR, 50);
                if ((openTlvCli = Normalizer.normalize(openTlvCli, Normalizer.Form.NFKC)).trim().endsWith(PsdValidator.YORN)) {
                    openTlvCli = con.execCmdWithTimout(PsdValidator.YSTR, 50);
                    if ((openTlvCli = Normalizer.normalize(openTlvCli, Normalizer.Form.NFKC)).trim().contains(PsdValidator.SUCC) && LOGGER.isInfoEnabled()) {
                        LOGGER.info("change tlv enabled = " + enableStr + "success...");
                    }
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("change tlv enabled = " + enableStr + "failed...");
            }
        }

        private void createTlvConnection(DevNode deNode) throws ToolException {
            ITLVConnection tlvcon = null;
            try {
                tlvcon = TlvConnectionManager.getConnection(deNode);
            }
            catch (ToolException e) {
                throw new ToolException(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceautherror", (Object[])new Object[]{deNode.getIp()}), "bulid tlvconnection failed.", (Throwable)e);
            }
            finally {
                TlvConnectionManager.releaseConnection(tlvcon);
            }
        }
    }

    private class RestVlidator
    implements Callable<TaskResult> {
        private RestVlidator() {
        }

        @Override
        public TaskResult call() throws Exception {
            TaskResult tr = new TaskResult(TaskResult.Result.FAILED);
            try {
                RestConnection conn = RestConnFactory.getRestConn(PsdValidator.this.devNode);
                if (null == conn) {
                    LOGGER.info("build rest conn failed");
                    throw new NullPointerException();
                }
                conn.login();
                if (conn.isLogin()) {
                    PsdValidator.this.cdSucLatch.countDown();
                    tr.setResult(TaskResult.Result.SUCCESS);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("rest login success" + PsdValidator.this.devNode.getIp());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("build rest conn error", (Throwable)e);
            }
            return tr;
        }
    }
}

