/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceToolAction;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAiDeviceAction
extends DeviceToolAction {
    private static final Logger log = LoggerFactory.getLogger(DeleteAiDeviceAction.class);
    private final Window parent;

    @Override
    protected void abstractActionPerformed(ActionEvent event) {
        log.info("click delete ai device");
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.layout.device.delete.confirm"));
        if (0 == warningDialog.getValue()) {
            this.doDelete();
        }
    }

    private void doDelete() {
        Object userObject = this.getUserObject();
        if (userObject instanceof List) {
            DeleteAiDeviceAction.removeNodes((List)userObject);
        }
    }

    private static void removeNodes(List<?> userObject) {
        List nodes = userObject.stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).collect(Collectors.toList());
        for (AiDevNode node : nodes) {
            try {
                DefaultNodeProviderImpl.getInstance().removeNode((DevNode)node);
                LogUtils.addOperaLog("operalog.name.remdevice", (DevNode)node);
            }
            catch (ToolException e) {
                log.warn("remove node :{} failed", (Object)node.getIp(), (Object)e);
            }
        }
    }

    public boolean isAvailable() {
        return Objects.nonNull(this.getUserObject());
    }

    public DeleteAiDeviceAction(Window parent) {
        this.parent = parent;
    }
}

