/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DeviceListImpotOperator {
    private static DocumentBuilder documentBuilder = null;
    private Document document = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceListImpotOperator(File deviceListFile) throws SAXException, IOException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(deviceListFile);
            this.document = documentBuilder.parse(input);
            this.document.normalize();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("DeviceList.xml file parse error", (Throwable)e);
        }
        catch (SAXException se) {
            ToolLoggerFactory.getLogger(this.getClass()).error("DeviceList.xml file parse error", (Throwable)se);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DeviceListImpotOperator.class).error("documentBuilder build faild", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)input);
        }
    }

    public DeviceListImpotOperator(Document document) {
        this.document = document;
    }

    public static Collection<DevNode> getDeviceList(String filePath) throws SAXException, IOException {
        DeviceListImpotOperator impoter = new DeviceListImpotOperator(new File(filePath));
        return impoter.parserAll();
    }

    public static Collection<DevNode> getDeviceList(File file) throws SAXException, IOException {
        DeviceListImpotOperator impoter = new DeviceListImpotOperator(file);
        return impoter.parserAll();
    }

    public DevNode node2Device(Element node) {
        DevNode device = new DevNode();
        String deviceName = XmlUtils.getTextContentOfChild((Element)node, (String)"deviceName");
        String deviceType = XmlUtils.getTextContentOfChild((Element)node, (String)"deviceType");
        String productVersion = XmlUtils.getTextContentOfChild((Element)node, (String)"productVersion");
        String ipAddress = XmlUtils.getTextContentOfChild((Element)node, (String)"ipAddress");
        String serialNumber = XmlUtils.getTextContentOfChild((Element)node, (String)"serialNumber");
        String username = XmlUtils.getTextContentOfChild((Element)node, (String)"username");
        String password = XmlUtils.getTextContentOfChild((Element)node, (String)"password");
        String port = XmlUtils.getTextContentOfChild((Element)node, (String)"port");
        String devPwd = XmlUtils.getTextContentOfChild((Element)node, (String)"developer");
        if (StringUtils.isNULLStr((String)devPwd)) {
            device.setDeveloperPwd("");
        } else {
            device.setDeveloperPwd(this.getPlaintPass(devPwd));
        }
        String plaintPassword = this.getPlaintPass(password);
        Element sockt = XmlUtils.getChild((Element)node, (String)"socks5Proxy");
        Element sshs = XmlUtils.getChild((Element)node, (String)"sshForwardList");
        User user = new User(username, plaintPassword);
        device.setProductVersion(productVersion);
        device.setDeviceName(deviceName);
        device.setDeviceType(DeviceType.valueOf((String)deviceType));
        device.setDeviceSerialNumber(serialNumber);
        device.setIp(ipAddress);
        device.setLoginUser(user);
        if (null != sockt && sockt.hasChildNodes()) {
            Socks5Proxy socks5Proxy = this.getSocks5Proxy(sockt);
            device.setSocks5Proxy(socks5Proxy);
        }
        if (null != sshs && sshs.hasChildNodes()) {
            List<MultiRouteNode> sshForwardList = this.getSshList(sshs);
            device.setSshForwardList(sshForwardList);
            String sshName = XmlUtils.getTextContentOfChild((Element)sshs, (String)"sshname");
            device.setSshName(sshName);
        }
        if (null != port) {
            device.setPort(StringUtils.str2Int((String)port));
        }
        return device;
    }

    private String getPlaintPass(String pass) {
        String plaintPassW = "";
        try {
            plaintPassW = AESEncrypt.decrypt((String)pass);
            return plaintPassW;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            return plaintPassW;
        }
    }

    private Socks5Proxy getSocks5Proxy(Element node) {
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        String socks5Name = XmlUtils.getTextContentOfChild((Element)node, (String)"socks5name");
        String socks5User = XmlUtils.getTextContentOfChild((Element)node, (String)"socks5user");
        String socks5ServiceIP = XmlUtils.getTextContentOfChild((Element)node, (String)"socks5serviceip");
        String socks5Port = XmlUtils.getTextContentOfChild((Element)node, (String)"socks5port");
        String pass = XmlUtils.getTextContentOfChild((Element)node, (String)"socks5pass");
        String password = this.getPlaintPass(pass);
        socks5Proxy.setName(socks5Name);
        socks5Proxy.setUser(socks5User);
        socks5Proxy.setServerIp(socks5ServiceIP);
        socks5Proxy.setPass(password);
        socks5Proxy.setPort(socks5Port);
        if (!StringUtils.isNULLStr((String)socks5User) && !StringUtils.isNULLStr((String)password)) {
            socks5Proxy.setAuthentic(true);
        }
        return socks5Proxy;
    }

    private List<MultiRouteNode> getSshList(Element node) {
        ArrayList<MultiRouteNode> sshForwardList = new ArrayList<MultiRouteNode>();
        Collection sshList = XmlUtils.getChildren((Element)node, (String)"sshForward");
        for (Element sshElement : sshList) {
            String sshUser = XmlUtils.getTextContentOfChild((Element)sshElement, (String)"sshuser");
            String sshPass = XmlUtils.getTextContentOfChild((Element)sshElement, (String)"sshpass");
            String sshHost = XmlUtils.getTextContentOfChild((Element)sshElement, (String)"sshhost");
            String sshProt = XmlUtils.getTextContentOfChild((Element)sshElement, (String)"sshport");
            String passString = this.getPlaintPass(sshPass);
            MultiRouteNode sshForword = new MultiRouteNode(sshHost, Integer.parseInt(sshProt), sshUser, passString);
            sshForwardList.add(sshForword);
        }
        return sshForwardList;
    }

    private Collection<DevNode> parserAll() {
        if (this.document == null) {
            return new ArrayList<DevNode>();
        }
        Element root = this.document.getDocumentElement();
        NodeList allNode = root.getElementsByTagName("device");
        int len = allNode.getLength();
        ArrayList<DevNode> deviceList = new ArrayList<DevNode>(len);
        for (int i = 0; i < len; ++i) {
            Element element = (Element)allNode.item(i);
            DevNode device = this.node2Device(element);
            deviceList.add(device);
        }
        return deviceList;
    }

    static {
        try {
            documentBuilder = XmlUtils.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LoggerFactory.getLogger(DeviceListImpotOperator.class).error("documentBuilder build faild", (Throwable)e);
        }
    }
}

