/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceManageService;
import com.huawei.ism.tool.devicemanager.service.IDeviceManageService;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.pub.DevInfoXlsParser;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceListImpotOperator;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceToolAction;
import com.huawei.ism.tool.devicemanager.ui.action.ImportFileType;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.devicemanager.ui.mainframe.DeviceManagementPanel;
import com.huawei.ism.tool.devicemanager.utils.CertCheckCfmUtils;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.devicemanager.utils.HostKeyCheckUtils;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.devicemanager.utils.ProductParser;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.ui.dialogs.DisclaimerDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.SecurityConfigUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.NetUtil;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.xml.sax.SAXException;
import utils.Products;

public class ImportDeviceAction
extends DeviceToolAction {
    private static final long serialVersionUID = -7822596635558259665L;
    private static final int IMPORT_SUCCESS = 0;
    private static final int IMPORT_FAILED = -1;
    private static final int IMPORT_OTHER = 8;
    private static final long IMPORT_FILE_SIZE = 0xA00000L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ImportDeviceAction.class);
    private static final int IMPORT_NO_RECORD = 9;
    private static final int IMPORT_EXCEED_MAX = 10;
    private static final int IMPORT_EXCEL_TOO_OLD = -11;
    private static final String DEV_LIST_FILEID = "device_manage_export_devcelist_001";
    private static int importXmlError = 2;
    private DeviceManagementPanel panel = null;
    private Map<String, String> deviceImportResult = null;
    private ConcurrentHashMap<DevNode, String> hostKeyCheckMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, String> debugPasswdunfilledMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, String> certFailMap = new ConcurrentHashMap();
    private IDeviceManageService deviceManageService = new DeviceManageService();
    private JDialog parentDialog;
    private List<String> isTaskDevicesIp = new ArrayList<String>();
    private Collection<DevNode> deviceList;
    private int importDevInfoSupportCounter = 0;
    private Set<String> securityAlgorithmFailDev = new HashSet<String>();

    public ImportDeviceAction(DeviceManagementPanel panel) {
        this.panel = panel;
    }

    public ImportDeviceAction(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    @Override
    public void abstractActionPerformed(ActionEvent event) {
        this.deviceImportResult = new HashMap<String, String>();
        int ret = this.doImport();
        ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("import devNode ret:" + ret);
        if (10 == ret) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"infograb.task.device_sum_limit_info"));
            return;
        }
        if (-11 == ret) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"device.add.import.excel.check.cert.tip"));
            return;
        }
        if (8 == ret) {
            this.isTaskDevicesIp.clear();
            return;
        }
        if (9 == ret) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"device.import.success.nodevice"));
        } else if (-1 == ret) {
            if (1 == DeviceContext.getInstance().getErrorStatus()) {
                DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"toolbox.proy.name.errormsg"));
                return;
            }
            if (1 == importXmlError) {
                DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"toolbox.xml.proy.errormsg"));
            } else if (this.deviceImportResult.isEmpty() && (null == this.deviceList || this.deviceList.isEmpty())) {
                DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"devicemanager.layout.device.import.failed"));
            } else {
                DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"toolbox.proy.errormsg"));
            }
        } else if (0 != ret) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"toolbox.proy.errormsg"));
        }
        this.updateBtns();
    }

    private Window getParentWindow() {
        return null != this.panel ? this.panel.getParentJFrame() : this.parentDialog;
    }

    private void updateBtns() {
        if (null != this.panel) {
            this.panel.updateButtons();
        }
    }

    public int doImport() {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("description", "*.xls;*.xlsx");
        extParams.put("PathId", DEV_LIST_FILEID);
        String title = ResourceUtil.getString((String)"devicemanager.layout.device.import.title");
        extParams.put("title", title);
        File importFile = ToolFileChooser.selectFile((Window)(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog), (String[])new String[]{"xls", "xlsx"}, (int)2, (boolean)true, extParams);
        if (importFile == null) {
            return 8;
        }
        if (!this.isNewExcel(importFile)) {
            return -11;
        }
        try {
            if (!FileUtils.isDiskFull((String)importFile.getCanonicalPath(), (long)0xA00000L)) {
                return 8;
            }
        }
        catch (IOException e) {
            LOGGER.error("get path fail!", (Throwable)e);
        }
        try {
            this.deviceList = this.parseDeviceFile(importFile, this.deviceImportResult);
            List<DevNode> deviceAdded = DefaultNodeProviderImpl.getInstance().getNodeList();
            if (deviceAdded.size() + this.importDevInfoSupportCounter > 256) {
                return 10;
            }
        }
        catch (Exception e) {
            LOGGER.error("import precheck error", (Throwable)e);
            return -1;
        }
        if (this.deviceList == null) {
            return -1;
        }
        if (this.deviceList.isEmpty() && this.deviceImportResult.isEmpty()) {
            return 9;
        }
        Object progressDialog = null;
        Object importDeviceTask = null;
        Object execFuture = null;
        this.doImportTask(importFile);
        this.panelDeal();
        this.clearData();
        this.securityAlgorithmFailDev.clear();
        this.deviceList = null;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isNewExcel(File xlsFile) {
        try (FileInputStream fis = new FileInputStream(FilePathUtils.checkFile((File)xlsFile));
             Workbook workbook = WorkbookFactory.create((InputStream)fis);){
            Sheet devInfoSheet = workbook.getSheetAt(0);
            Row row = devInfoSheet.getRow(1);
            String isVerifyCertTitle = POIUtils.getStringCellValue((Cell)row.getCell(6));
            String isVerifyCertEn = ResourceUtil.getString((String)"devicemanager.layout.device.add.is.verify.cert.title", (Locale)Locale.ENGLISH);
            String isVerifyCertZh = ResourceUtil.getString((String)"devicemanager.layout.device.add.is.verify.cert.title", (Locale)Locale.CHINESE);
            if (!isVerifyCertZh.trim().equalsIgnoreCase(isVerifyCertTitle.trim())) {
                if (!isVerifyCertEn.trim().equalsIgnoreCase(isVerifyCertTitle.trim())) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found.");
            return false;
        }
        catch (IOException e) {
            LOGGER.error("parse file error.");
        }
        return false;
    }

    private void clearData() {
        this.deviceImportResult.clear();
        this.certFailMap.clear();
        this.hostKeyCheckMap.clear();
        this.debugPasswdunfilledMap.clear();
    }

    private void panelDeal() {
        this.showImportInfoDialog(this.deviceImportResult);
        if (this.showBatchCertFailedNode()) {
            this.showBatchFingerPrintNode();
        }
        if (!this.debugPasswdunfilledMap.isEmpty()) {
            this.showDebugPassWdUnfilledDialog();
        }
        if (!this.securityAlgorithmFailDev.isEmpty() && SecurityConfigUtil.isOnlySecurityAlgorithm()) {
            this.showDisclaimerDialog();
        }
    }

    private void doImportTask(File importFile) {
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog, null, 380);
        ImportDeviceTask importDeviceTask = new ImportDeviceTask((ProgressDialog)progressDialog, importFile);
        Future execFuture = AsyncExcutor.submit((Callable)importDeviceTask);
        this.waitTillImportDone((ProgressDialog)progressDialog, execFuture);
    }

    private void showDisclaimerDialog() {
        DisclaimerDialog dialog = new DisclaimerDialog(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog, DisclaimerDialog.DisclaimerScene.DEVICE_ADD);
        dialog.setVisible(true);
        if (dialog.isAccepted()) {
            this.clearData();
            SecurityConfigUtil.modifySecurityAlgorithmConfig((boolean)true);
            DevNode node = new DevNode();
            node.setIp(this.securityAlgorithmFailDev.iterator().next());
            LogUtils.addOperaLog("systemconfig.security.config.algorithm.selected", node, "");
            this.deviceList = this.deviceList.stream().filter(devNode -> this.securityAlgorithmFailDev.contains(devNode.getIp())).collect(Collectors.toList());
            this.doImportTask(null);
            this.panelDeal();
        }
    }

    private void showDebugPassWdUnfilledDialog() {
        if (!this.debugPasswdunfilledMap.isEmpty()) {
            SubDialogUtils.showMultiInfoDialog(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog, this.changeMap2UIArray(this.debugPasswdunfilledMap), true, ResourceUtil.getString((String)"devicemanager.layout.device.batch.need.debug.passwd"));
        }
    }

    private void waitTillImportDone(ProgressDialog progressDialog, Future<Boolean> execFuture) {
        try {
            progressDialog.setVisible(true);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("exec result :" + execFuture.get());
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("exec error!", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("exec error!", (Throwable)e);
        }
    }

    private Collection<DevNode> parseDeviceFile(File importFile, Map<String, String> deviceImpResult) {
        this.importDevInfoSupportCounter = 0;
        String suffix = this.getFileSuffix(importFile);
        Collection<DevNode> devList = null;
        if (suffix.equals(ImportFileType.XML.getValue())) {
            try {
                devList = DeviceListImpotOperator.getDeviceList(importFile);
                this.importDevInfoSupportCounter = devList.size();
            }
            catch (SAXException e) {
                LOGGER.error("DeviceList.xml file parse error", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        } else if (suffix.equals(ImportFileType.XLS.getValue()) || suffix.equals(ImportFileType.XLSX.getValue())) {
            HashMap<DevNode, String> result = new HashMap<DevNode, String>();
            HashMap<ItDeviceType, List<String>> supportedTyeMap = new HashMap<ItDeviceType, List<String>>();
            supportedTyeMap.put(ItDeviceType.Storage, null);
            supportedTyeMap.put(ItDeviceType.COMPUTE_STORAGE, null);
            supportedTyeMap.put(ItDeviceType.FUSIONCUBE, null);
            DevInfoXlsParser xlsParser = new DevInfoXlsParser(result, supportedTyeMap);
            try {
                devList = xlsParser.parseFile(importFile);
                this.importDevInfoSupportCounter = xlsParser.getSupportDeviceInfoCounter();
            }
            catch (ToolException e) {
                LOGGER.error("parse file error.", (Throwable)e);
            }
            for (Map.Entry entry : result.entrySet()) {
                deviceImpResult.put(((DevNode)entry.getKey()).getUid(), (String)entry.getValue());
            }
        }
        return devList;
    }

    private String getFileSuffix(File importFile) {
        String fileName = importFile.getName();
        String fileSuffix = fileName.substring(fileName.lastIndexOf(46) + 1);
        return fileSuffix;
    }

    protected void showImportInfoDialog(Map<String, String> deviceMap) {
        ArrayList failRet = new ArrayList();
        for (Map.Entry<String, String> entry : deviceMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(entry.getKey());
            tmp.add(entry.getValue());
            failRet.add(tmp);
        }
        SubDialogUtils.showMultiInfoDialog(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog, ResourceUtil.getString((String)"devicemanager.layout.device.import.deviceadddialog.batcherror"), new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.ip"), ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.reason")}, failRet);
    }

    protected boolean showBatchCertFailedNode() {
        ArrayList failCertDev = (ArrayList)this.changeMap2UIArray(this.certFailMap);
        String userAlertinfo = ResourceUtil.getString((String)"certifcate.check.batch.invalid");
        if (!failCertDev.isEmpty()) {
            boolean isOKSelected = SubDialogUtils.showMultiInfoDialog(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog, failCertDev, true, userAlertinfo);
            if (!isOKSelected) {
                for (DevNode currNode : this.certFailMap.keySet()) {
                    this.checkDeldevNodes(currNode);
                }
                return false;
            }
            this.addTrustToLocal();
        }
        return true;
    }

    private void addTrustToLocal() {
        for (Map.Entry<DevNode, String> devNodeStringEntry : this.certFailMap.entrySet()) {
            DevNode node = devNodeStringEntry.getKey();
            CertCheckCfmUtils.setCertConfirmProp(node.getDeviceSerialNumber(), String.valueOf(true));
            node.setVerifyCertificate(false);
        }
    }

    private void checkAdddevNodes(DevNode currNode) {
        if (!DefaultNodeProviderImpl.getInstance().getNodeList().contains(currNode)) {
            this.deviceManageService.addDevNodeToDM(currNode);
        }
    }

    private void checkDeldevNodes(DevNode currNode) {
        if (DefaultNodeProviderImpl.getInstance().getNodeList().contains(currNode)) {
            try {
                DefaultNodeProviderImpl.getInstance().removeNode(currNode);
            }
            catch (Exception exp) {
                LOGGER.error("Exception happened in :", (Throwable)exp);
            }
        }
    }

    private void showBatchFingerPrintNode() {
        if (!this.hostKeyCheckMap.isEmpty()) {
            ArrayList failFPDev = (ArrayList)this.changeMap2UIArray(this.hostKeyCheckMap);
            String userAlertinfo = ResourceUtil.getString((String)"ssh.adddevice.batch.alert");
            boolean isOKSelected = SubDialogUtils.showMultiInfoDialog(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog, failFPDev, true, userAlertinfo);
            for (DevNode currNode : this.hostKeyCheckMap.keySet()) {
                if (isOKSelected) {
                    this.checkAdddevNodes(currNode);
                    continue;
                }
                this.checkDeldevNodes(currNode);
            }
            if (isOKSelected) {
                Map<String, String> currHostkeyMap = this.convert2PropMap(this.hostKeyCheckMap);
                HostKeyCheckUtils.setFingerPrintProps(currHostkeyMap);
            }
        } else {
            for (DevNode currNode : this.certFailMap.keySet()) {
                this.deviceManageService.deleteDevice(currNode);
                this.deviceManageService.addDevNodeToDM(currNode);
            }
        }
    }

    private Map<String, String> convert2PropMap(ConcurrentHashMap<DevNode, String> hostKeyCheckHashMap) {
        HashMap<String, String> currResultMap = new HashMap<String, String>();
        for (Map.Entry<DevNode, String> i : hostKeyCheckHashMap.entrySet()) {
            String currFPAllDesc = i.getValue();
            int startIndex = currFPAllDesc.indexOf(":") + 1;
            int endIndex = currFPAllDesc.indexOf(",");
            endIndex = endIndex > 0 ? endIndex : currFPAllDesc.indexOf(".");
            String currFingerPrint = currFPAllDesc.substring(startIndex, endIndex);
            currResultMap.put(i.getKey().getUid(), currFingerPrint);
        }
        return currResultMap;
    }

    private List<ArrayList<Object>> changeMap2UIArray(ConcurrentHashMap<DevNode, String> currMap) {
        ArrayList<ArrayList<Object>> failCertDev = new ArrayList<ArrayList<Object>>();
        for (Map.Entry<DevNode, String> i : currMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(i.getKey().getUid());
            tmp.add(i.getValue());
            failCertDev.add(tmp);
        }
        return failCertDev;
    }

    private boolean shouldCheckHostKey(TaskResult importResult) {
        return null != importResult && !StringUtils.isNULLStr((String)importResult.getFingerPrint()) && com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isVerifySshHostKeyForStorage();
    }

    private TaskResult checkDeviceIsInvalid(DevNode devNode) {
        boolean deviceIllegal;
        TaskResult devNodeTaks = new TaskResult();
        devNodeTaks.setErrorId(devNode.getUid());
        String pwd = devNode.getLoginUser().getPassword();
        boolean passwdIllegal = StringUtils.isNULLStr((String)pwd);
        boolean usernameIllegal = StringUtils.isNULLStr((String)devNode.getLoginUser().getUserName());
        boolean portIllegal = devNode.getPort() < 0;
        boolean bl = deviceIllegal = passwdIllegal || usernameIllegal || portIllegal;
        if (deviceIllegal) {
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.errorMess"));
            devNodeTaks.setErrorId("import.devNode.errorMess");
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        Socks5Proxy socks = devNode.getSocks5Proxy();
        boolean socksIllegal = this.checkSocks5Valid(socks);
        if (socksIllegal) {
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.socks5.errorMess"));
            devNodeTaks.setErrorId("import.devNode.socks5.errorMess");
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        List ssh = devNode.getSshForwardList();
        boolean sshOK = this.checkSshValid(devNode, ssh);
        if (sshOK) {
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.ssh.errorMess"));
            devNodeTaks.setErrorId("import.devNode.ssh.errorMess");
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        if (!NetUtil.isValidIP((String)devNode.getIp())) {
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddresserror"));
            devNodeTaks.setErrorId("devicemanager.layout.device.add.deviceadddialog.ipaddresserror");
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        return null;
    }

    private boolean checkSocks5Valid(Socks5Proxy socks) {
        if (null == socks) {
            return false;
        }
        boolean ipIsOk = !NetUtil.isValidIP((String)socks.getServerIp());
        boolean socksName = StringUtils.isNULLStr((String)socks.getName());
        boolean portOK = StringUtils.isNULLStr((String)socks.getPort());
        if (socksName || portOK || ipIsOk) {
            return true;
        }
        if (!socks.isAuthentic()) {
            return false;
        }
        boolean usernameOk = StringUtils.isNULLStr((String)socks.getUser());
        boolean passwdOk = StringUtils.isNULLStr((String)socks.getPass());
        return usernameOk || passwdOk;
    }

    private boolean checkSshValid(DevNode devNode, List<MultiRouteNode> ssh) {
        if (null == ssh) {
            return false;
        }
        boolean sshNameInValid = StringUtils.isNULLStr((String)devNode.getSshName());
        if (sshNameInValid) {
            return true;
        }
        for (MultiRouteNode multiRouteNode : ssh) {
            boolean sshPortOK;
            boolean sshHostOK = !NetUtil.isValidIP((String)multiRouteNode.getHost());
            boolean sshPwdOK = StringUtils.isNULLStr((String)multiRouteNode.getPwd());
            boolean sshUserOK = StringUtils.isNULLStr((String)multiRouteNode.getUname());
            boolean bl = sshPortOK = multiRouteNode.getPort() < 0;
            if (!sshHostOK && !sshPwdOK && !sshUserOK && !sshPortOK) continue;
            return true;
        }
        return false;
    }

    private List<Socks5Proxy> addListChilden(List<Socks5Proxy> socks5List, Socks5Proxy socks5) {
        if (socks5List.isEmpty()) {
            socks5List.add(socks5);
            return socks5List;
        }
        int size = socks5List.size();
        for (int i = 0; i < size; ++i) {
            Socks5Proxy socks5Proxy = socks5List.get(i);
            if (!socks5Proxy.getName().equals(socks5.getName())) continue;
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("update socks5 !");
            socks5Proxy.setName(socks5.getName());
            socks5Proxy.setAuthentic(socks5.isAuthentic());
            String pass = socks5.getPass();
            socks5Proxy.setPass(pass);
            socks5Proxy.setPort(socks5.getPort());
            socks5Proxy.setUser(socks5.getUser());
            socks5Proxy.setServerIp(socks5.getServerIp());
            break;
        }
        return socks5List;
    }

    public boolean isAvailable() {
        return true;
    }

    public JDialog getParentDialog() {
        return this.parentDialog;
    }

    private class ImportDeviceTask
    implements Callable<Boolean> {
        private File importFile;
        private ProgressDialog progressDialog;
        private ExecutorService pool;

        private ImportDeviceTask(File importFile) {
            this.importFile = importFile;
        }

        public ImportDeviceTask(ProgressDialog progressDialog, File importFile) {
            this(importFile);
            this.progressDialog = progressDialog;
            this.pool = ThreadPoolHelper.getFixedNumThreadPool((int)ApplicationContext.getInstance().getMaxImportThreadSize(), (String)"batch_dev_add_pool");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            try {
                this.updateMessage("devicemanager.device.import.resloving.dev.info", new Object[0]);
                ArrayList<Socks5Proxy> socks5List = new ArrayList<Socks5Proxy>(SettingService.getProxies());
                KeyOrderedHashMap sshMap = new KeyOrderedHashMap();
                sshMap.putAll(SettingService.getSshForwards());
                KeyOrderedHashMap<String, List<MultiRouteNode>> sshMapCollocate = SettingService.getSshMapCollocate();
                ArrayList<Socks5Proxy> sockLs = new ArrayList<Socks5Proxy>();
                List<CompletableFuture<KeyValue<TaskResult, DevNode>>> results = this.submitQueryTasks();
                this.waitDevInfoQueryFinishedAndHandleResult(socks5List, (KeyOrderedHashMap<String, List<MultiRouteNode>>)sshMap, sshMapCollocate, sockLs, results);
            }
            finally {
                this.pool.shutdown();
                SwingUtil.disPoseDialg((ProgressDialog)this.progressDialog);
            }
            return true;
        }

        @NonNull
        private List<CompletableFuture<KeyValue<TaskResult, DevNode>>> submitQueryTasks() {
            AtomicInteger curDevIndex = new AtomicInteger();
            ArrayList<CompletableFuture<KeyValue<TaskResult, DevNode>>> results = new ArrayList<CompletableFuture<KeyValue<TaskResult, DevNode>>>();
            this.updateMessage("devicemanager.device.import.doimport.dev", this.getEnglishStr(1), ImportDeviceAction.this.deviceList.size());
            for (DevNode devNode : ImportDeviceAction.this.deviceList) {
                devNode.setUid();
                devNode.setOnlySecurityAlgorithm(SecurityConfigUtil.isOnlySecurityAlgorithm());
                if (ImportDeviceAction.this.deviceImportResult.get(devNode.getUid()) != null) {
                    LOGGER.info("Not support devType {} .", (Object)devNode.getUid());
                    continue;
                }
                TaskResult importResult = ImportDeviceAction.this.checkDeviceIsInvalid(devNode);
                if (null != importResult) {
                    ImportDeviceAction.this.deviceImportResult.put(devNode.getUid(), importResult.getErrorLocaleDescription());
                    continue;
                }
                results.add(CompletableFuture.supplyAsync(() -> {
                    SwingUtilities.invokeLater(() -> this.updateMessage("devicemanager.device.import.doimport.dev", this.getEnglishStr(curDevIndex.incrementAndGet()), ImportDeviceAction.this.deviceList.size()));
                    return new KeyValue((Object)ImportDeviceAction.this.deviceManageService.importDevice(devNode), (Object)devNode);
                }, this.pool));
            }
            return results;
        }

        private void waitDevInfoQueryFinishedAndHandleResult(List<Socks5Proxy> socks5List, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMapCollocate, List<Socks5Proxy> sockLs, List<CompletableFuture<KeyValue<TaskResult, DevNode>>> results) {
            results.forEach(future -> {
                try {
                    KeyValue result = (KeyValue)future.get(5L, TimeUnit.MINUTES);
                    TaskResult singleDevResult = (TaskResult)result.getKey();
                    DevNode devNode = (DevNode)result.getValue();
                    singleDevResult = DeviceQueryErrorParser.parseErrorInfo(singleDevResult);
                    if (null != singleDevResult) {
                        ImportDeviceAction.this.deviceImportResult.put(devNode.getUid(), singleDevResult.getErrorLocaleDescription());
                    }
                    this.handleAlgorithmFailInfo(singleDevResult, devNode);
                    this.handleCertFailInfo(singleDevResult, devNode);
                    this.handleFingerPrintInfo(singleDevResult, devNode);
                    this.handleDebugPasswdUnfilled(singleDevResult, devNode);
                    this.handleProxyInfo(socks5List, sshMap, sshMapCollocate, sockLs, singleDevResult, devNode);
                    SettingService.saveProxies(sshMap, sockLs);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    LOGGER.error("Wait execute result error.", (Throwable)e);
                }
            });
        }

        private void handleDebugPasswdUnfilled(TaskResult importResult, DevNode devNode) {
            ProductParser parser = new ProductParser();
            Map<String, String> showInfos = parser.parse();
            if (StringUtils.isNULLStr((String)devNode.getDeveloperPwd()) && null != devNode.getDeviceType() && showInfos.containsKey(devNode.getDeviceType().toString())) {
                String softwareVersions = showInfos.get(devNode.getDeviceType().toString());
                for (String version : softwareVersions.split(",")) {
                    if (!Products.contains((String)devNode.getProductVersion(), (String)version)) continue;
                    ImportDeviceAction.this.debugPasswdunfilledMap.put(devNode, ResourceUtil.getString((String)"devicemanager.layout.device.need.debug.passwd"));
                }
            }
        }

        private String getEnglishStr(int num) {
            if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
                switch (num) {
                    case 1: {
                        return "1st";
                    }
                    case 2: {
                        return "2nd";
                    }
                    case 3: {
                        return "3rd";
                    }
                }
                return num + "th";
            }
            return String.valueOf(num);
        }

        private void updateMessage(String key, Object ... params) {
            if (this.progressDialog != null) {
                this.progressDialog.setCustMizeMsg(ResourceUtil.getStringWithParams((String)key, (Object[])params));
            }
        }

        private void handleCertFailInfo(TaskResult importResult, DevNode devNode) {
            if (null != importResult && importResult.isNeedCertWarn()) {
                ImportDeviceAction.this.certFailMap.put(devNode, ResourceUtil.getStringWithParams((String)"certifcate.check.simply.invalid", (Object[])new Object[0]));
            }
        }

        private void handleAlgorithmFailInfo(TaskResult importResult, DevNode devNode) {
            if (importResult != null && "ssh.connect.security.algorithm.error".equals(importResult.getErrorId())) {
                ImportDeviceAction.this.securityAlgorithmFailDev.add(devNode.getIp());
            }
        }

        private String handleFingerPrintInfo(TaskResult importResult, DevNode devNode) {
            String currFingerPrint = null;
            if (ImportDeviceAction.this.shouldCheckHostKey(importResult)) {
                currFingerPrint = importResult.getFingerPrint();
                Properties fingerProperties = HostKeyCheckUtils.getFingerPrintProp();
                String currIP = devNode.getUid();
                if (!fingerProperties.containsKey(devNode.getUid()) || !fingerProperties.get(currIP).equals(currFingerPrint)) {
                    ImportDeviceAction.this.hostKeyCheckMap.put(devNode, ResourceUtil.getStringWithParams((String)"ssh.adddevice.simply.alert", (Object[])new Object[]{currFingerPrint}));
                }
            }
            return currFingerPrint;
        }

        private void handleProxyInfo(List<Socks5Proxy> socks5List, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMapCollocate, List<Socks5Proxy> sockLs, TaskResult importResult, DevNode devNode) {
            String jumpName = "";
            if (null == importResult) {
                return;
            }
            if (TaskResult.Result.SUCCESS.equals((Object)importResult.getResult())) {
                if (null != devNode.getSocks5Proxy()) {
                    sockLs.addAll(ImportDeviceAction.this.addListChilden(socks5List, devNode.getSocks5Proxy()));
                }
                if (null != devNode.getSshForwardList()) {
                    jumpName = devNode.getSshName();
                    sshMap.put((Object)devNode.getSshName(), sshMapCollocate.get((Object)jumpName));
                }
                LogUtils.addOperaLog("operalog.name.importdevice", devNode, importResult, "");
            } else {
                LogUtils.addOperaLog("operalog.name.importdevice", devNode, importResult, importResult.getErrorId());
            }
        }
    }
}

