/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedMainJDialog;
import com.huawei.ism.tool.devicemanager.ui.former.GetTooolSupportList;
import com.huawei.ism.tool.devicemanager.utils.DevCfgUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.json.JSONObject;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.event.ActionEvent;
import java.text.Normalizer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class SceneAddDeviceAction
extends ToolHyperLinkLabel.ClickAdapter
implements INodeSupport {
    private static final Logger log = LoggerFactory.getLogger(SceneAddDeviceAction.class);
    private static final long serialVersionUID = -7581450057169477018L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SceneAddDeviceAction.class);
    private static final String SCENE_NOT_SUPPORT_DEV_TYPE_OR_VER = "devicemanager.layout.device.add.deviceadddialog.devtype.or.version.scene.notsuport";
    private static final String SVP_SCENE_NOT_SUPPORT_DEV_TYPE_OR_VER = "devicemanager.layout.device.add.deviceadddialog.devtype.or.version.svp.scene.notsuport";
    private static final String PARTS_REPLACEMENT = "Parts Replacement";
    private static final String DISTRIBUTED_FRU = "Distributed FRU";
    private static final String APP_SCENE_LIMIT_SOCKET_SSH = "app.scene.limit.login.socket.ssh";
    private static final String APP_SCENE_LIMIT_SOCKET = "app.scene.limit.login.socket";
    private ScenePreparedMainJDialog parent;
    private String addDevErrMsgPropKey = null;
    private static DeviceManageSetting setting;

    public SceneAddDeviceAction(ScenePreparedMainJDialog parent) {
        this.setParent(parent);
    }

    public void actionPerformed(ActionEvent e) {
        LOGGER.info("you click add device btn.");
        this.addDevice();
    }

    private void addDevice() {
        IDeviceManageUI connUi = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        setting = this.isLimitScenesSSHAndSocket(GetTooolSupportList.getNeededSceneID()) ? new DeviceManageSetting(false, false, false) : (this.isLimitScenesSocket(GetTooolSupportList.getNeededSceneID()) ? new DeviceManageSetting(false, true, false) : new DeviceManageSetting(false, true, true));
        List<String> supportDevTypeList = this.parent.getSupportDevTypeList();
        boolean flag = connUi.showAddDeviceDialog((JDialog)this.parent, supportDevTypeList, (INodeSupport)this, DeviceDialogType.StorageOnly, setting);
        if (!flag) {
            LOGGER.error("show add device dialog err.");
        }
        String curAddIP = DeviceSceneContext.getInstance().getCurrentAddDevIp();
        if (DeviceSceneContext.getInstance().isCurrentNotSupport()) {
            this.handleUnSupportDevices(curAddIP);
            return;
        }
        if (DeviceSceneContext.getInstance().isCurrentHighEndDevNotSupport() && !ArrayUtils.isHighEndDevSupportSvpAdd((String)GetTooolSupportList.getNeededSceneID())) {
            this.handleUnSupportSvp(curAddIP);
            return;
        }
        if (DeviceSceneContext.getInstance().isCurrentDomainUserDevNotSupport() && !ArrayUtils.isSupportDomainUserAdd((String)GetTooolSupportList.getNeededSceneID())) {
            this.handleUnSupportDomainUser(curAddIP);
            return;
        }
        if (this.checkDebugPsw(curAddIP)) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getStringWithParams((String)"scene.remind.debugpsw.add", (Object[])new Object[]{curAddIP}));
        }
        DeviceSceneContext.getInstance().clearCurrentDev();
    }

    private void handleUnSupportDomainUser(String ip) {
        this.changeContext(ip);
        DeviceSceneContext.getInstance().getUnSupportHighEndDevs().remove(ip);
        log.error("device is not supported login with domain user: {}", (Object)ip);
        DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"scene.domain.user.not.support.add.error"));
    }

    private void handleUnSupportSvp(String ip) {
        this.changeContext(ip);
        DeviceSceneContext.getInstance().getUnSupportHighEndDevs().remove(ip);
        log.error("device is not supported out of SVP: {}", (Object)ip);
        DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"scene.outSvp.highEndDev.notsupport.add.error"));
    }

    private void handleUnSupportDevices(String ip) {
        this.changeContext(ip);
        DeviceSceneContext.getInstance().getUnSupportDevs().remove(ip);
        log.error("device is not supported: {}", (Object)ip);
        DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"scene.not.supportdialog"));
    }

    private void changeContext(String ip) {
        DeviceSceneContext.getInstance().clearCurrentDev();
        IDeviceManage deviceManage = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        deviceManage.deleteOneDevice(ip);
    }

    public boolean isLimitScenesSSHAndSocket(String subScene) {
        String limitScenes = ApplicationContext.getInstance().getAppConfig(APP_SCENE_LIMIT_SOCKET_SSH);
        return !StringUtils.isNULLStr((String)limitScenes) && limitScenes.contains(subScene + ',');
    }

    public boolean isLimitScenesSocket(String subScene) {
        String limitScenes = ApplicationContext.getInstance().getAppConfig(APP_SCENE_LIMIT_SOCKET);
        return !StringUtils.isNULLStr((String)limitScenes) && limitScenes.contains(subScene + ',');
    }

    public boolean checkDebugPsw(String ip) {
        DevNode dev = null;
        IDeviceManage deviceManage = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        List devs = deviceManage.getNodeList();
        for (DevNode devNode : devs) {
            if (!devNode.getIp().equals(ip)) continue;
            dev = devNode;
        }
        if (null == dev || !StringUtils.isNULLStr((String)dev.getDeveloperPwd())) {
            return false;
        }
        return DevCfgUtil.isNeedDebusPsw(dev);
    }

    public List<String> getSupportedTypes(List<DeviceType> currList) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (DeviceType currType : currList) {
            resultList.add(currType.toString());
        }
        return resultList;
    }

    public boolean isNodeSupport(DevNode dev) {
        String tips;
        List<String> supportDevTypeList = this.parent.getSupportDevTypeList();
        String devType = dev.getDeviceType().toString();
        String string = tips = LocalHostUtil.isRunInSvp() ? SVP_SCENE_NOT_SUPPORT_DEV_TYPE_OR_VER : SCENE_NOT_SUPPORT_DEV_TYPE_OR_VER;
        if (!supportDevTypeList.contains(devType)) {
            this.setAddDevErrMsgPropKey(tips);
            return false;
        }
        Map<String, String> devTypeVersMap = this.parent.getSupportDevTypeAndVersMap();
        String[] devVers = devTypeVersMap.get(devType).split(",");
        String curDevSpcVer = dev.getProductVersion();
        curDevSpcVer = Normalizer.normalize(curDevSpcVer, Normalizer.Form.NFKC);
        if (dev.isFusionCube() && this.isDistributeFru()) {
            return this.isFusionCubeSupport(curDevSpcVer, devVers, tips, dev.getScenarioInfo());
        }
        for (String devVer : devVers) {
            if (!Products.contains((String)curDevSpcVer, (String)devVer)) continue;
            return true;
        }
        this.setAddDevErrMsgPropKey(tips);
        return false;
    }

    private boolean isFusionCubeSupport(String curDevSpcVer, String[] devVers, String tips, String scenarioInfo) {
        for (String devVer : devVers) {
            if (!Products.contains((String)curDevSpcVer, (String)devVer) || !org.apache.commons.lang3.StringUtils.containsAnyIgnoreCase((CharSequence)scenarioInfo, (CharSequence[])new CharSequence[]{"FusionSphere", "Database"})) continue;
            return true;
        }
        this.setAddDevErrMsgPropKey(tips);
        return false;
    }

    private boolean isDistributeFru() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        String mainScene = this.getMainScene(sceneJson);
        String subScene = this.getSubScene(sceneJson);
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)mainScene, (CharSequence)PARTS_REPLACEMENT) && org.apache.commons.lang3.StringUtils.equals((CharSequence)subScene, (CharSequence)DISTRIBUTED_FRU);
    }

    private String getMainScene(JSONObject sceneJson) {
        return Objects.nonNull(sceneJson) ? sceneJson.getStringOrDefault("mainScene", "") : "";
    }

    private String getSubScene(JSONObject sceneJson) {
        return Objects.nonNull(sceneJson) ? sceneJson.getStringOrDefault("subScene", "") : "";
    }

    public void setParent(ScenePreparedMainJDialog parent) {
        this.parent = parent;
    }

    public ScenePreparedMainJDialog getParent() {
        return this.parent;
    }

    public String getAddDevErrMsgPropKey() {
        return this.addDevErrMsgPropKey;
    }

    public void setAddDevErrMsgPropKey(String addDevErrMsgPropKey) {
        this.addDevErrMsgPropKey = addDevErrMsgPropKey;
    }

    public static DeviceManageSetting getSetting() {
        return setting;
    }

    public static void setSetting(DeviceManageSetting setting) {
        SceneAddDeviceAction.setting = setting;
    }
}

