/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.devicemanager.utils.AuthType;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;

public class AuthSettingDilaog
extends JDialog {
    public static final int AUTHDESKEY = 2;
    private static final String NEED_PUBLICKEY = "true";
    private static final long serialVersionUID = 1L;
    private JRadioButton pwdRadio = new JRadioButton(AuthType.PWD.desc());
    private JRadioButton keyRadio = new JRadioButton(AuthType.KEY_AND_PWD.desc());
    private JRadioButton publicKeyRadio = new JRadioButton(AuthType.KEY.desc());
    private JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"device.adddialog.key.set.ok"), (char)'O');
    private JButton canclBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"device.adddialog.key.set.cancel"), (char)'C');
    private DeviceAddDialog parent;
    private Map<String, String> authTypeConfig = PlatformAppContext.getInstance().getAuthTypeConfig();

    public AuthSettingDilaog(DeviceAddDialog parent) {
        super(parent);
        this.parent = parent;
        this.initUI();
        this.initListener();
        this.setCompName();
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(300, 100));
        this.setTitle(ResourceUtil.getString((String)"device.adddialog.key.set"));
        this.setLayout(new BorderLayout());
        if (!this.needPublicKey()) {
            this.publicKeyRadio.setVisible(false);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.pwdRadio);
        group.add(this.keyRadio);
        group.add(this.publicKeyRadio);
        AuthType authType = this.parent.getAuthType();
        if (authType.equals((Object)AuthType.PWD)) {
            this.pwdRadio.setSelected(true);
        } else if (authType.equals((Object)AuthType.KEY_AND_PWD)) {
            this.keyRadio.setSelected(true);
        } else {
            this.publicKeyRadio.setSelected(true);
        }
        Box view = UCD.buildVBoxTop((Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildVBoxTop((Component[])new Component[]{this.pwdRadio, this.publicKeyRadio, this.keyRadio})}), Box.createVerticalGlue(), UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.canclBtn})});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)12), "Center");
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
    }

    private boolean needPublicKey() {
        return NEED_PUBLICKEY.equalsIgnoreCase(this.authTypeConfig.get("needPublicKey"));
    }

    private boolean needPublicKeyTips() {
        return !StringUtils.isNULLStr((String)this.authTypeConfig.get("publicKeyTips"));
    }

    private AuthType getSelType() {
        if (this.keyRadio.isSelected()) {
            return AuthType.KEY_AND_PWD;
        }
        if (this.pwdRadio.isSelected()) {
            return AuthType.PWD;
        }
        return AuthType.KEY;
    }

    private void initListener() {
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthSettingDilaog.this.parent.setAuthType(AuthSettingDilaog.this.getSelType());
                AuthSettingDilaog.this.dispose();
            }
        });
        this.canclBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthSettingDilaog.this.dispose();
            }
        });
        this.publicKeyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AuthSettingDilaog.this.needPublicKeyTips()) {
                    DialogUtils.showInfoDialog((JDialog)AuthSettingDilaog.this, (String)((String)AuthSettingDilaog.this.authTypeConfig.get("publicKeyTips")));
                }
            }
        });
    }

    public void setCompName() {
        this.pwdRadio.setName("_RadioButton_pwdRadio");
        this.keyRadio.setName("_RadioButton_keyRadio");
        this.publicKeyRadio.setName("_RadioButton_publicKeyRadio");
        this.okBtn.setName("_Button_okBtn");
        this.okBtn.setName("_Button_canclBtn");
    }
}

