/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceTypePaneLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.config.validate.IpInputValidator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.ui.wizard.YesAndNoRadioPanel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.HintTextField;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public class DeviceAddFusionCubeLayout
extends JPanel {
    private static final int HINT_OFFSET = 6;
    private static final String PORT = "22";
    private static final String DM_PORT = "8088";
    private static final int MARGIN_TOP = 12;
    private static final int MARGIN_BOTTOM = 10;
    private static final String ADMIN_USER = "admin";
    private static final String IP_REGEX = "([a-fA-F0-9]|:|\\.)*";
    private static final int MAX_INPUT_IP_LENGTH = 45;
    private static final int FIELD_WIDTH_LENGTH = 0;
    private static final int MAX_INPUT_CONTENT_LENGTH = 60;
    private final JLabel ipLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cube.ipaddress"));
    private final HintTextField ipAddress = HintTextField.getNameTextField((String)"([a-fA-F0-9]|:|\\.)*", (String)"", (int)45, (int)0);
    private final JLabel sshUsernameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.desc"));
    private final HintTextField sshUsername = HintTextField.getNameTextField((String)".*", (String)"", (int)60, (int)0);
    private final JLabel sshPasswordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.password"));
    private final IsmPasswordField sshUserPassword = UiMethod.getPasswordFiled();
    private final JLabel sshPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
    private final HintTextField sshPort = HintTextField.getNameTextField((String)"[0-9]{1,5}", (String)"22", (int)60, (int)0);
    private final JLabel rootPasswordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.root.pwd.desc"));
    private final IsmPasswordField rootPassword = UiMethod.getPasswordFiled();
    private final JLabel dmUsernameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.dm.cube.loginname"));
    private final HintTextField dmUsername = HintTextField.getNameTextField((String)".*", (String)"admin", (int)60, (int)0);
    private final JLabel dmPasswordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.password"));
    private final IsmPasswordField dmPassword = UiMethod.getPasswordFiled();
    private final JLabel dmPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
    private final HintTextField dmPort = HintTextField.getNameTextField((String)"[0-9]{1,5}", (String)"8088", (int)60, (int)0);
    private final JLabel certificateLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.certificate"));
    private final YesAndNoRadioPanel yesAndNoButtonPanel = new YesAndNoRadioPanel();
    private final JLabel tipLabel = new JLabel(ResourceUtil.getImage((String)"question.png"));
    private final JLabel fcvIpLabel = new JLabel(ResourceUtil.getImage((String)"question.png"));
    private final JLabel fcvNameLabel = new JLabel(ResourceUtil.getImage((String)"question.png"));
    private final JLabel certLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.fusioncube.deviceadddialog.certificate.tips"));
    private DeviceTypePaneLayout deviceTypePaneLayout;
    private final List<HintTextField> hintTextCheckInputs = new ArrayList<HintTextField>();
    private final List<IsmPasswordField> passwordCheckInputs = new ArrayList<IsmPasswordField>();
    private final NotEmptyInputValidator notEmptyInputValidator = new NotEmptyInputValidator();
    private SceneDeviceAddDialog sceneDeviceAddDialog;

    public DeviceAddFusionCubeLayout(DeviceAddLayout parent) {
        this.deviceTypePaneLayout = new DeviceTypePaneLayout(parent);
        this.init();
    }

    public DeviceAddFusionCubeLayout(SceneDeviceAddDialog parent) {
        this.sceneDeviceAddDialog = parent;
        this.init();
    }

    private void initLayout() {
        this.ipAddress.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddress"));
        this.ipAddress.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.ipAddress.addInputValidator((InputValidator)new IpInputValidator());
        this.sshUsername.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.desc"));
        this.sshUsername.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.sshPort.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
        this.sshPort.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.dmUsername.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.dm.loginname"));
        this.dmUsername.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.dmPort.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
        this.dmPort.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.hintTextCheckInputs.clear();
        this.hintTextCheckInputs.addAll(Arrays.asList(this.ipAddress, this.sshUsername, this.sshPort, this.dmUsername, this.dmPort));
        this.sshUserPassword.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.empty.password"));
        this.sshUserPassword.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.rootPassword.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.root.pwd.desc"));
        this.rootPassword.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.dmPassword.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.dm.empty.password"));
        this.dmPassword.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.passwordCheckInputs.clear();
        this.passwordCheckInputs.addAll(Arrays.asList(this.sshUserPassword, this.rootPassword, this.dmPassword));
        this.dmPort.setEnabled(false);
        this.dmPort.setEditable(false);
        this.sshUsername.setToolTipText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.hint"));
        this.sshUsername.setHintText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.hint"));
        this.sshUsername.setOffSet(6);
        this.tipLabel.setToolTipText(ResourceUtil.getString((String)"devicemanager.layout.device.add.fusioncube.deviceadddialog.certificate.help"));
        this.fcvIpLabel.setToolTipText(ResourceUtil.getString((String)"devicemanager.layout.device.add.fusioncube.deviceadddialog.cube.ip.help"));
        this.fcvNameLabel.setToolTipText(ResourceUtil.getString((String)"devicemanager.layout.device.add.fusioncube.deviceadddialog.cube.username.help"));
        this.certLabel.setToolTipText(ResourceUtil.getString((String)"devicemanager.layout.device.add.fusioncube.deviceadddialog.certificate.tips"));
    }

    private void init() {
        this.initLayout();
        this.setLayout(new BorderLayout());
        JComponent component = this.createPan();
        this.add((Component)component, "North");
        this.setPreferredSize(new Dimension(415, 460));
    }

    public HintTextField getDmUsername() {
        return this.dmUsername;
    }

    public JPasswordField getDmPassword() {
        return this.dmPassword;
    }

    public HintTextField getSshUsername() {
        return this.sshUsername;
    }

    public IsmPasswordField getSshUserPassword() {
        return this.sshUserPassword;
    }

    public IsmPasswordField getRootPassword() {
        return this.rootPassword;
    }

    public HintTextField getDmPort() {
        return this.dmPort;
    }

    public HintTextField getSshPort() {
        return this.sshPort;
    }

    public HintTextField getIpAddress() {
        return this.ipAddress;
    }

    public DeviceTypePaneLayout getDeviceTypePaneLayout() {
        return this.deviceTypePaneLayout;
    }

    public List<HintTextField> getTextChecktInputs() {
        return this.hintTextCheckInputs;
    }

    public List<IsmPasswordField> getPasswordCheckInputs() {
        return this.passwordCheckInputs;
    }

    public void setItDeviceType(List<ItDeviceType> itDevice1List, Map<ItDeviceType, List<String>> deviceTypel2Map) {
        this.deviceTypePaneLayout.setItDeviceTypel2(itDevice1List, deviceTypel2Map);
    }

    private JComponent createPan() {
        Box deviceTypePanelLayoutBox = Box.createVerticalBox();
        deviceTypePanelLayoutBox.add(Box.createVerticalStrut(12));
        if (this.deviceTypePaneLayout != null) {
            deviceTypePanelLayoutBox.add(this.deviceTypePaneLayout);
            deviceTypePanelLayoutBox.add(Box.createVerticalStrut(10));
        }
        JComponent topBasicInfo = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{deviceTypePanelLayoutBox, UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0))});
        JPanel topBasicPanel = new JPanel(new BorderLayout());
        topBasicPanel.add((Component)topBasicInfo, "North");
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{this.ipLabel, this.dmUsernameLabel, this.dmPasswordLabel, this.dmPortLabel, this.sshUsernameLabel, this.sshPasswordLabel, this.sshPortLabel, this.rootPasswordLabel});
        UiMethod.setComponentSize((Dimension)new Dimension(160, 21), (Component[])new Component[]{this.ipAddress, this.dmUsername, this.dmPassword, this.dmPort, this.sshUsername, this.sshUserPassword, this.sshPort, this.rootPassword});
        JPanel configPanel = this.getConfigPanel();
        return UCD.buildVerticalBox(null, (int)5, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), topBasicPanel, Box.createHorizontalStrut(0)}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), configPanel, Box.createHorizontalStrut(0)}), Box.createHorizontalStrut(0)});
    }

    @NotNull
    public JPanel getConfigPanel() {
        TitledBorder configBorder = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.info"));
        JComponent configPan = UCD.buildVerticalBox((Border)configBorder, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.ipLabel, this.ipAddress, this.fcvIpLabel})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.sshUsernameLabel, this.sshUsername})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.sshPasswordLabel, this.sshUserPassword})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.sshPortLabel, this.sshPort})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.rootPasswordLabel, this.rootPassword})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.dmUsernameLabel, this.dmUsername, this.fcvNameLabel})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.dmPasswordLabel, this.dmPassword})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.dmPortLabel, this.dmPort})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.certificateLabel, this.tipLabel, this.yesAndNoButtonPanel})})}), UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0)), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.certLabel})})})});
        JPanel configPanel = new JPanel(new BorderLayout());
        configPanel.add((Component)configPan, "North");
        return configPanel;
    }

    public boolean validFusionCubeInput() {
        boolean validEmptyInputRet;
        boolean bl = validEmptyInputRet = SwingUtil.validateHintTextInput(this.getTextChecktInputs(), (Window)this.sceneDeviceAddDialog) && SwingUtil.validatePwdInput(this.getPasswordCheckInputs(), (Window)this.sceneDeviceAddDialog);
        if (!validEmptyInputRet) {
            return false;
        }
        String sshPortString = this.getSshPort().getText();
        if (Integer.parseInt(sshPortString) > 65535 || Integer.parseInt(sshPortString) <= 0) {
            DialogUtils.showInfoDialog((JDialog)this.sceneDeviceAddDialog, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
            return false;
        }
        return true;
    }

    public DevNode createFusionCubeDev() {
        DevNode device = new DevNode();
        device.setLoginUser(this.buildLoginUser());
        device.setFusionCubeLoginUser(this.buildSshUser());
        device.setRootUser(this.buildRootUser());
        device.setIp(this.getIpAddress().getText());
        device.setPort(Integer.parseInt(this.getDmPort().getText()));
        device.setFusionCubeSSHPort(Integer.parseInt(this.getSshPort().getText()));
        device.setItDeviceType(ItDeviceType.FUSIONCUBE);
        return device;
    }

    private User buildRootUser() {
        String rootPasswordString = String.valueOf(this.getRootPassword().getPassword());
        User user = new User("root", Base64EncodeUtils.encode((String)rootPasswordString));
        StringUtils.cleanPwd((String)rootPasswordString);
        return user;
    }

    private User buildSshUser() {
        String sshPassword = String.valueOf(this.getSshUserPassword().getPassword());
        User user = new User(this.getSshUsername().getText(), sshPassword);
        StringUtils.cleanPwd((String)sshPassword);
        return user;
    }

    private User buildLoginUser() {
        String password = String.valueOf(this.getDmPassword().getPassword());
        User user = new User(this.getDmUsername().getText(), password);
        StringUtils.cleanPwd((String)password);
        return user;
    }

    public JLabel getIpLabel() {
        return this.ipLabel;
    }

    public YesAndNoRadioPanel getYesAndNoButtonPanel() {
        return this.yesAndNoButtonPanel;
    }
}

