/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.task.DevResultDisplayer;
import com.huawei.ism.tool.devicemanager.service.task.DeviceModifyObserver;
import com.huawei.ism.tool.devicemanager.service.task.ModifyTask;
import com.huawei.ism.tool.devicemanager.ui.action.SelKeyAction;
import com.huawei.ism.tool.devicemanager.ui.dialog.ApplyDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.devicemanager.ui.mainframe.DeviceManagementPanel;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public class DeviceModifyDialog
extends JDialog
implements ActionListener {
    private static final String ROOT = "root";
    private static final long serialVersionUID = -311135654180093464L;
    private Window window = null;
    private DevNode device;
    private List<DevNode> deviceNodes = null;
    private IsmTextField username;
    private JLabel deviceType;
    private JLabel deviceName;
    private JLabel deviceSerialNumber;
    private JPasswordField password;
    private JLabel rPsdLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.rootpw"));
    private JPasswordField rtPwd;
    private IsmTextField portField;
    private JPasswordField keypwd;
    private JComboBox<String> keyCom;
    private JButton selBtn;
    private JLabel ipAddress;
    private JButton confirm;
    private JButton cancel;
    private JButton help;
    private JButton applyTo;
    private List<DevNode> nodeLists = null;
    private List<DevNode> selectDevNode = new ArrayList<DevNode>();
    private boolean needDevPwd = false;
    private JPasswordField developerPwd;
    private JCheckBox developerCheck;
    private ApplyDialog applyDialog;
    private JLabel developerLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer"));
    private boolean needDebugPassWordTip = false;
    private JLabel needDebugPassWordTipLabel = new JLabel();

    public DeviceModifyDialog(DeviceManagementPanel panel, DevNode device) {
        super(panel.getParentJFrame());
        this.device = device;
        this.init();
    }

    public JPasswordField getRtPwd() {
        return this.rtPwd;
    }

    public void setRtPwd(JPasswordField rtPwd) {
        this.rtPwd = rtPwd;
    }

    public DeviceModifyDialog(Window panel, DevNode device) {
        super(panel);
        this.window = panel;
        this.device = device;
        this.init();
    }

    public DeviceModifyDialog(Window panel, DevNode device, String tip) {
        super(panel);
        this.window = panel;
        this.device = device;
        this.needDebugPassWordTip = true;
        this.needDebugPassWordTipLabel.setText(tip);
        this.init();
    }

    public DeviceModifyDialog(Window panel, DevNode device, List<DevNode> devNodes, boolean needDevPwd) {
        super(panel);
        this.window = panel;
        this.device = device;
        this.deviceNodes = devNodes;
        this.needDevPwd = needDevPwd;
        this.init();
    }

    private void init() {
        this.initAllShowNodes();
        this.setMinimumSize(new Dimension(320, 350));
        this.initComponent();
        this.initUi();
        this.initListener();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.confirm});
        UiMethod.setCloseWhenEscKeyPressed((JDialog)this);
        this.setModal(true);
        this.setCompName();
    }

    private void initAllShowNodes() {
        this.nodeLists = this.mapShowNodes();
    }

    private List<DevNode> mapShowNodes() {
        if (!DeviceAddUtil.isA800SceneInToolBox()) {
            return DefaultNodeProviderImpl.getInstance().getNodeList();
        }
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getOmNodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void initComponent() {
        this.username = UiMethod.getUsernameFiled();
        this.username.setText(this.device.getLoginUser() == null ? "" : this.device.getLoginUser().getUserName());
        this.password = UiMethod.getPasswordFiled();
        this.rtPwd = UiMethod.getPasswordFiled();
        this.portField = UiMethod.getSshPortFiled();
        this.portField.setText(String.valueOf(this.device.getPort()));
        this.deviceName = new JLabel(this.device.getDeviceName());
        this.deviceType = ApplicationContext.getInstance().isOEM() ? new JLabel(this.device.getOemModel()) : new JLabel(this.device.getDeviceType().toString());
        this.deviceSerialNumber = new JLabel(this.device.getDeviceSerialNumber());
        this.ipAddress = new JLabel(this.device.getIp());
        this.confirm = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbutton"));
        this.cancel = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"));
        this.help = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.helpbtn"));
        this.applyTo = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.applyto"), (char)'A');
        this.developerPwd = UiMethod.getPasswordFiled();
        this.setDebugEnabled(false);
        this.developerCheck = new JCheckBox(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.check"));
        this.setDebugPassword(this.needDevPwd);
        this.keyCom = new JComboBox();
        this.keypwd = UiMethod.getPasswordFiled();
        this.selBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"device.adddialog.key.select"), (char)'B');
        if (null != this.device.getPriKey()) {
            DeviceContext.getInstance().saveKeyName(this.device.getPriKey().getKeyName(), this.device.getPriKey().getKeyPath());
            for (String s : DeviceContext.getInstance().getKeyNames().keySet()) {
                this.keyCom.addItem(s);
            }
            this.keyCom.setSelectedItem(this.device.getPriKey().getKeyName());
            this.keypwd.setText(this.device.getPriKey().getKeyPwd());
        }
        UiMethod.setComponentSize((Dimension)new Dimension(150, 21), (Component[])new Component[]{this.username, this.password, this.rtPwd, this.portField, this.deviceName, this.deviceType, this.deviceSerialNumber, this.ipAddress, this.developerPwd, this.keyCom, this.keypwd});
        this.getRootPane().setDefaultButton(this.confirm);
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.applyTo, this.confirm, this.cancel, this.help});
    }

    public void setDebugPasswdFocused() {
        this.developerCheck.setSelected(true);
        this.developerPwd.setEnabled(true);
        this.developerPwd.setFocusable(true);
        this.developerPwd.requestFocusInWindow();
    }

    private void setDebugPassword(boolean needPwd) {
        if (ApplicationContext.getInstance().isOEM()) {
            this.setDevpasdVisible(false);
            this.enableDevpasd(false);
        } else if (!StringUtils.isNULLStr((String)this.device.getDeveloperPwd())) {
            this.developerPwd.setText(this.device.getDeveloperPwd());
            this.enableDevpasd(true);
        } else {
            this.enableDevpasd(needPwd);
        }
    }

    private void initListener() {
        this.confirm.addActionListener(this);
        this.cancel.addActionListener(this);
        this.help.addActionListener(this);
        this.username.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                User rUser = SshConnectionManager.getDevRUser((String)DeviceModifyDialog.this.device.getDevKey());
                if (rUser != null) {
                    if (DeviceModifyDialog.this.username.getText().isEmpty() || DeviceModifyDialog.ROOT.equalsIgnoreCase(DeviceModifyDialog.this.username.getText())) {
                        DeviceModifyDialog.this.rtPwd.setVisible(false);
                        DeviceModifyDialog.this.rPsdLabel.setVisible(false);
                    } else {
                        DeviceModifyDialog.this.rtPwd.setVisible(true);
                        DeviceModifyDialog.this.rPsdLabel.setVisible(true);
                    }
                }
            }
        });
        this.applyTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                if (null == DeviceModifyDialog.this.applyDialog) {
                    DeviceModifyDialog.this.applyDialog = new ApplyDialog(DeviceModifyDialog.this);
                }
                DeviceModifyDialog.this.applyDialog.initData(DeviceModifyDialog.this.getNodes());
                DeviceModifyDialog.this.applyDialog.setVisible(true);
                if (!DeviceModifyDialog.this.applyDialog.isCancelClose()) {
                    DeviceModifyDialog.this.selectDevNode = DeviceModifyDialog.this.applyDialog.getSelectRow();
                }
                DeviceModifyDialog.this.selectDevNode.add(DeviceModifyDialog.this.device);
            }
        });
        this.developerCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceModifyDialog.this.setDebugEnabled(DeviceModifyDialog.this.developerCheck.isSelected());
            }
        });
        this.selBtn.addActionListener(new SelKeyAction(this, this.keyCom));
    }

    private List<DevNode> getNodes() {
        ArrayList<DevNode> nodes = new ArrayList<DevNode>();
        ArrayList<DevNode> deivces = new ArrayList<DevNode>();
        if (null != this.deviceNodes) {
            deivces.addAll(this.deviceNodes);
        } else {
            deivces.addAll(this.mapShowNodes());
        }
        for (DevNode devNode : deivces) {
            if (devNode.equals((Object)this.device)) continue;
            nodes.add(devNode);
        }
        return nodes;
    }

    private void initUi() {
        this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.title"));
        this.setLayout(new BorderLayout());
        if (this.needDebugPassWordTip) {
            Box needpasswdcom = UCD.buildHBoxLeft((Component[])new Component[]{this.needDebugPassWordTipLabel, this.deviceType});
            this.add(UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{needpasswdcom, this.createCom(), UCD.buildHBoxRight((Component[])new Component[]{this.confirm, this.applyTo, this.cancel})}), (int)12));
        } else {
            this.add(UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{this.createCom(), UCD.buildHBoxRight((Component[])new Component[]{this.confirm, this.applyTo, this.cancel})}), (int)12));
        }
        if (ItDeviceType.Host.equals((Object)this.device.getItDeviceType()) || ItDeviceType.DStorage.equals((Object)this.device.getItDeviceType())) {
            this.setDevpasdVisible(false);
        }
    }

    private void setDevpasdVisible(boolean visible) {
        this.developerLabel.setVisible(visible);
        this.developerPwd.setVisible(visible);
        this.developerCheck.setVisible(visible);
    }

    private JComponent createCom() {
        JLabel deviceTypeLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.devicetype"));
        JLabel deviceNameLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.devicename"));
        JLabel ipAddressLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.ipaddress"));
        JLabel serialLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.serial"));
        JLabel usernameLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.username"));
        JLabel passwordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.password"));
        JLabel portLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
        JLabel keyLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"device.adddialog.key.field"));
        JLabel keyPwdLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"device.adddialog.key.pwd"));
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{deviceTypeLable, deviceNameLable, ipAddressLable, serialLabel, usernameLable, passwordLabel, this.rPsdLabel, this.developerLabel, keyLabel, keyPwdLabel, portLabel});
        Box devtypecom = UCD.buildHBoxLeft((Component[])new Component[]{deviceTypeLable, this.deviceType});
        Box devnamecom = UCD.buildHBoxLeft((Component[])new Component[]{deviceNameLable, this.deviceName});
        Box ipcom = UCD.buildHBoxLeft((Component[])new Component[]{ipAddressLable, this.ipAddress});
        Box sncom = UCD.buildHBoxLeft((Component[])new Component[]{serialLabel, this.deviceSerialNumber});
        Box namecom = UCD.buildHBoxLeft((Component[])new Component[]{usernameLable, this.username});
        Box pwdcom = UCD.buildHBoxLeft((Component[])new Component[]{passwordLabel, this.password});
        Box rPwdcom = UCD.buildHBoxLeft((Component[])new Component[]{this.rPsdLabel, this.rtPwd});
        Box portcom = UCD.buildHBoxLeft((Component[])new Component[]{portLabel, this.portField});
        Box debugchekc = UCD.buildHBoxLeft((Component[])new Component[]{this.developerCheck});
        Box debugcom = UCD.buildHBoxLeft((Component[])new Component[]{this.developerLabel, this.developerPwd});
        Box keycom = UCD.buildHBoxLeft((Component[])new Component[]{keyLabel, this.keyCom, this.selBtn});
        Box keypwdcom = UCD.buildHBoxLeft((Component[])new Component[]{keyPwdLabel, this.keypwd});
        if (null != this.device.getPriKey()) {
            JComponent component = UCD.buildVerticalBox(null, (Component[])new Component[]{devtypecom, devnamecom, ipcom, sncom, namecom, pwdcom, portcom, debugchekc, debugcom, keycom, keypwdcom, Box.createVerticalStrut(12)});
            this.addRootPdwComp(rPwdcom, component);
        }
        JComponent resultCom = UCD.buildVerticalBox(null, (Component[])new Component[]{devtypecom, devnamecom, ipcom, sncom, namecom, pwdcom, portcom, debugchekc, debugcom, Box.createVerticalStrut(12)});
        this.addRootPdwComp(rPwdcom, resultCom);
        return resultCom;
    }

    private void addRootPdwComp(JComponent rPwdcom, JComponent resultCom) {
        if (SshConnectionManager.getDevRUser((String)this.device.getDevKey()) != null && !ROOT.equals(this.device.getLoginUser().getUserName())) {
            resultCom.add((Component)rPwdcom, 12);
            resultCom.add(Box.createVerticalStrut(12), 13);
        }
    }

    public void setPasswordDisable() {
        this.password.setEditable(false);
        this.password.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (null != actionEvent) {
            Object source = actionEvent.getSource();
            if (source == this.confirm) {
                this.updateDevice();
            } else if (source == this.cancel) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void updateDevice() {
        String uname = this.username.getText();
        String pwd = new String(this.password.getPassword());
        int port = StringUtils.str2Int((String)this.portField.getText());
        User user = new User(uname, pwd, port);
        if (StringUtils.hasNULLStr((String[])new String[]{uname, this.portField.getText()}) || this.password.isEnabled() && StringUtils.isNULLStr((String)pwd) || this.rpdwNotValid()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceinfoblank"));
            return;
        }
        if (port > 65535 || port <= 0) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
            return;
        }
        String devpwd = "";
        if (this.developerCheck.isSelected() && this.developerPwd.isVisible() && this.developerPwd.isEnabled() && StringUtils.isNULLStr((String)(devpwd = String.valueOf(this.developerPwd.getPassword())))) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.inputnull"));
            return;
        }
        if (this.selectDevNode.isEmpty() && !this.checkInfo(user) && this.rPsdUnchange()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.usernamepasswordnochange"));
            return;
        }
        ProgressNumDialog progressDialog = this.initProcessDialog();
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        if (this.selectDevNode.isEmpty()) {
            this.selectDevNode.add(this.device);
        }
        PriKeyInfo info = this.initPrivateKey();
        DevNode updateinfo = new DevNode();
        updateinfo.setLoginUser(user);
        updateinfo.setDeveloperPwd(devpwd);
        updateinfo.setPriKey(info);
        String rPsdStr = new String(this.rtPwd.getPassword());
        if (!StringUtils.isNULLStr((String)rPsdStr)) {
            User rUserNew = new User(ROOT, Base64EncodeUtils.encode((String)rPsdStr), port);
            updateinfo.setRootUser(rUserNew);
        }
        ModifyTask task = new ModifyTask(progressDialog, this.selectDevNode, updateinfo, false, DeviceOpr.EDIT);
        DevResultDisplayer displayer = new DevResultDisplayer();
        task.setDeviceModifyObserver(new DeviceModifyObserver(displayer));
        this.setVisible(false);
        TaskResult result = taskExecutor.execute((ServiceTask)task);
        result = DeviceQueryErrorParser.parseErrorInfo(result);
        this.handleReslut(updateinfo, displayer, result);
        devpwd = "";
    }

    private boolean rpdwNotValid() {
        User rUser = SshConnectionManager.getDevRUser((String)this.device.getDevKey());
        if (rUser == null) {
            return false;
        }
        String rPsdStr = new String(this.rtPwd.getPassword());
        boolean isnull = StringUtils.isNULLStr((String)rPsdStr);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)rPsdStr);
        return isnull;
    }

    private boolean rPsdUnchange() {
        User rUser = SshConnectionManager.getDevRUser((String)this.device.getDevKey());
        if (rUser == null || ROOT.equals(this.username.getText())) {
            return true;
        }
        String rPsdStr = new String(this.rtPwd.getPassword());
        boolean isequal = rPsdStr.equals(Base64EncodeUtils.decode((String)rUser.getPassword()));
        rPsdStr = null;
        return isequal;
    }

    private void handleReslut(DevNode updateinfo, DevResultDisplayer displayer, TaskResult result) {
        if (null != result && result.getResult() == TaskResult.Result.FAILED) {
            this.dispose();
            DialogUtils.showInfoDialog((JDialog)this, (String)result.getErrorLocaleDescription());
            this.setVisible(true);
        } else {
            displayer.showResult(this);
            Set<String> excludDevNode = displayer.getFailedDeviceMap().keySet();
            this.addModifiedNodes(excludDevNode, updateinfo);
        }
    }

    private PriKeyInfo initPrivateKey() {
        PriKeyInfo info = null;
        if (null != this.device.getPriKey()) {
            info = new PriKeyInfo();
            String name = (String)this.keyCom.getSelectedItem();
            String pwd = String.valueOf(this.keypwd.getPassword());
            info.setKeyPwd(pwd);
            info.setKeyName(name);
            info.setKeyPath(DeviceContext.getInstance().getKeyNames().get(name));
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
        }
        return info;
    }

    private ProgressNumDialog initProcessDialog() {
        ProgressNumDialog progressDialog = null != this.window ? new ProgressNumDialog(this.window) : new ProgressNumDialog((Window)this);
        return progressDialog;
    }

    private void addModifiedNodes(Set<String> excludDevNode, DevNode updateinfo) {
        List<DevNode> modifyDevicesInfo = DeviceContext.getInstance().getModifyDevicesInfo();
        for (DevNode selDevNode : this.selectDevNode) {
            if (excludDevNode.contains(selDevNode.getIp())) continue;
            for (DevNode devNode : modifyDevicesInfo) {
                if (!selDevNode.getIp().equals(devNode.getIp())) continue;
                modifyDevicesInfo.remove(devNode);
                break;
            }
            selDevNode.setLoginUser(updateinfo.getLoginUser());
            selDevNode.setDeveloperPwd(updateinfo.getDeveloperPwd());
            modifyDevicesInfo.add(selDevNode);
            if (updateinfo.getRootUser() != null) continue;
            SshConnectionManager.removeDevRUser((String)selDevNode.getDevKey());
        }
    }

    private boolean checkInfo(User newUser) {
        boolean keychanged;
        User oldUser = this.device.getLoginUser();
        String uname = newUser.getUserName();
        String pwd = newUser.getPassword();
        String olddevPwd = this.device.getDeveloperPwd();
        String devPwd = "";
        if (this.developerCheck.isSelected()) {
            devPwd = String.valueOf(this.developerPwd.getPassword());
        }
        int port = newUser.getPort();
        PriKeyInfo oldinfo = this.device.getPriKey();
        String newname = (String)this.keyCom.getSelectedItem();
        boolean bl = null == oldinfo ? true : (keychanged = oldinfo.getKeyName().equals(newname) && oldinfo.getKeyPwd().equals(String.valueOf(this.keypwd.getPassword())) && oldinfo.getKeyPath().equals(DeviceContext.getInstance().getKeyNames().get(newname)));
        if (oldUser.getUserName().equals(uname) && oldUser.getPassword().equals(pwd) && this.device.getPort() == port && olddevPwd.equals(devPwd) && keychanged) {
            devPwd = "";
            pwd = "";
            return false;
        }
        devPwd = "";
        pwd = "";
        return true;
    }

    public void setCompName() {
        this.username.setName("_IsmTextField_username");
        this.password.setName("_PasswordField_password");
        this.portField.setName("_IsmTextField_portField");
        this.keypwd.setName("_PasswordField_keypwd");
        this.keyCom.setName("_ComboBox_keyCom");
        this.selBtn.setName("_Button_selBtn");
        this.confirm.setName("_Button_confirm");
        this.cancel.setName("_Button_cancel");
        this.help.setName("_Button_help");
        this.applyTo.setName("_Button_applyTo");
        this.developerPwd.setName("_PasswordField_developerPwd");
        this.developerCheck.setName("_CheckBox_developerPwd");
    }

    public void enableDevpasd(boolean isEnable) {
        this.developerCheck.setSelected(isEnable);
        this.setDebugEnabled(isEnable);
    }

    public List<DevNode> getNodeLists() {
        return this.nodeLists;
    }

    public void setNodeLists(List<DevNode> nodeLists) {
        this.nodeLists = nodeLists;
    }

    private void setDebugEnabled(boolean isEnabled) {
        this.developerPwd.setEnabled(isEnabled);
        this.developerLabel.setEnabled(isEnabled);
    }
}

