/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.task.DevResultDisplayer;
import com.huawei.ism.tool.devicemanager.service.task.DeviceModifyObserver;
import com.huawei.ism.tool.devicemanager.service.task.ModifyTask;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.HintTextField;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.ui.swing.text.validator.PortInputValidator;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class DeviceModifyFusionCubeDialog
extends JDialog
implements ActionListener {
    private static final String ROOT = "root";
    private static final int FIELD_WIDTH_LENGTH = 0;
    private static final int MAX_INPUT_CONTENT_LENGTH = 60;
    private static final String PORT = "22";
    private static final String DM_PORT = "8088";
    private static final int MARGIN_TOP = 12;
    private static final int MARGIN_BOTTOM = 10;
    private static final String ADMIN_USER = "admin";
    private Window window = null;
    private List<DevNode> nodeLists = null;
    private DevNode device;
    private List<DevNode> deviceNodes = null;
    private IsmTextField username;
    private JLabel deviceType;
    private JLabel deviceName;
    private JLabel deviceSerialNumber;
    private JLabel ipAddress;
    private JButton confirm;
    private JButton cancel;
    private JButton help;
    private List<DevNode> selectDevNode = new ArrayList<DevNode>();
    private List<HintTextField> hintTextCheckInputs = new ArrayList<HintTextField>();
    private List<IsmPasswordField> passwordCheckInputs = new ArrayList<IsmPasswordField>();
    private NotEmptyInputValidator notEmptyInputValidator = new NotEmptyInputValidator();
    private PortInputValidator portInputValidator = new PortInputValidator();
    private JLabel deviceTypeLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.devicetype"));
    private JLabel deviceNameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.devicename"));
    private JLabel ipAddressLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.ipaddress"));
    private JLabel serialLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.serial"));
    private JLabel sshUsernameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.desc"));
    private HintTextField sshUsername = HintTextField.getNameTextField((String)".*", (String)"", (int)60, (int)0);
    private JLabel sshPasswordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.password"));
    private IsmPasswordField sshUserPassword = UiMethod.getPasswordFiled();
    private JLabel sshPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
    private HintTextField sshPort = HintTextField.getNameTextField((String)"[0-9]{1,5}", (String)"22", (int)60, (int)0);
    private JLabel rootPasswordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.root.pwd.desc"));
    private IsmPasswordField rootPassword = UiMethod.getPasswordFiled();
    private JLabel dmUsernameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.dm.loginname"));
    private HintTextField dmUsername = HintTextField.getNameTextField((String)".*", (String)"admin", (int)60, (int)0);
    private JLabel dmPasswordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.password"));
    private IsmPasswordField dmPassword = UiMethod.getPasswordFiled();
    private JLabel dmPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
    private HintTextField dmPort = HintTextField.getNameTextField((String)"[0-9]{1,5}", (String)"8088", (int)60, (int)0);

    public DeviceModifyFusionCubeDialog(Window panel, DevNode device) {
        super(panel);
        this.window = panel;
        this.device = device;
        this.init();
    }

    private void init() {
        this.nodeLists = DefaultNodeProviderImpl.getInstance().getNodeList();
        this.setMinimumSize(new Dimension(320, 350));
        this.initComponent();
        this.initInputValidator();
        this.initUi();
        this.initListener();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.confirm});
        UiMethod.setCloseWhenEscKeyPressed((JDialog)this);
        this.setModal(true);
    }

    private void initInputValidator() {
        this.sshUsername.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.desc"));
        this.sshUsername.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.sshUserPassword.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.empty.password"));
        this.sshUserPassword.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.sshPort.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
        this.sshPort.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.sshPort.addInputValidator((InputValidator)this.portInputValidator);
        this.rootPassword.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.root.pwd.desc"));
        this.rootPassword.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.dmUsername.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.dm.loginname"));
        this.dmUsername.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.dmPassword.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.dm.empty.password"));
        this.dmPassword.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.dmPort.setInputValueName(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
        this.dmPort.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.dmPort.addInputValidator((InputValidator)this.portInputValidator);
        this.hintTextCheckInputs.clear();
        this.hintTextCheckInputs.addAll(Arrays.asList(this.sshUsername, this.sshPort, this.dmUsername, this.dmPort));
        this.passwordCheckInputs.clear();
        this.passwordCheckInputs.addAll(Arrays.asList(this.sshUserPassword, this.rootPassword, this.dmPassword));
    }

    private void initUi() {
        this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.title"));
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{this.createComponent(), UCD.buildHBoxRight((Component[])new Component[]{this.confirm, this.cancel})}), (int)12));
    }

    private JComponent createComponent() {
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{this.deviceTypeLabel, this.deviceNameLabel, this.ipAddressLabel, this.serialLabel, this.sshUsernameLabel, this.sshPasswordLabel, this.sshPortLabel, this.rootPasswordLabel, this.dmUsernameLabel, this.dmPasswordLabel, this.dmPortLabel});
        Box deviceTypeComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.deviceTypeLabel, this.deviceType});
        Box deviceNameComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.deviceNameLabel, this.deviceName});
        Box ipComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.ipAddressLabel, this.ipAddress});
        Box snComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.serialLabel, this.deviceSerialNumber});
        Box sshUsernameComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.sshUsernameLabel, this.sshUsername});
        Box sshPasswordComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.sshPasswordLabel, this.sshUserPassword});
        Box sshPortComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.sshPortLabel, this.sshPort});
        Box rootPasswordComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.rootPasswordLabel, this.rootPassword});
        Box dmUsernameComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.dmUsernameLabel, this.dmUsername});
        Box dmPasswordComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.dmPasswordLabel, this.dmPassword});
        Box dmPortComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.dmPortLabel, this.dmPort});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{deviceTypeComponent, deviceNameComponent, ipComponent, snComponent, sshUsernameComponent, sshPasswordComponent, sshPortComponent, rootPasswordComponent, dmUsernameComponent, dmPasswordComponent, dmPortComponent, Box.createVerticalStrut(12)});
    }

    private void initListener() {
        this.confirm.addActionListener(this);
        this.cancel.addActionListener(this);
        this.help.addActionListener(this);
    }

    private void initComponent() {
        this.deviceType = new JLabel(this.device.getDeviceType().toString());
        this.deviceName = new JLabel(this.device.getDeviceName());
        this.ipAddress = new JLabel(this.device.getIp());
        this.deviceSerialNumber = new JLabel(this.device.getDeviceSerialNumber());
        this.sshUsername.setText(this.device.getFusionCubeLoginUser().getUserName());
        this.sshUsername.setHintText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sshuser.hint"));
        this.dmUsername.setText(this.device.getLoginUser().getUserName());
        this.sshPort.setText(String.valueOf(this.device.getFusionCubeSSHPort()));
        this.dmPort.setText(String.valueOf(this.device.getPort()));
        UiMethod.setComponentSize((Dimension)new Dimension(150, 21), (Component[])new Component[]{this.sshUsername, this.sshUserPassword, this.sshPort, this.rootPassword, this.dmUsername, this.dmPassword, this.deviceName, this.deviceType, this.deviceSerialNumber, this.ipAddress, this.dmPort});
        this.help = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.helpbtn"));
        this.confirm = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbutton"));
        this.cancel = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"));
        this.getRootPane().setDefaultButton(this.confirm);
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.confirm, this.cancel, this.help});
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Objects.nonNull(actionEvent)) {
            Object source = actionEvent.getSource();
            if (source == this.confirm) {
                this.updateDevice();
            } else if (source == this.cancel) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private boolean validFusionCubeInput() {
        boolean validEmptyInputRet;
        boolean bl = validEmptyInputRet = SwingUtil.validateHintTextInput(this.hintTextCheckInputs, (Window)this) && SwingUtil.validatePwdInput(this.passwordCheckInputs, (Window)this);
        return validEmptyInputRet;
    }

    private void updateDevice() {
        if (!this.validFusionCubeInput()) {
            return;
        }
        DevNode updateInfo = new DevNode();
        updateInfo.setItDeviceType(ItDeviceType.FUSIONCUBE);
        String password = String.valueOf(this.dmPassword.getPassword());
        User user = new User(this.dmUsername.getText(), password);
        StringUtils.cleanPwd((String)password);
        updateInfo.setLoginUser(user);
        updateInfo.setPort(Integer.parseInt(this.dmPort.getText()));
        String sshPassword = String.valueOf(this.sshUserPassword.getPassword());
        updateInfo.setFusionCubeLoginUser(new User(this.sshUsername.getText(), sshPassword));
        StringUtils.cleanPwd((String)sshPassword);
        String rootPasswordStr = String.valueOf(this.rootPassword.getPassword());
        updateInfo.setRootUser(new User(ROOT, Base64EncodeUtils.encode((String)rootPasswordStr)));
        StringUtils.cleanPwd((String)rootPasswordStr);
        updateInfo.setFusionCubeSSHPort(Integer.parseInt(this.sshPort.getText()));
        if (!this.checkKeyInfoChange(updateInfo)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.usernamepasswordnochange"));
            return;
        }
        ProgressNumDialog progressDialog = this.initProcessDialog();
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        if (this.selectDevNode.isEmpty()) {
            this.selectDevNode.add(this.device);
        }
        ModifyTask task = new ModifyTask(progressDialog, this.selectDevNode, updateInfo, false, DeviceOpr.EDIT);
        DevResultDisplayer displayer = new DevResultDisplayer();
        task.setDeviceModifyObserver(new DeviceModifyObserver(displayer));
        this.setVisible(false);
        TaskResult result = taskExecutor.execute((ServiceTask)task);
        result = DeviceQueryErrorParser.parseErrorInfo(result);
        this.handleReslut(updateInfo, displayer, result);
    }

    private boolean checkKeyInfoChange(DevNode updateInfo) {
        User newSshUser = updateInfo.getFusionCubeLoginUser();
        User oldSshUser = this.device.getFusionCubeLoginUser();
        boolean isSshUserModify = !org.apache.commons.lang3.StringUtils.equals((CharSequence)newSshUser.getUserName(), (CharSequence)oldSshUser.getUserName()) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)newSshUser.getPassword(), (CharSequence)oldSshUser.getPassword()) || updateInfo.getFusionCubeSSHPort() != this.device.getFusionCubeSSHPort();
        User newRootUser = updateInfo.getRootUser();
        User oldRootUser = this.device.getRootUser();
        boolean isRootUserModify = !org.apache.commons.lang3.StringUtils.equals((CharSequence)Base64EncodeUtils.decode((String)newRootUser.getPassword()), (CharSequence)Base64EncodeUtils.decode((String)oldRootUser.getPassword()));
        User newDmUser = updateInfo.getLoginUser();
        User oldDmUser = this.device.getLoginUser();
        boolean isDmUserModify = !org.apache.commons.lang3.StringUtils.equals((CharSequence)newDmUser.getUserName(), (CharSequence)oldDmUser.getUserName()) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)newDmUser.getPassword(), (CharSequence)oldSshUser.getPassword()) || updateInfo.getPort() != this.device.getPort();
        return isSshUserModify || isRootUserModify || isDmUserModify;
    }

    private void handleReslut(DevNode updateinfo, DevResultDisplayer displayer, TaskResult result) {
        if (Objects.nonNull(result) && result.getResult() == TaskResult.Result.FAILED) {
            this.dispose();
            DialogUtils.showInfoDialog((JDialog)this, (String)result.getErrorLocaleDescription());
            this.setVisible(true);
        } else {
            displayer.showResult(this);
            Set<String> excludDevNode = displayer.getFailedDeviceMap().keySet();
            this.addModifiedNodes(excludDevNode, updateinfo);
        }
    }

    private void addModifiedNodes(Set<String> excludDevNode, DevNode updateinfo) {
        List<DevNode> modifyDevicesInfo = DeviceContext.getInstance().getModifyDevicesInfo();
        this.selectDevNode.stream().filter(selDev -> !excludDevNode.contains(selDev.getIp())).forEach(selDev -> {
            this.removeModifyInfo(modifyDevicesInfo, (DevNode)selDev);
            selDev.setLoginUser(updateinfo.getLoginUser());
            selDev.setDeveloperPwd(updateinfo.getDeveloperPwd());
            modifyDevicesInfo.add((DevNode)selDev);
            if (updateinfo.getRootUser() == null) {
                SshConnectionManager.removeDevRUser((String)selDev.getDevKey());
            }
        });
    }

    private void removeModifyInfo(List<DevNode> modifyDevicesInfo, DevNode selDev) {
        boolean isIpMatch = modifyDevicesInfo.stream().map(DevNode::getIp).anyMatch(ip -> org.apache.commons.lang3.StringUtils.equals((CharSequence)ip, (CharSequence)selDev.getIp()));
        if (isIpMatch) {
            modifyDevicesInfo.remove(selDev);
        }
    }

    private ProgressNumDialog initProcessDialog() {
        ProgressNumDialog progressDialog = Objects.nonNull(this.window) ? new ProgressNumDialog(this.window) : new ProgressNumDialog((Window)this);
        return progressDialog;
    }
}

