/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.utils.UIUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONObject;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class ScenePreparedMainJDialogLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension DEFAULT_SIZE = new Dimension(950, 350);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ScenePreparedMainJDialogLayout.class);
    private ToolHyperLinkLabel addDeviceLabel = null;
    private ToolHyperLinkLabel supportProductLabel = null;
    private JButton setPathButton = null;
    private JComponent descriptionLabelA = new JLabel(ResourceUtil.getString((String)"scene.adddevice.description"));
    private IsmTable deviceTable = null;
    private DefaultTableModel deviceTableModel = null;
    private IsmTextField savePathText = null;
    private JComponent savePathLabel = null;
    private JComponent tipWhenUneditable = new JLabel(ResourceUtil.getString((String)"scean.tip.unEditable"));
    private JButton cancleBtn;
    private JButton okBtn;
    private String[] tableHeaders = new String[]{ResourceUtil.getString((String)"scene.devicetable.head.devicetype"), ResourceUtil.getString((String)"scene.devicetable.head.hostname"), ResourceUtil.getString((String)"scene.devicetable.head.productversion"), ResourceUtil.getString((String)"scene.devicetable.head.ip"), ResourceUtil.getString((String)"scene.devicetable.head.username"), ResourceUtil.getString((String)"scene.devicetable.head.operate")};

    public ScenePreparedMainJDialogLayout(boolean isEdit) {
        this.initComponent(isEdit);
        this.layoutComponents(isEdit);
    }

    public int getTableColumn() {
        return this.tableHeaders.length;
    }

    private void initComponent(boolean isEdit) {
        this.addDeviceLabel = new ToolHyperLinkLabel(ResourceUtil.getString((String)"scene.superlink.adddevice"));
        this.addDeviceLabel.setVisible(!LocalHostUtil.isRunInSvp());
        this.setSupportProductLabel(new ToolHyperLinkLabel(this.getSupportDeviceLink()));
        this.savePathLabel = UIUtils.createRequiredLabel(ResourceUtil.getString((String)"scene.collectpath"), true);
        String userPath = ApplicationContext.getInstance().getFilePath();
        if (StringUtils.isNULLStr((String)userPath)) {
            userPath = FileUtils.getDefaultDirectory().getAbsolutePath();
        }
        this.setSavePathText(IsmTextField.getNameTextField((String)".*", (String)userPath, (int)90, (int)25, (boolean)true));
        this.savePathText.setToolTipText(userPath);
        this.savePathText.setEditable(false);
        this.cancleBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"scene.button.cancel"), (char)'G');
        this.okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"scene.button.ok"), (char)'L');
        this.setSetPathButton(UiMethod.createButton((String)ResourceUtil.getString((String)"scene.button.setup"), (char)'A'));
        this.setPathButton.setEnabled(!isEdit);
        this.createDeviceTable();
    }

    private void createDeviceTable() {
        this.setDeviceTableModel(new DefaultTableModel(this.tableHeaders, new int[0]));
        this.setDeviceTable(new IsmTable((TableModel)this.getDeviceTableModel()));
    }

    private String getSupportDeviceLink() {
        String subSenceName = ResourceUtil.getString((String)"scene.superlink.supportdevice");
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (null == sceneJson) {
            LOGGER.error("Sence para(JSONObject) is null.");
            return subSenceName;
        }
        String subSence = sceneJson.get("subScene").toString();
        if ("Upgrade Check".equalsIgnoreCase(subSence)) {
            subSenceName = ResourceUtil.getString((String)"scene.superlink.supportdevice.checkchecks") + subSenceName;
        } else if ("Upgrade".equalsIgnoreCase(subSence)) {
            subSenceName = ResourceUtil.getString((String)"scene.superlink.supportdevice.upgradechecks") + subSenceName;
        } else if ("HotPatch".equalsIgnoreCase(subSence)) {
            subSenceName = ResourceUtil.getString((String)"scene.superlink.supportdevice.hotpatchchecks") + subSenceName;
        }
        return subSenceName;
    }

    private void layoutComponents(boolean isEdit) {
        JComponent collectPathArea = this.layoutcollectPathArea();
        JComponent descriptionArea = this.layoutDescrptionArea();
        JComponent tableArea = this.layoutTableArea(isEdit);
        JComponent buttonArea = this.layoutButtonArea();
        JComponent tipArea = this.layoutTipArea(isEdit);
        JComponent contentArea = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionArea}), UCD.buildHorizotalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalGlue()}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{tableArea})}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{collectPathArea}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{tipArea}), buttonArea});
        this.setLayout(new BorderLayout());
        this.add(this.buildFrameSpace(contentArea, 20, 30, 15, 35));
    }

    public JComponent getDescriptionLabelA() {
        return this.descriptionLabelA;
    }

    public void setDescriptionLabelA(JComponent descriptionLabelA) {
        this.descriptionLabelA = descriptionLabelA;
    }

    private JComponent layoutDescrptionArea() {
        JLabel descriptionLabelC = new JLabel(ResourceUtil.getString((String)"scene.importpackage.descriptionA"));
        JLabel wordEnd = new JLabel(ResourceUtil.getString((String)"scene.fullstop"));
        JComponent view = null;
        this.descriptionLabelA.setVisible(!LocalHostUtil.isRunInSvp());
        wordEnd.setVisible(!LocalHostUtil.isRunInSvp());
        view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.descriptionLabelA, this.addDeviceLabel, wordEnd}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionLabelC, this.getSupportProductLabel(), new JLabel(ResourceUtil.getString((String)"scene.importpackage.descriptionB")), new JLabel(ResourceUtil.getString((String)"scene.fullstop"))})});
        return view;
    }

    private JComponent layoutTableArea(boolean isEdit) {
        TableScrollPane pane = TableScrollPane.createTablePaneWithOutFilter((IsmTable)this.getDeviceTable(), (!DeviceSceneContext.getInstance().isSingleDev() ? 1 : 0) != 0);
        pane.setPreferredSize(DEFAULT_SIZE);
        if (isEdit) {
            try {
                if (DeviceSceneContext.getInstance().isSingleDev()) {
                    pane.disableTableExceptColumns(new int[]{5});
                } else {
                    pane.disableTableExceptColumns(new int[]{6});
                }
            }
            catch (Exception e) {
                LOGGER.error("Do layoutTableArea error...", (Throwable)e);
            }
        }
        return pane;
    }

    private JComponent layoutcollectPathArea() {
        JPanel collectPathArea = new JPanel();
        collectPathArea.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        collectPathArea.add((Component)this.savePathLabel, constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 10, 0, 0);
        collectPathArea.add((Component)this.getSavePathText(), constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 5, 0, 0);
        collectPathArea.add((Component)this.getSetPathButton(), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        collectPathArea.add((Component)new JLabel(), constraints);
        return collectPathArea;
    }

    private JComponent layoutTipArea(boolean isEdit) {
        if (!isEdit) {
            this.tipWhenUneditable.setVisible(false);
        } else {
            this.tipWhenUneditable.setVisible(true);
        }
        return UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.tipWhenUneditable});
    }

    private JComponent buildFrameSpace(JComponent contentArea, int left, int right, int up, int down) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(left));
        hBox.add(contentArea);
        hBox.add(Box.createHorizontalStrut(right));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(up));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(down));
        return vBox;
    }

    private JComponent layoutButtonArea() {
        JComponent bottomBtnArea = UiMethod.buildCompsRight((Component[])new Component[]{this.okBtn, this.cancleBtn});
        return bottomBtnArea;
    }

    public JButton getCancleBtn() {
        return this.cancleBtn;
    }

    public void setCancleBtn(JButton cancleBtn) {
        this.cancleBtn = cancleBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public void setOkBtn(JButton okBtn) {
        this.okBtn = okBtn;
    }

    public void setAddDeviceLabel(ToolHyperLinkLabel addDeviceLabel) {
        this.addDeviceLabel = addDeviceLabel;
    }

    public void setSupportProductLabel(ToolHyperLinkLabel supportProductLabel) {
        this.supportProductLabel = supportProductLabel;
    }

    public void setSetPathButton(JButton setPathButton) {
        this.setPathButton = setPathButton;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    public void setDeviceTableModel(DefaultTableModel deviceTableModel) {
        this.deviceTableModel = deviceTableModel;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public ToolHyperLinkLabel getAddDeviceLabel() {
        return this.addDeviceLabel;
    }

    public ToolHyperLinkLabel getSupportProductLabel() {
        return this.supportProductLabel;
    }

    public JButton getSetPathButton() {
        return this.setPathButton;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public IsmTextField getSavePathText() {
        return this.savePathText;
    }

    public void setSavePathText(IsmTextField savePathText) {
        this.savePathText = savePathText;
    }

    public JComponent getSavePathLabel() {
        return this.savePathLabel;
    }

    public void setSavePathLabel(JComponent savePathLabel) {
        this.savePathLabel = savePathLabel;
    }

    public void setTableHeaders(String[] tableHeaders) {
        this.tableHeaders = (String[])tableHeaders.clone();
    }
}

