/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.ui.dialog.ProxyDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.SettingLayout;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class SettingDialog
extends PublicDialog {
    public static final String PROXY_SETTING_FILE = "proxy_setting_file.tmp";
    public static final String SSH_FORWARD_FILENAME = "sshForward.dat";
    private static final int INT_2 = 2;
    private static final int INT_3 = 3;
    private static final int INT_4 = 4;
    private static final int INT_500 = 500;
    private static final int INT_600 = 600;
    private static final String ADD_SOCKS5 = "operalog.setting.operaLog.add";
    private static final String MODIFY_SOCKS5 = "operalog.setting.operaLog.modify";
    private static final String DELETE_SOCKS5 = "operalog.setting.operaLog.delete";
    private static final List<OperaLog> LOGS = new ArrayList<OperaLog>();
    private static final long serialVersionUID = -2093288588964812623L;
    private ILogSupportService logService = (ILogSupportService)PublicServiceManage.getInstance().getService(ILogSupportService.class);
    private SettingLayout layout = new SettingLayout((JDialog)((Object)this));

    public SettingDialog(JFrame parent) {
        super(parent, true);
        super.setHelpButtonVisiable(false);
        this.initDialog();
    }

    public SettingDialog(JDialog parent) {
        super(parent, true);
        super.setHelpButtonVisiable(false);
        this.initDialog();
    }

    public void setCurType(SettingType type) {
        String sshFwName = ResourceUtil.getString((String)"tab.sshforward.title");
        this.layout.setSelectTab(sshFwName);
    }

    private void initDialog() {
        this.add(this.layout);
        this.initData();
        this.initListener();
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        this.setSize(500, 600);
        this.setTitle(ResourceUtil.getString((String)"setting.title"));
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setDefaultCloseOperation(2);
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    private void initListener() {
        this.addButtonListener();
        this.modifyButtonListener();
        this.deletteButtonListener();
        this.okButtonListener();
        this.appButtonListener();
    }

    private void addButtonListener() {
        JButton addBtn = this.layout.getAddBtn();
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.addProxy();
            }
        });
    }

    private void modifyButtonListener() {
        JButton modifyBtn = this.layout.getModifyBtn();
        modifyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.modifyProxy();
            }
        });
    }

    private void deletteButtonListener() {
        JButton deleteBtn = this.layout.getDeleteBtn();
        deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.deleteSelectedProxies();
            }
        });
    }

    private void okButtonListener() {
        JButton okBtn = this.getOkBtn();
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.saveSocksProxies();
                SettingDialog.this.layout.getForwardSetLayout().clearTableEdit();
                if (SettingDialog.this.saveSshForwards()) {
                    SettingDialog.this.dispose();
                }
            }
        });
    }

    private void appButtonListener() {
        JButton appButton = this.getAppBtn();
        appButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.layout.getForwardSetLayout().clearTableEdit();
                SettingDialog.this.applyChange();
            }
        });
    }

    private void initData() {
        List<Socks5Proxy> proxys = SettingService.getProxies();
        for (Socks5Proxy p : proxys) {
            this.layout.getTableModel().addRow(new TableRow[]{this.createRow(p)});
        }
    }

    private TableRow<Socks5Proxy, String> createRow(Socks5Proxy proxy) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getTableModel().getColumnCount(), (Object)proxy, (Object)proxy.getUuid());
        row.setValueAt(0, (Object)proxy.getName());
        row.setValueAt(1, (Object)proxy.getServerIp());
        row.setValueAt(2, (Object)proxy.getPort());
        row.setValueAt(3, (Object)proxy.getUser());
        String pass = proxy.getPass();
        if (proxy.isAuthentic() && !StringUtils.isNULLStr((String)pass)) {
            String encodePass = this.getEncodePass(pass);
            row.setValueAt(4, (Object)encodePass);
        } else {
            row.setValueAt(4, (Object)"");
        }
        return row;
    }

    private String getEncodePass(String pass) {
        StringBuffer sbPass = new StringBuffer();
        for (int index = 0; index < pass.length(); ++index) {
            sbPass.append('*');
        }
        return sbPass.toString();
    }

    private void addProxy() {
        ProxyDialog dialog = new ProxyDialog((JDialog)((Object)this), this.getProxyList());
        SwingUtil.putScreenCenter((Window)((Object)dialog));
        dialog.setModal(true);
        dialog.setVisible(true);
        if (dialog.isOkClick()) {
            Socks5Proxy proxy = dialog.getProxy();
            this.layout.getTableModel().addRow(new TableRow[]{this.createRow(proxy)});
            OperaLog operaLog = LogUtils.addOperaLogForProxy(ADD_SOCKS5, proxy.getName(), true, false);
            LOGS.add(operaLog);
            dialog.dispose();
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("add proxy name is :" + proxy.getName());
        }
    }

    private void modifyProxy() {
        List<Socks5Proxy> proxyList = this.getSelectedProxies();
        if (proxyList.size() != 1) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"prompt.socks5.modify.select.over.one"));
            return;
        }
        ProxyDialog dialog = new ProxyDialog((JDialog)((Object)this), this.getProxyList(), proxyList.get(0));
        SwingUtil.putScreenCenter((Window)((Object)dialog));
        dialog.setModal(true);
        dialog.setVisible(true);
        if (dialog.isOkClick()) {
            Socks5Proxy proxy = dialog.getProxy();
            this.layout.getTableModel().updateRow(new TableRow[]{this.createRow(proxy)});
            dialog.dispose();
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("modify proxy name is :" + proxy.getName());
            OperaLog operaLog = LogUtils.addOperaLogForProxy(MODIFY_SOCKS5, proxy.getName(), true, false);
            if (!this.isLogsContain(operaLog)) {
                LOGS.add(operaLog);
            }
        }
    }

    private boolean isLogsContain(OperaLog operaLog) {
        if (!LOGS.isEmpty()) {
            for (OperaLog log : LOGS) {
                if (!log.getDeviceNameEn().equals(operaLog.getDeviceNameEn())) continue;
                return true;
            }
        }
        return false;
    }

    private void deleteSelectedProxies() {
        List<Socks5Proxy> proxylist = this.getSelectedProxies();
        if (proxylist.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"prompt.socks5.delete.select.null"));
            return;
        }
        WarningDialog dialog = DialogUtils.showYesNoDialog((Window)((Object)this), (String)ResourceUtil.getString((String)"prompt.socks5.delete"));
        if (0 != dialog.getValue()) {
            return;
        }
        for (Socks5Proxy proxy : proxylist) {
            this.layout.getTableModel().removeRow(new TableRow[]{this.createRow(proxy)});
            SettingService.getProxies().remove(proxy);
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("delete proxy name is :" + proxy.getName());
            this.removeLog(proxy);
        }
    }

    private void removeLog(Socks5Proxy proxy) {
        OperaLog operaLog = LogUtils.addOperaLogForProxy(DELETE_SOCKS5, proxy.getName(), true, false);
        if (this.isLogsContain(operaLog) && !LOGS.isEmpty()) {
            Iterator<OperaLog> it = LOGS.iterator();
            while (it.hasNext()) {
                OperaLog log = it.next();
                if (!log.getDeviceNameEn().equals(operaLog.getDeviceNameEn())) continue;
                it.remove();
            }
        } else {
            LogUtils.addSettingLog(DELETE_SOCKS5, proxy.getName(), true, false);
        }
    }

    private List<Socks5Proxy> getSelectedProxies() {
        ArrayList<Socks5Proxy> proxyList = new ArrayList<Socks5Proxy>();
        List rowList = this.layout.getProxyTable().getMarkedRows();
        for (TableRow row : rowList) {
            proxyList.add((Socks5Proxy)row.getUserObject());
        }
        return proxyList;
    }

    private List<Socks5Proxy> getProxyList() {
        ArrayList<Socks5Proxy> proxyList = new ArrayList<Socks5Proxy>();
        for (TableRow row : this.layout.getTableModel().getAllRows()) {
            proxyList.add((Socks5Proxy)row.getUserObject());
        }
        return proxyList;
    }

    private void saveSocksProxies() {
        this.saveProxyXml();
        if (null == this.logService) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("add Socks5 OperaLog error,logService is null!");
            return;
        }
        if (null != LOGS && !LOGS.isEmpty()) {
            for (OperaLog log : LOGS) {
                this.logService.addOperaLog(log);
            }
            LOGS.clear();
        }
    }

    private void saveProxyXml() {
        SettingService.saveProxies(this.layout.getForwardSetLayout().getRouteMap(), this.getProxyList());
        if (null == this.logService) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("add SSH OperaLog error,logService is null!");
            return;
        }
        this.checkModifySSHData();
        List<OperaLog> operaLogs = this.layout.getForwardSetLayout().getAddOperaLogs();
        if (null != operaLogs && !operaLogs.isEmpty()) {
            for (OperaLog log : operaLogs) {
                this.logService.addOperaLog(log);
            }
            this.layout.getForwardSetLayout().setAddOperaLogs(new ArrayList<OperaLog>());
        }
    }

    private void checkModifySSHData() {
        KeyOrderedHashMap<String, List<MultiRouteNode>> newSSHData = this.layout.getForwardSetLayout().getRouteMap();
        KeyOrderedHashMap oldSSHData = new KeyOrderedHashMap();
        oldSSHData.putAll(this.layout.getForwardSetLayout().getTableRows());
        this.layout.getForwardSetLayout().getTableRows().clear();
        this.layout.getForwardSetLayout().getTableRows().putAll(newSSHData);
        List newkeys = newSSHData.keyList();
        List oldkeys = oldSSHData.keyList();
        for (String key : newkeys) {
            this.traversalSSHAddLogs(newSSHData, (KeyOrderedHashMap<String, List<MultiRouteNode>>)oldSSHData, oldkeys, key);
        }
    }

    private void traversalSSHAddLogs(KeyOrderedHashMap<String, List<MultiRouteNode>> newSSHData, KeyOrderedHashMap<String, List<MultiRouteNode>> oldSSHData, List<String> oldkeys, String key) {
        block0: for (String oldkey : oldkeys) {
            List newMus = (List)newSSHData.get((Object)key);
            List oldMus = (List)oldSSHData.get((Object)oldkey);
            if (oldMus.isEmpty() || !key.equals(oldkey) || newMus.size() != oldMus.size()) continue;
            int size = newMus.size();
            for (int i = 0; i < size; ++i) {
                MultiRouteNode newMu = (MultiRouteNode)newMus.get(i);
                MultiRouteNode oldMu = (MultiRouteNode)oldMus.get(i);
                boolean b = newMu.getHost().equals(oldMu.getHost()) && newMu.getPwd().equals(oldMu.getPwd()) && newMu.getUname().equals(oldMu.getUname()) && newMu.getPort() == oldMu.getPort();
                if (!b) continue block0;
            }
        }
    }

    private boolean saveSshForwards() {
        if (!this.layout.getForwardSetLayout().saveCurRouteNodes()) {
            return false;
        }
        this.saveProxyXml();
        return true;
    }

    private void applyChange() {
        int curTab = this.layout.getTabPane().getSelectedIndex();
        String title = this.layout.getTabPane().getTitleAt(curTab);
        String socksName = ResourceUtil.getString((String)"tab.socks5.title");
        String sshFwName = ResourceUtil.getString((String)"tab.sshforward.title");
        if (title.equals(socksName)) {
            this.saveSocksProxies();
        } else if (title.equals(sshFwName)) {
            this.saveSshForwards();
        }
    }
}

