/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.ui;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FsClusterNode;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.auth.OsAuthService;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.ui.OsInfoInputDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UIUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Locale;
import java.util.Observer;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsInfoInputLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(OsInfoInputLayout.class);
    private static final int TEXT_DEFAULT_LEN = 20;
    private static final Color REQUIRE_TIP_COLOR = new Color(16729404);
    private static final int USERNAME_DEFAULT_LEN = 16;
    private static final int PWD_DEFAULT_LEN = 64;
    private final JLabel symbolLabel = new JLabel("* ");
    private final JComponent userNameLabel = UIUtils.createRequiredLabel((String)(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.userName") + ":"), (boolean)true);
    private final IsmTextField userNameField = IsmTextField.getNameTextField((String)".*", (String)"", (int)16, (int)20);
    private final JComponent pwdLabel = UIUtils.createRequiredLabel((String)(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.pwd") + ":"), (boolean)true);
    private final JPasswordField pwdField = UiMethod.getPasswordField((int)20, (int)64);
    private final JLabel rootSymbolLabel = new JLabel(" ");
    private final JLabel rootPwdLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.rooPwd"));
    private final JComponent rootPwdComponent = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{this.rootSymbolLabel, this.rootPwdLabel});
    private final JPasswordField rootPwdField = UiMethod.getPasswordField((int)20, (int)64);
    private final JButton confirmBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.button.ok"), (char)'F');
    private final JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.button.cancel"), (char)'C');
    private final JLabel errorTipLabel = new JLabel();
    private final OsInfoInputDialog parentDialog;
    private JComponent rootPwdComp;

    public OsInfoInputLayout(OsInfoInputDialog osInputInputDialog) {
        this.parentDialog = osInputInputDialog;
        this.initSize();
        this.initLayout();
    }

    private void initLayout() {
        this.symbolLabel.setForeground(REQUIRE_TIP_COLOR);
        Box hTipBox = UCD.buildHBoxLeft((Component[])new Component[]{this.errorTipLabel});
        UiMethod.setComponentSize((Dimension)new Dimension(400, 20), (Component[])new Component[]{hTipBox});
        Box userNameComp = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(20), this.userNameLabel, this.userNameField});
        Box pwdComp = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(20), this.pwdLabel, this.pwdField});
        this.initRootPwdComp();
        Box vContextBox = UCD.buildVBoxTop((int)10, (Component[])new Component[]{hTipBox, userNameComp, pwdComp, this.rootPwdComp, UCD.buildHBoxLeft((int)30, (Component[])new Component[]{Box.createHorizontalStrut(70), this.confirmBtn, this.cancelBtn})});
        this.add(vContextBox);
    }

    private void initRootPwdComp() {
        this.rootPwdComp = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(20), this.rootPwdComponent, this.rootPwdField});
    }

    private void setComponentSameMaxWidthSize(JComponent ... comps) {
        Dimension maxSize = null;
        for (JComponent comp : comps) {
            if (null == maxSize) {
                maxSize = comp.getMaximumSize();
            }
            if (maxSize.width >= comp.getMaximumSize().width) continue;
            maxSize = comp.getMaximumSize();
        }
        for (JComponent com : comps) {
            UiMethod.setComponentSize((Dimension)maxSize, (Component[])new Component[]{com});
        }
    }

    private void initSize() {
        this.userNameField.setColumns(20);
        this.pwdField.setColumns(20);
        this.rootPwdField.setColumns(20);
        this.setComponentSameMaxWidthSize(this.userNameLabel, this.pwdLabel, this.rootPwdLabel);
        OsInfoInputLayout.setComponentSize(this.symbolLabel, new Dimension(10, 20));
        OsInfoInputLayout.setComponentSize(this.rootSymbolLabel, new Dimension(10, 20));
        Dimension rootLabelSize = this.rootPwdLabel.getMaximumSize();
        int width = (int)rootLabelSize.getWidth();
        int height = (int)rootLabelSize.getHeight();
        Dimension rootLabelCompSize = new Dimension(width + 22, height);
        UiMethod.setComponentSize((Dimension)rootLabelCompSize, (Component[])new Component[]{this.rootPwdComponent});
        UiMethod.setComponentSize((Dimension)rootLabelCompSize, (Component[])new Component[]{this.userNameLabel, this.pwdLabel});
    }

    private static void setComponentSize(JComponent comp, Dimension size) {
        comp.setPreferredSize(size);
        comp.setMinimumSize(size);
        comp.setMaximumSize(size);
        comp.setSize(size);
    }

    public void bindListener(List<FsClusterNode> selectNodes, Observer authObserver) {
        this.bindBtnListener(selectNodes, authObserver);
        this.bindFieldListener();
    }

    private void bindFieldListener() {
        this.pwdField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                OsInfoInputLayout.this.showNotRootTipJudge();
            }
        });
        this.userNameField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                OsInfoInputLayout.this.showNotRootTipJudge();
            }
        });
        this.pwdField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                OsInfoInputLayout.this.showNotRootTipJudge();
            }
        });
        this.rootPwdField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                OsInfoInputLayout.this.showNotRootTipJudge();
            }
        });
        this.userNameField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                OsInfoInputLayout.this.showNotRootTipJudge();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                OsInfoInputLayout.this.showNotRootTipJudge();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OsInfoInputLayout.this.showNotRootTipJudge();
            }
        });
    }

    private void bindBtnListener(List<FsClusterNode> selectNodes, Observer authObserver) {
        this.cancelBtn.addActionListener(e -> this.cancelAction());
        this.confirmBtn.addActionListener(e -> this.doAuth(selectNodes, authObserver));
    }

    private void doAuth(List<FsClusterNode> selectNodes, Observer authObserver) {
        if (this.checkInput()) {
            return;
        }
        this.parentDialog.dispose();
        OsAuthService osAuthService = this.buildAuthService(selectNodes, authObserver);
        osAuthService.doAuthAsync();
    }

    private boolean checkInput() {
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.isNULLStr((String)this.userNameField.getText())) {
            errorMsg.append(ResourceUtil.getString((String)"user.empty"));
        }
        this.checkPassword(errorMsg);
        this.checkRootPassword(errorMsg);
        if (!errorMsg.toString().isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this.parentDialog, (String)errorMsg.toString());
            return true;
        }
        return false;
    }

    private void checkRootPassword(StringBuilder errorMsg) {
        if (!this.rootPwdComp.isEnabled() || !this.rootPwdComp.isVisible()) {
            return;
        }
        char[] rootPassword = this.rootPwdField.getPassword();
        if (rootPassword == null || rootPassword.length == 0) {
            errorMsg.append(System.lineSeparator()).append(ResourceUtil.getString((String)"root.password.empty"));
        }
    }

    private void checkPassword(StringBuilder errorMsg) {
        char[] password = this.pwdField.getPassword();
        if (password == null || password.length == 0) {
            errorMsg.append(System.lineSeparator()).append(ResourceUtil.getString((String)"password.empty"));
        }
    }

    @NotNull
    private OsAuthService buildAuthService(List<FsClusterNode> selectNodes, Observer authObserver) {
        selectNodes.forEach(selectNode -> selectNode.setOsNode(this.buildOsDevNode((FsClusterNode)((Object)selectNode))));
        return new OsAuthService(selectNodes, authObserver);
    }

    public DevNode buildOsDevNode(FsClusterNode selectNode) {
        DevNode osNode = new DevNode();
        osNode.setIp(selectNode.getManagementIp());
        osNode.setLoginUser(this.getLoginUser());
        this.getRootUser().ifPresent(arg_0 -> ((DevNode)osNode).setRootUser(arg_0));
        osNode.setDeviceSerialNumber(selectNode.getSerialNumber());
        return osNode;
    }

    private Optional<User> getRootUser() {
        String userName = this.userNameField.getText();
        if (!this.isRootUser(userName)) {
            return Optional.of(new User("root", Base64EncodeUtils.encode((String)String.valueOf(this.rootPwdField.getPassword()))));
        }
        return Optional.empty();
    }

    @NotNull
    private User getLoginUser() {
        return new User(this.userNameField.getText(), String.valueOf(this.pwdField.getPassword()));
    }

    private boolean isRootUser(String userName) {
        return "root".equals(userName);
    }

    private void cancelAction() {
        this.parentDialog.setVisible(false);
        this.parentDialog.dispose();
    }

    private void showNotRootTipJudge() {
        this.showNotRootTip(this.shouldShowNotRootTip());
        this.shouldShowRootPwdComp();
    }

    private boolean shouldShowNotRootTip() {
        String userName = this.userNameField.getText();
        String rootPwd = String.valueOf(this.rootPwdField.getPassword());
        if (StringUtils.isNULLStr((String)userName)) {
            return false;
        }
        return this.isRootUserServer(userName, rootPwd);
    }

    private boolean isRootUserServer(String userName, String rootPwd) {
        if (!"root".equalsIgnoreCase(userName.toLowerCase(Locale.ENGLISH))) {
            return "".equals(rootPwd);
        }
        return false;
    }

    private void showNotRootTip(boolean isShow) {
        this.errorTipLabel.setForeground(Color.RED);
        this.rootSymbolLabel.setForeground(REQUIRE_TIP_COLOR);
        String errTip = this.errorTipLabel.getText();
        if (isShow) {
            this.errorTipLabel.setText(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.os.notroot.tip"));
            this.errorTipLabel.setToolTipText(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.os.notroot.tip"));
            this.rootSymbolLabel.setText("*");
        } else if (errTip.equals(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.os.notroot.tip"))) {
            this.setErrorTipLabelFalse();
        } else {
            log.info("ui not change");
        }
    }

    private void setErrorTipLabelFalse() {
        this.errorTipLabel.setText("");
        this.errorTipLabel.setToolTipText("");
        this.rootSymbolLabel.setText("");
    }

    private void shouldShowRootPwdComp() {
        this.rootPwdComp.setVisible(!"root".equalsIgnoreCase(this.userNameField.getText().toLowerCase(Locale.ENGLISH)));
    }
}

