/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.former;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendNodeSaveUtil {
    private static final Logger log = LoggerFactory.getLogger(ExtendNodeSaveUtil.class);
    public static final String TO_BOX_DEVICE_FILE = String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "temp", "sceneTemplates", "to_box_device_file.json");
    public static final String TO_PREPARE_FILE = String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "temp", "sceneTemplates", "to_prepare_file.json");
    private static final String EXTEND_FILE_PATH = String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "temp", "sceneTemplates", "extendNodesInfos.json");

    public static void writeNodeExtendInfo(String jsonObj, String saveFile) {
        File file = new File(saveFile);
        try {
            FileUtils.write((File)file, (CharSequence)jsonObj, (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            log.error("write extend nodes error, extendNodesInfos file not exists");
        }
        catch (IOException e) {
            log.error("write extend nodes info error", (Throwable)e);
        }
    }

    public static void writeNodeExtendInfo(String jsonObj) {
        ExtendNodeSaveUtil.writeNodeExtendInfo(jsonObj, EXTEND_FILE_PATH);
    }

    public static List<FsDevNode> readExtendNodeInfoFromFile() {
        return ExtendNodeSaveUtil.readExtendNodeInfoFromFile(new TypeReference<List<FsDevNode>>(){}, Collections.emptyList());
    }

    public static <T> T readExtendNodeInfoFromFile(TypeReference<T> reference, T defaultValue, String filePath) {
        File file = new File(filePath);
        try {
            String nodesJson = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            return (T)JSON.parseObject((String)nodesJson, reference, (Feature[])new Feature[0]);
        }
        catch (FileNotFoundException e) {
            log.error("read extend nodes error, extendNodesInfos file not exists");
        }
        catch (IOException e) {
            log.error("read extend nodes info error", (Throwable)e);
        }
        return defaultValue;
    }

    public static <T> T readExtendNodeInfoFromFile(TypeReference<T> reference, T defaultValue) {
        return ExtendNodeSaveUtil.readExtendNodeInfoFromFile(reference, defaultValue, EXTEND_FILE_PATH);
    }

    public static boolean isExistExtendFile(String filePath) {
        return new File(filePath).exists();
    }

    public static boolean deleteExtendFile(String filePath) {
        return new File(filePath).delete();
    }
}

