/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.former;

import com.huawei.ism.tool.devicemanager.ui.former.DeviceSaveServiceFactory;
import com.huawei.ism.tool.devicemanager.ui.former.service.NodeSceneOptionService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDeviceData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFormer {
    private static final Logger log = LoggerFactory.getLogger(XmlFormer.class);

    public List<Map<String, String>> injectDeviceData(List<DevNode> devs) {
        log.info("start to inject devie data ..., node size :{}", (Object)devs.size());
        Optional<NodeSceneOptionService<?>> nodeService = DeviceSaveServiceFactory.buildServiceByScene();
        if (nodeService.isPresent()) {
            return XmlFormer.saveWithService(devs, nodeService.get());
        }
        nodeService = DeviceSaveServiceFactory.buildServiceByEnvScene();
        if (nodeService.isPresent()) {
            return XmlFormer.saveWithService(devs, nodeService.get());
        }
        return SceneDeviceData.injectDeviceData(devs);
    }

    @Nullable
    private static List<Map<String, String>> saveWithService(List<DevNode> devs, NodeSceneOptionService<?> nodeService) {
        log.info("save extend info for :{} nodes", (Object)devs.stream().map(DevNode::getIp).collect(Collectors.joining(",")));
        nodeService.saveExtend(devs);
        return SceneDeviceData.injectDeviceData(nodeService.transToSaveInXmlNode(devs));
    }
}

