/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.former.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.former.ExtendNodeSaveUtil;
import com.huawei.ism.tool.devicemanager.ui.former.service.NodeSceneOptionService;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceSceneDeviceImpl
implements NodeSceneOptionService<FsDevNode> {
    private static final Logger log = LoggerFactory.getLogger(ReplaceSceneDeviceImpl.class);

    @Override
    public void saveExtend(List<DevNode> devNodes) {
        List<FsDevNode> fsNodes = devNodes.stream().map(node -> DefaultNodeProviderImpl.getInstance().findDevNode(node.getDeviceSerialNumber())).filter(Objects::nonNull).filter(FsDevNode.class::isInstance).map(FsDevNode.class::cast).collect(Collectors.toList());
        ExtendNodeSaveUtil.writeNodeExtendInfo(JSON.toJSONString(this.buildDumpParam(fsNodes)));
    }

    private List<Map<String, Object>> buildDumpParam(List<FsDevNode> fsNodes) {
        return fsNodes.stream().map(this::buildOneNodeParam).collect(Collectors.toList());
    }

    private Map<String, Object> buildOneNodeParam(FsDevNode fsDevNode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildFollowNode(fsDevNode, param);
        param.put("ip", fsDevNode.getIp());
        param.put("haModel", fsDevNode.getHaModel());
        param.put("deviceSerialNumber", fsDevNode.getDeviceSerialNumber());
        param.put("storageVersion", fsDevNode.getStorageVersion());
        param.put("clusterNodes", this.buildClusterNodes(fsDevNode.getClusterNodes()));
        return param;
    }

    private void buildFollowNode(FsDevNode fsDevNode, Map<String, Object> param) {
        if (Objects.nonNull(fsDevNode.getPriFsDevNode())) {
            param.put("priFsDevNode", this.buildNodeIfExists((com.huawei.ism.tool.obase.entity.DevNode)fsDevNode.getPriFsDevNode()));
        }
        if (Objects.nonNull(fsDevNode.getStandbyDevNode())) {
            param.put("standbyDevNode", this.buildNodeIfExists((com.huawei.ism.tool.obase.entity.DevNode)fsDevNode.getStandbyDevNode()));
        }
    }

    @NotNull
    private List<Map<String, Object>> buildClusterNodes(List<ClusterNode> clusterNodes) {
        if (CollectionUtil.isEmpty(clusterNodes)) {
            return Collections.emptyList();
        }
        return clusterNodes.stream().map(this::buildClusterNodeParam).collect(Collectors.toList());
    }

    private Map<String, Object> buildClusterNodeParam(ClusterNode node) {
        HashMap<String, Object> clusterParam = new HashMap<String, Object>();
        clusterParam.put("managementIp", node.getManagementIp());
        clusterParam.put("roles", node.getRoles());
        clusterParam.put("serialNumber", node.getSerialNumber());
        clusterParam.put("deviceType", node.getDeviceType());
        clusterParam.put("name", node.getName());
        clusterParam.put("deviceId", node.getDeviceId());
        if (Objects.nonNull(node.getOsNode())) {
            clusterParam.put("osNode", this.buildNodeIfExists(node.getOsNode()));
        }
        return clusterParam;
    }

    private Map<String, Object> buildNodeIfExists(com.huawei.ism.tool.obase.entity.DevNode node) {
        HashMap<String, Object> nodeParam = new HashMap<String, Object>();
        nodeParam.put("ip", node.getIp());
        nodeParam.put("deviceSerialNumber", node.getDeviceSerialNumber());
        nodeParam.put("loginUser", this.buildEncryptUser(node.getLoginUser()));
        nodeParam.put("rootUser", this.buildEncryptUser(node.getRootUser()));
        nodeParam.put("deviceName", node.getDeviceName());
        return nodeParam;
    }

    private Map<String, Object> buildEncryptUser(User user) {
        if (Objects.isNull(user)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> userParam = new HashMap<String, Object>();
        userParam.put("username", user.getUserName());
        userParam.put("password", user.getEcptPassword());
        return userParam;
    }

    @Override
    public List<FsDevNode> readExtend() {
        return ExtendNodeSaveUtil.readExtendNodeInfoFromFile(new TypeReference<List<FsDevNode>>(){}, Collections.emptyList());
    }

    @Override
    public List<DevNode> buildPrepareShowNode(List<DevNode> devNodes) {
        return devNodes;
    }

    @Override
    public VerifyResult verifyNodeAdd(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return new VerifyResult();
    }

    @Override
    public List<DevNode> transToSaveInXmlNode(List<DevNode> selectNodes) {
        return selectNodes;
    }

    @Override
    public String getPrepareHelpDocFileName() {
        return String.join((CharSequence)File.separator, "SencePrepare", "Prepare");
    }
}

