/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductParser {
    private static ProductParser instance;
    private static final String DEBUG_CONFIG_PATH = "config/products.xml";
    private static Map<String, String> configs;
    private static final String PRODUCT_NODE_NAME = "product";
    private static final String PRODUCT_MODE_NODE_NAME = "productname";
    private static final String SUPPORT_NODE_NAME = "supporttypes";
    private Element root = null;

    public ProductParser() {
        this.initDocument();
    }

    public ProductParser(String path) {
        this.initDoc(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDoc(String path) {
        InputStream in = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl == null) {
                throw new NullPointerException("Classloader is null");
            }
            in = cl.getResourceAsStream(path);
            Document document = XmlUtils.parseDocument((InputStream)in);
            this.root = document.getDocumentElement();
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(null, in);
            throw throwable;
        }
        StreamUtils.closeStream(null, (InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductParser getInstance() {
        Class<ProductParser> clazz = ProductParser.class;
        synchronized (ProductParser.class) {
            if (instance == null) {
                instance = new ProductParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDevNeedDbgPsd(DevNode node) {
        Class<ProductParser> clazz = ProductParser.class;
        synchronized (ProductParser.class) {
            if (configs == null) {
                configs = ProductParser.getInstance().parse();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (node == null || node.getProductVersion() == null || node.getDeviceType() == null) {
                return false;
            }
            if (!StringUtils.isNULLStr((String)node.getDeveloperPwd())) {
                return false;
            }
            String devType = node.getDeviceType().toString();
            String devVersion = node.getProductVersion();
            return ProductParser.checkDevVer(devType, devVersion);
        }
    }

    private static boolean checkDevVer(String devType, String devVersion) {
        try {
            for (Map.Entry<String, String> entry : configs.entrySet()) {
                if (!ProductParser.checkDevVerLoop(entry, devType, devVersion)) continue;
                return true;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static boolean checkDevVerLoop(Map.Entry<String, String> entry, String devType, String devVersion) {
        if (entry.getKey().equals(devType)) {
            String[] vers;
            String val = entry.getValue();
            for (String ver : vers = val == null ? new String[]{} : val.split(",")) {
                if (!devVersion.contains(ver)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDocument() {
        InputStream in = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl == null) {
                throw new NullPointerException("Classloader is null");
            }
            in = cl.getResourceAsStream(DEBUG_CONFIG_PATH);
            Document document = XmlUtils.parseDocument((InputStream)in);
            this.root = document.getDocumentElement();
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(null, in);
            throw throwable;
        }
        StreamUtils.closeStream(null, (InputStream)in);
    }

    public Map<String, String> parse() {
        KeyOrderedHashMap infoMap = new KeyOrderedHashMap();
        if (this.root == null) {
            return null;
        }
        Collection products = XmlUtils.getChildren((Element)this.root, (String)PRODUCT_NODE_NAME);
        for (Element product : products) {
            this.parseProduct(product, (Map<String, String>)infoMap);
        }
        return infoMap;
    }

    private void parseProduct(Element product, Map<String, String> infoMap) {
        Element modelNode = XmlUtils.getChild((Element)product, (String)PRODUCT_MODE_NODE_NAME);
        String model = modelNode.getFirstChild().getTextContent();
        Element supportNode = XmlUtils.getChild((Element)product, (String)SUPPORT_NODE_NAME);
        String supports = supportNode.getFirstChild().getTextContent();
        infoMap.put(model, supports);
    }
}

