/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.utils.StarterType;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class WwnUtil {
    public static final String ERR_MEG = "queryWwnSuccess";
    public static final String TASK_FUTURE = "taskFuture";
    public static final String ERR_MEG_FAILED = "unknown";
    public static final String RESULT_MEG = "wwnCliRets";
    public static final String CHANGE_LINE = "\n";
    public static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED";
    public static final String COMMAND_FAILED = "not found";
    public static final String PERMISSION_INSUFFICIENT = "Permission";
    private static final int COMMAND_MARK = 0;
    private static final int KEY_WORD_MARK = 1;
    private static final int REGULAR_MARK = 2;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(WwnUtil.class);

    public static void getAluaWwn(ICliConnection con, Map<StarterType, List<String>> wwnCommandMap, Launcher launcher, StringBuffer resultCollect) {
        for (Map.Entry<StarterType, List<String>> entry : wwnCommandMap.entrySet()) {
            String result;
            List<String> value;
            block6: {
                value = entry.getValue();
                String command = value.get(0);
                result = null;
                try {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Start send command:" + command);
                    }
                    result = con.execCmd(command);
                    result = Normalizer.normalize(result, Normalizer.Form.NFKC);
                    resultCollect.append(result + CHANGE_LINE);
                    if (WwnUtil.checkResultFailed(result, entry.getKey())) {
                        WwnUtil.setFailedInLauncher(launcher);
                    }
                    break block6;
                }
                catch (ToolException e) {
                    LOGGER.error("execCmd happened ToolException\uff1a" + command, (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error("execCmd happened Exception\uff1a" + command, (Throwable)e);
                }
                continue;
            }
            WwnUtil.extractWwn(launcher, entry, value, result);
        }
    }

    public static boolean checkResultFailed(String result, StarterType starterType) {
        String normalizedResult = Normalizer.normalize(result, Normalizer.Form.NFKC);
        return StringUtils.isNULLStr((String)normalizedResult) || normalizedResult.contains("TOOLKIT_SEND_CMD_TIME_OUT") || normalizedResult.contains(EXE_FAILED) || normalizedResult.contains(PERMISSION_INSUFFICIENT) || normalizedResult.contains(COMMAND_FAILED) && starterType != StarterType.IB;
    }

    public static void setResult2Launcher(Launcher launcher, StringBuffer resultCollect) {
        launcher.getOtherDataMap().put(RESULT_MEG, resultCollect.toString());
    }

    private static void extractWwn(Launcher launcher, Map.Entry<StarterType, List<String>> entry, List<String> value, String result) {
        String[] splitResult;
        for (String everyResult : splitResult = result.split(CHANGE_LINE)) {
            if (!everyResult.contains(value.get(1))) continue;
            Pattern p = Pattern.compile(value.get(2));
            Matcher m = p.matcher(everyResult.toLowerCase(Locale.ENGLISH));
            block7: while (m.find()) {
                String wwn = m.group().toUpperCase(Locale.ENGLISH).trim();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("get wwn success:" + wwn);
                }
                switch (entry.getKey()) {
                    case FC: {
                        launcher.getFcWwns().add(wwn);
                        continue block7;
                    }
                    case ISCSI: {
                        launcher.getiSCSIWwns().add(wwn);
                        continue block7;
                    }
                    case IB: {
                        launcher.getIBWwns().add(wwn);
                        continue block7;
                    }
                    case NVME: {
                        launcher.getNVMEWwns().add(wwn);
                        continue block7;
                    }
                }
                LOGGER.error("The Alue wwn map key is error.");
            }
        }
    }

    public static void setFailedInLauncher(Launcher launcher) {
        launcher.getOtherDataMap().put(ERR_MEG, ERR_MEG_FAILED);
    }

    public static void setSuccessInLauncher(Launcher launcher) {
        launcher.getOtherDataMap().put(ERR_MEG, Boolean.TRUE);
    }

    public static void checkGetWwnExecutionResults(Launcher launcher) {
        if (launcher.getFcWwns().isEmpty() || launcher.getiSCSIWwns().isEmpty()) {
            WwnUtil.setFailedInLauncher(launcher);
        }
    }

    public static void buildWwnData(Map<StarterType, List<String>> hashMap, StarterType starterType, String command, String keyWord, String RegExp) {
        ArrayList<String> wwnList = new ArrayList<String>();
        wwnList.add(command);
        wwnList.add(keyWord);
        wwnList.add(RegExp);
        hashMap.put(starterType, wwnList);
    }
}

