/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.ism.tool.base.context.EncryptContext;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.crypto.AesCrypterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AESEncrypt {
    private static final Logger log = LoggerFactory.getLogger(AESEncrypt.class);
    private static final AesCrypterManager CRYPTER_BASE_MANAGER = EncryptContext.getInstance().getAnyEncryptManager();

    private AESEncrypt() {
    }

    @Deprecated
    public static String encrypt(String content, String password) {
        return AESEncrypt.encrypt(content);
    }

    public static String encrypt(String content) {
        String result = "";
        if (StringUtils.isNULLStr(content)) {
            return result;
        }
        try {
            result = CRYPTER_BASE_MANAGER.performEncrypt(content);
        }
        catch (ProcessEncryptException e) {
            log.error("Failed to encrypt,", (Throwable)e);
        }
        return result;
    }

    @Deprecated
    public static String decrypt(String content, String password) {
        return AESEncrypt.decrypt(content);
    }

    public static String decrypt(String content) {
        if (StringUtils.isNULLStr(content)) {
            return content;
        }
        String result = "";
        try {
            result = CRYPTER_BASE_MANAGER.performDecrypt(content);
        }
        catch (ProcessEncryptException e) {
            log.error("decrypt error", (Throwable)e);
        }
        return result;
    }

    @Deprecated
    public static String encrypt128(String content, String password) {
        return AESEncrypt.encrypt(content);
    }

    @Deprecated
    public static String encrypt128(String content) {
        return AESEncrypt.encrypt(content);
    }
}

