/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.ThreadPool;
import com.huawei.ism.tool.framework.platform.common.toolbox.IStartBsChangeListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OSCmdUtils {
    private static final Logger log = LoggerFactory.getLogger(OSCmdUtils.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(OSCmdUtils.class);
    private static final int DEFAULT_CMD_TIMEOUT = 60;
    private static final int DEFAULT_FUTURE_TIMEOUT = 3;
    private static final int DEFAULT_DELETEBAT_TIME = 1000;
    public static final String ENTER = System.getProperty("line.separator");
    private static final String BIT_64 = "64";
    private static final String BIT_32 = "32";
    private static final String YES = "YES";
    private static final String NO = "NO";
    private static final String FREEMEMORY_MARK = "FreePhysicalMemory=";
    private static final String FREEMEMORY_DEFAULT = "5000";

    private OSCmdUtils() {
    }

    public static Process createCmdProcess(String ... cmds) throws IOException {
        if (cmds.length > 1) {
            return Runtime.getRuntime().exec(cmds);
        }
        return Runtime.getRuntime().exec(cmds[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static Process createCmdProcess(String cmd, String workpath) throws IOException {
        void var6_10;
        String[] cmdArr = cmd.split("\r\n");
        ArrayList<String> envLst = new ArrayList<String>();
        ArrayList<String> cmdLst = new ArrayList<String>();
        cmdLst.add("cmd.exe");
        cmdLst.add("/c");
        File workDir = null;
        if (!StringUtils.isNULLObjectOrNullStr(workpath)) {
            String string = ApplicationContext.getInstance().getWorkPath();
            workDir = new File(string, workpath);
        }
        for (String cmdStr : cmdArr) {
            if ((cmdStr = cmdStr.trim()).startsWith("set")) {
                envLst.add(cmdStr.substring(4));
                continue;
            }
            if (StringUtils.isNULLObjectOrNullStr(cmdStr)) continue;
            cmdLst.add(cmdStr);
        }
        cmdArr = cmdLst.toArray(new String[cmdLst.size()]);
        Object var6_8 = null;
        if (!envLst.isEmpty()) {
            String[] stringArray = envLst.toArray(new String[envLst.size()]);
        }
        return Runtime.getRuntime().exec(cmdArr, (String[])var6_10, workDir);
    }

    public static String executeCmd(String cmd) {
        return OSCmdUtils.executeCmd(cmd, 60);
    }

    public static String executeCmd(String cmd, int timeoutSecond) {
        return OSCmdUtils.executeCmd(cmd, null, timeoutSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeCmd(String cmd, String workPath, int timeoutSecond) {
        String normalizedCmd = Normalizer.normalize(cmd, Normalizer.Form.NFKC);
        String result = "";
        Process pro = null;
        try {
            pro = StringUtils.isNULLObjectOrNullStr(workPath) ? OSCmdUtils.createCmdProcess(normalizedCmd) : OSCmdUtils.createCmdProcess(normalizedCmd, workPath);
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(pro, true);
            streamClear.setCmd(normalizedCmd);
            Future<String> future = ThreadPool.getInstance().submit(streamClear);
            result = future.get(timeoutSecond, TimeUnit.SECONDS);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("start Result => " + result);
            }
        }
        catch (Exception e1) {
            LOGGER.error("Clear cmd output stream error :", (Throwable)e1);
        }
        finally {
            if (null != pro) {
                pro.destroy();
            }
        }
        return result;
    }

    public static void closeProcess(Process pro) {
        if (null != pro) {
            try {
                pro.destroy();
            }
            catch (Exception t) {
                LOGGER.error("proc destroy error", (Throwable)t);
            }
        }
    }

    public static String executeCmdInOsPath(String cmd, int timeoutSecond) {
        String actualCmd = Normalizer.normalize(cmd, Normalizer.Form.NFKC);
        String result = "";
        String[] commands = new String[]{"cmd.exe", "/C", actualCmd};
        Process pro = null;
        try {
            pro = OSCmdUtils.createCmdProcess(commands);
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(pro, true);
            streamClear.setCmd(actualCmd);
            Future<String> future = ThreadPool.getInstance().submit(streamClear);
            result = future.get(timeoutSecond, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            LOGGER.error("Clear ins error :", (Throwable)e1);
        }
        return result;
    }

    public static String executeCmdOnWindowsNoNorMal(String cmd, String[] evnp, String path, int timeoutSecond) {
        return OSCmdUtils.exeCmd(cmd, evnp, path, timeoutSecond);
    }

    public static String executeCmdOnWindows(String cmd, String[] evnp, String path, int timeoutSecond) {
        return OSCmdUtils.exeCmd(Normalizer.normalize(cmd, Normalizer.Form.NFKC), evnp, path, timeoutSecond);
    }

    public static String exeCmd(String cmd, String[] evnp, String path, int timeoutSecond) {
        String result = "";
        String[] commands = new String[]{"cmd.exe", "/C", cmd};
        Process pro = null;
        try {
            pro = !StringUtils.isNULLObjectOrNullStr(path) && new File(path).exists() ? Runtime.getRuntime().exec(commands, evnp, new File(path)) : Runtime.getRuntime().exec(commands, evnp);
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(pro, true);
            streamClear.setCmd(cmd);
            Future<String> future = ThreadPool.getInstance().submit(streamClear);
            result = future.get(timeoutSecond, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            LOGGER.error("Clear ins error :", (Throwable)e1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeCmdInPathByBatStart(String cmdLine, String path) {
        String toolkitPath = ApplicationContext.getInstance().getWorkPath();
        String tmpPath = OSCmdUtils.getBatPath();
        File tmpBat = new File(tmpPath);
        if (!OSCmdUtils.createBatFile(tmpBat)) {
            LOGGER.error("create bat file failed," + tmpBat);
            return "";
        }
        BufferedWriter bwr = null;
        try {
            bwr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpBat), Charset.defaultCharset()));
            if (path.indexOf(58) > 0) {
                bwr.write(path.substring(0, 2));
                bwr.newLine();
                bwr.write("cd " + OSCmdUtils.quote(path));
            } else {
                bwr.write(toolkitPath.substring(0, 2));
                bwr.newLine();
                bwr.write("cd " + OSCmdUtils.quote(toolkitPath + File.separator + path));
            }
            bwr.newLine();
            bwr.write(cmdLine);
            bwr.newLine();
        }
        catch (IOException e) {
            String deleted2;
            try {
                LOGGER.error("Failed to create bat for " + OSCmdUtils.quote(StringUtils.maskPassword(cmdLine)), (Throwable)e);
                if (tmpBat.exists()) {
                    boolean deleted2 = tmpBat.delete();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Delete file result: " + deleted2);
                    }
                }
                deleted2 = "";
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(bwr, bwr);
                throw throwable;
            }
            StreamUtils.closeResource(bwr, bwr);
            return deleted2;
        }
        StreamUtils.closeResource(bwr, bwr);
        File jreDir = new File("jre");
        String java = jreDir.exists() ? (toolkitPath + File.separator + "jre\\bin\\java").replace(" ", "\" \"") : "java";
        String tmpBatCmdPath = (toolkitPath + File.separator + tmpPath).replace(" ", "\" \"");
        String out = OSCmdUtils.exeStartCmd(tmpBatCmdPath, java);
        if (StringUtils.isNULLStr(out)) {
            LOGGER.info("out is null");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Executed command " + OSCmdUtils.quote(StringUtils.maskPassword(cmdLine)) + " in dir " + OSCmdUtils.quote(path));
        }
        OSCmdUtils.clearBatFile(tmpBat);
        return out;
    }

    private static String exeStartCmd(String tmpPath, String java) {
        String executorJarPath = (ApplicationContext.getInstance().getWorkPath() + "\\lib\\executor.jar").replaceAll(" ", "\" \"");
        return OSCmdUtils.executeCmd("CMD /C " + java + " -jar " + executorJarPath + " " + tmpPath);
    }

    private static void clearBatFile(File tmpBat) {
        boolean flag = true;
        try {
            Thread.sleep(1000L);
            flag = tmpBat.delete();
            if (!flag) {
                Thread.sleep(100L);
                flag = tmpBat.delete();
                if (!flag) {
                    ToolLoggerFactory.getLogger(OSCmdUtils.class).error("delete tmpBat error.");
                    Thread thread = new Thread(new DeleteBatFileThread(tmpBat));
                    thread.setName("Delete BatFile Thread");
                    thread.setUncaughtExceptionHandler((thd, throwable) -> LOGGER.error("thread {} execute error.", (Object)thread.getName(), (Object)throwable));
                    Runtime.getRuntime().addShutdownHook(thread);
                }
            } else {
                ToolLoggerFactory.getLogger(OSCmdUtils.class).info("delete tmpBat success.");
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(OSCmdUtils.class).error("delete tmpBat error.", (Throwable)e);
            Thread thread = new Thread(new DeleteBatFileThread(tmpBat));
            thread.setName("Delete BatFile Thread");
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOGGER.error("Uncaught sub thread error: ", e);
                }
            });
            Runtime.getRuntime().addShutdownHook(thread);
        }
    }

    public static String executeCmdInPath(String cmdLine, String path) {
        return OSCmdUtils.executeCmdInPathByBatStart(cmdLine, path);
    }

    public static String executeBsCmd(String cmdLine, String path) {
        return OSCmdUtils.executebSCmdByBatStart(cmdLine, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executebSCmdByBatStart(String bsCmd, String bsPath) {
        ApplicationContext context = ApplicationContext.getInstance();
        String toolkitPath = context.getWorkPath();
        String tmpPath = OSCmdUtils.getBatPath();
        File tmpBat = new File(tmpPath);
        if (!OSCmdUtils.createBatFile(tmpBat)) {
            LOGGER.error("create bat file failed," + tmpBat);
            return "";
        }
        BufferedWriter bwr = null;
        try {
            bwr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpBat), Charset.defaultCharset()));
            if (bsPath.indexOf(58) > 0) {
                bwr.write(bsPath.substring(0, 2));
                bwr.newLine();
                bwr.write("cd " + OSCmdUtils.quote(bsPath));
            } else {
                bwr.write(toolkitPath.substring(0, 2));
                bwr.newLine();
                bwr.write("cd " + OSCmdUtils.quote(toolkitPath + File.separator + bsPath));
            }
            bwr.newLine();
            bwr.write(bsCmd);
            bwr.newLine();
        }
        catch (IOException e) {
            String deleted2;
            try {
                LOGGER.error("Failed to create bat for " + OSCmdUtils.quote(StringUtils.maskPassword(bsCmd)), (Throwable)e);
                if (tmpBat.exists()) {
                    boolean deleted2 = tmpBat.delete();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Delete file result: " + deleted2);
                    }
                }
                deleted2 = "";
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(bwr, bwr);
                throw throwable;
            }
            StreamUtils.closeResource(bwr, bwr);
            return deleted2;
        }
        StreamUtils.closeResource(bwr, bwr);
        File jreDir = new File("jre");
        String java = jreDir.exists() ? (toolkitPath + File.separator + "jre\\bin\\java").replace(" ", "\" \"") : "java";
        String tmpBatCmdPath = (toolkitPath + File.separator + tmpPath).replace(" ", "\" \"");
        String out = OSCmdUtils.exeStartbSCmd(tmpBatCmdPath, java);
        if (StringUtils.isNULLStr(out)) {
            LOGGER.info("result is empty.");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Executed command " + OSCmdUtils.quote(StringUtils.maskPassword(bsCmd)) + " in dir " + OSCmdUtils.quote(bsPath));
        }
        OSCmdUtils.clearBatFile(tmpBat);
        return out;
    }

    private static String exeStartbSCmd(String tmpBatCmdPath, String java) {
        return OSCmdUtils.executeCmd("CMD /C  " + tmpBatCmdPath, 120);
    }

    private static String getBatPath() {
        String execCmdBat = "execCmd" + System.currentTimeMillis() + ".bat";
        String execCmdTemp = "stattemp";
        String execCmdBatOther = execCmdTemp + File.separator + execCmdBat;
        if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
            FileUtils.createDir(execCmdTemp);
            return execCmdBatOther;
        }
        return execCmdBat;
    }

    private static boolean createBatFile(File tmpBat) {
        try {
            if (tmpBat.exists() && !tmpBat.delete()) {
                LOGGER.error("file exist and delete error!" + tmpBat);
            }
            if (!tmpBat.createNewFile()) {
                if (!tmpBat.createNewFile()) {
                    LOGGER.error("create bat file failed.");
                    return false;
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("create bat file success," + tmpBat);
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("create bat file success," + tmpBat);
            }
        }
        catch (Exception e) {
            LOGGER.error("create bat file failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static String quote(String str) {
        return "\"" + str + "\"";
    }

    public static void openHelpFileInCHM(File file) {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            OSCmdUtils.explorerFile(file);
        } else {
            OSCmdUtils.explorerFile(OSCmdUtils.selectFileToOpenInLinux(file));
        }
    }

    public static boolean explorerFile(File file) {
        if (Objects.isNull(file)) {
            log.error("file is empty.");
            return false;
        }
        if (ApplicationContext.getInstance().isWindowsOS()) {
            try {
                OSCmdUtils.exeExportFile(file.getCanonicalPath());
            }
            catch (IOException e) {
                log.error("get canonical path: {} exception: ", (Object)file.getPath(), (Object)e);
                return false;
            }
            return true;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop dp = Desktop.getDesktop();
                if (null != dp && dp.isSupported(Desktop.Action.BROWSE)) {
                    dp.browse(file.toURI());
                    return true;
                }
            }
            catch (Exception ex) {
                log.error("Failed to open the {} file in desktop mode.", (Object)file.getPath(), (Object)ex);
            }
        }
        return OSCmdUtils.openFileByXdgOpen(file);
    }

    public static boolean openFileByXdgOpen(File file) {
        if (Objects.isNull(file) || !file.exists()) {
            log.warn("file is empty");
            return false;
        }
        try {
            String cmd = "xdg-open '" + OSCmdUtils.normalizeLinuxPath(file.getCanonicalPath()) + "' > /dev/null 2>&1";
            ProcessBuilder builder = new ProcessBuilder("/bin/bash", "-c", cmd);
            log.info("Run the {} command to open the file.", (Object)String.join((CharSequence)" ", builder.command()));
            builder.inheritIO();
            builder.start();
            return true;
        }
        catch (IOException e) {
            log.error("Failed to open the {} file by running the xdg-open command.", (Object)file.getPath(), (Object)e);
            return false;
        }
    }

    public static String normalizeLinuxPath(String path) {
        return path.replaceAll("'", "'\"'\"'");
    }

    public static File selectFileToOpenInLinux(File htmlFile) {
        File replaceFile = htmlFile;
        try {
            String filePath = htmlFile.getCanonicalPath();
            String pdfPath = filePath.endsWith(".chm") ? filePath.substring(0, filePath.lastIndexOf(".chm")) + ".pdf" : filePath;
            replaceFile = Optional.of(pdfPath).map(File::new).filter(File::exists).orElse(htmlFile);
        }
        catch (IOException e) {
            LOGGER.error("html file is empty ", (Throwable)e);
        }
        return replaceFile;
    }

    public static boolean exeExportFile(String path) {
        return OSCmdUtils.exeExportFile(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exeExportFile(String path, boolean isSelect) {
        String params = Normalizer.normalize(path, Normalizer.Form.NFKC);
        if (!new File(params).exists()) {
            if (!new File(path).exists()) {
                return false;
            }
            params = path;
        }
        InputStream inputStream = null;
        String cmd = "explorer.exe ";
        if (isSelect) {
            params = "/select, " + params;
        }
        String[] commands = new String[]{cmd + params};
        Process pro = null;
        try {
            pro = OSCmdUtils.createCmdProcess(commands);
            inputStream = pro.getInputStream();
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(pro);
            Future<String> future = ThreadPool.getInstance().submit(streamClear);
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            boolean bl;
            try {
                LOGGER.error("Clear cmd output stream error :", (Throwable)e1);
                bl = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, inputStream);
                throw throwable;
            }
            StreamUtils.closeStream(null, inputStream);
            return bl;
        }
        StreamUtils.closeStream(null, inputStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exeExportByCmd(String cmd, int timeOut) {
        String normalizedCmd = Normalizer.normalize(cmd, Normalizer.Form.NFKC);
        InputStream inputStream = null;
        Process pro = null;
        try {
            pro = OSCmdUtils.createCmdProcess(normalizedCmd);
            inputStream = pro.getInputStream();
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(pro);
            Future<String> future = ThreadPool.getInstance().submit(streamClear);
            future.get(timeOut, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            boolean bl;
            try {
                LOGGER.error("Clear cmd output stream error :", (Throwable)e1);
                bl = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, inputStream);
                throw throwable;
            }
            StreamUtils.closeStream(null, inputStream);
            return bl;
        }
        StreamUtils.closeStream(null, inputStream);
        return true;
    }

    public static void explorerFile(String path) {
        OSCmdUtils.explorerFile(new File(path));
    }

    public static synchronized boolean isPortInUsing(int port, boolean isWindowsOS) {
        if (isWindowsOS) {
            String cmd = "netstat -aon | findstr " + port;
            String res = OSCmdUtils.executeCmd(cmd);
            return res.contains(":" + port);
        }
        return false;
    }

    public static void openWbesite(String helpFileStr) {
        if (null == helpFileStr) {
            LOGGER.error("helpFileStr is empty ");
            return;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop dp = Desktop.getDesktop();
                if (null != dp && dp.isSupported(Desktop.Action.BROWSE)) {
                    dp.browse(new URI(helpFileStr));
                }
            }
            catch (IOException ex) {
                LOGGER.error("can't get default browser", (Throwable)ex);
            }
            catch (URISyntaxException e) {
                LOGGER.error("system exception", (Throwable)e);
            }
        }
    }

    public static String executeCmdInPathDirectly(String cmdLine, String path) {
        String out = OSCmdUtils.executeCmd(cmdLine, path, 60);
        if (StringUtils.isNULLStr(out)) {
            LOGGER.info("out is null");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Executed command " + OSCmdUtils.quote(StringUtils.maskPassword(cmdLine)) + " in dir " + OSCmdUtils.quote(path));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getProcess(String processName) {
        boolean flag;
        block6: {
            flag = false;
            InputStream os = null;
            ByteArrayOutputStream byteStr = null;
            Process process = null;
            try {
                ProcessBuilder pb = new ProcessBuilder("cmd", "/c", "tasklist");
                pb = pb.redirectErrorStream(true);
                process = pb.start();
                byteStr = new ByteArrayOutputStream();
                os = process.getInputStream();
                byte[] bytes = new byte[256];
                while (os.read(bytes) > -1) {
                    byteStr.write(bytes);
                }
                String string = byteStr.toString("utf-8");
                flag = string.indexOf(processName) >= 0;
                StreamUtils.closeStream(null, os);
            }
            catch (IOException e) {
                LOGGER.error("get process failed.");
                flag = false;
                break block6;
            }
            finally {
                StreamUtils.closeStream(null, os);
                OSCmdUtils.closeByteStr(byteStr, process);
            }
            OSCmdUtils.closeByteStr(byteStr, process);
        }
        return flag;
    }

    private static void closeByteStr(ByteArrayOutputStream byteStr, Process process) {
        if (null != byteStr) {
            try {
                byteStr.close();
            }
            catch (IOException e) {
                LOGGER.error("IOException");
            }
        }
        if (null != process) {
            process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findProcessByName(String user, String procNames) {
        ArrayList<String> procLst = new ArrayList<String>();
        String cmdStr = "tasklist /FI \"USERNAME eq " + user + "\" /FI \"IMAGENAME eq " + procNames + "\"";
        Runtime run = Runtime.getRuntime();
        Process process = null;
        InputStream in = null;
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            process = run.exec(cmdStr);
            in = process.getInputStream();
            reader = new InputStreamReader(in);
            br = new BufferedReader(reader);
            String message = "";
            while ((message = br.readLine()) != null) {
                if (!message.contains(procNames)) continue;
                procLst.add(message);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to obtain user informatio.", (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("close IOException");
                }
            }
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error("close IOException");
                }
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("close IOException");
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
        return procLst;
    }

    public static void addOptimizationParam(StringBuffer env) {
        String jreVersion = BIT_64.equals(System.getProperty("sun.arch.data.model")) ? BIT_64 : BIT_32;
        env.append("set jreBit=").append(jreVersion).append(ENTER);
        String freeMemory = OSCmdUtils.getFreeMemory();
        env.append("set freeMemory=").append(freeMemory).append(ENTER);
        String osName = System.getProperty("os.name");
        String isWin2008 = osName != null && osName.indexOf("2008") != -1 ? YES : NO;
        env.append("set isWin2008=").append(isWin2008).append(ENTER);
    }

    private static String getFreeMemory() {
        String result = OSCmdUtils.executeCmd("wmic OS get FreePhysicalMemory /Value");
        int markIndex = result.indexOf(FREEMEMORY_MARK);
        if (markIndex > -1) {
            String freeMemoryStart = result.substring(markIndex + FREEMEMORY_MARK.length());
            String freeMemory = freeMemoryStart.substring(0, freeMemoryStart.indexOf(ENTER)).replaceAll("\r", "");
            try {
                int memorySize = Integer.parseInt(freeMemory) / 1024;
                return String.valueOf(memorySize);
            }
            catch (NumberFormatException e) {
                LOGGER.error("get freeMemory error, return default value.");
            }
        }
        return FREEMEMORY_DEFAULT;
    }

    public static class ProcessStreamClearCall
    implements Callable<String> {
        private Process process = null;
        private boolean isWaitfor = false;
        private boolean isSaveResult = true;
        private String cmd = "";
        private StringBuffer buff = new StringBuffer();

        public ProcessStreamClearCall(Process process) {
            this(process, false);
        }

        public ProcessStreamClearCall(Process process, boolean isWaitfor) {
            this(process, isWaitfor, true);
        }

        public ProcessStreamClearCall(Process process, boolean isWaitfor, boolean isSaveResult) {
            this.process = process;
            this.isWaitfor = isWaitfor;
            this.isSaveResult = isSaveResult;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public StringBuffer getBuff() {
            return this.buff;
        }

        public void setBuff(StringBuffer buff) {
            this.buff = buff;
        }

        @Override
        public String call() {
            try {
                this.refleshOutput(this.process.getInputStream());
                this.buff.append(ENTER);
                this.buff.append("stdout over---------------------------------------------------");
                this.buff.append(ENTER);
                this.refleshOutput(this.process.getErrorStream());
                this.buff.append(ENTER);
                this.buff.append("stderr over---------------------------------------------------");
                this.buff.append(ENTER);
            }
            catch (RuntimeException e) {
                LOGGER.error("Read ins error :", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Read ins error :", (Throwable)e);
            }
            if (this.isWaitfor) {
                while (true) {
                    try {
                        Thread.sleep(50L);
                        int processExitCode = this.process.exitValue();
                        this.getAvailableInputAndErrorStream();
                        this.buff.append("process exitValue:" + processExitCode);
                        if (!LOGGER.isInfoEnabled()) break;
                        LOGGER.info("cmd:" + FileUtils.filterLogIfComputerName(StringUtils.maskPassword(this.cmd)) + " exitcode->" + processExitCode);
                    }
                    catch (RuntimeException e) {
                        this.getAvailableInputAndErrorStream();
                        continue;
                    }
                    catch (InterruptedException ee) {
                        LOGGER.info("this process thread has been interrupted", (Throwable)ee);
                    }
                    break;
                }
            }
            return this.buff.toString();
        }

        private void getAvailableInputAndErrorStream() {
            try {
                this.refleshOutput(this.process.getInputStream());
                this.refleshOutput(this.process.getErrorStream());
            }
            catch (RuntimeException ex) {
                LOGGER.error("the second output error", (Throwable)ex);
            }
            catch (Exception ex) {
                LOGGER.error("the second output error", (Throwable)ex);
            }
        }

        private void refleshOutput(InputStream is) throws InterruptedException, IOException {
            int len;
            if (is == null) {
                return;
            }
            while ((len = is.available()) > 0) {
                IStartBsChangeListener startBsChangeListener;
                byte[] bs = new byte[len];
                int bSize = is.read(bs);
                String outputStr = new String(bs, 0, bSize, Charset.defaultCharset());
                if (this.isSaveResult) {
                    this.buff.append(outputStr);
                }
                if (null == (startBsChangeListener = ApplicationContext.getInstance().getStartBsChangeListener())) continue;
                startBsChangeListener.refreshCMDOutputStr(outputStr);
            }
        }
    }

    static class DeleteBatFileThread
    implements Runnable {
        private File batFile = null;

        public DeleteBatFileThread() {
        }

        public DeleteBatFileThread(File batFile) {
            this.batFile = batFile;
        }

        @Override
        public void run() {
            if (null == this.batFile) {
                throw new NullPointerException();
            }
            if (this.batFile.exists() && !this.batFile.delete()) {
                LOGGER.error("delete bat file error." + this.batFile);
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("delete bat file sucess." + this.batFile);
            }
        }
    }
}

