/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.text.Normalizer;

public class TooliniParser {
    public static final String APP_VERSION = "app.version";
    private static final String TOOLS = "tools";
    private static final String TOOL_BOX_SYSTEM_CFG = File.separator + "configuration" + File.separator + "system.properties";
    private static final String TOOL_INI = "tool.ini";
    public static final String TOOL_VERSION = "tool.version";

    public static String getToolBoxPath() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        if (StringUtils.isNULLStr(workPath)) {
            throw new NullPointerException();
        }
        int index = (workPath = Normalizer.normalize(workPath, Normalizer.Form.NFKC)).lastIndexOf(TOOLS);
        if (index > 0) {
            return workPath.substring(0, index);
        }
        return workPath;
    }

    public static String getToolIniProp(String peop) {
        String cfgFile = PlatformAppContext.getInstance().getRuntime().getWorkPath() + File.separator + TOOL_INI;
        File file = new File(cfgFile);
        if (file.exists()) {
            return new IniReader(file).getString(peop);
        }
        return "";
    }

    public static String getToolIniProp(String toolName, String peop) {
        String cfgFile = TooliniParser.getToolBoxPath() + File.separator + TOOLS + File.separator + toolName + File.separator + TOOL_INI;
        IniReader reader = new IniReader(new File(cfgFile));
        return reader.getString(peop);
    }

    public static boolean getToolIniBoolProp(String peop) {
        String cfgFile = ApplicationContext.getInstance().getWorkPath() + File.separator + TOOL_INI;
        IniReader reader = new IniReader(new File(cfgFile));
        return "true".equals(reader.getString(peop));
    }

    public static String getToolIniPath() {
        String cfgFile = ApplicationContext.getInstance().getWorkPath() + File.separator + TOOL_INI;
        return cfgFile;
    }

    public static String getToolBoxIniProp(String peop) {
        String cfgFile = TooliniParser.getToolBoxPath() + TOOL_BOX_SYSTEM_CFG;
        return ResourceUtil.getPropOfFile(cfgFile, peop);
    }
}

